/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.support.common.UnifyQueryClient;
import com.elitescloud.boot.core.support.common.param.UnifyQueryParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.openfeign.common.DynamicClientHelper;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.dto.req.UnifyQueryQueryDTO;
import com.elitescloud.cloudt.system.dto.req.UnifySqlQueryQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.UnifyQueryRespDTO;
import com.elitescloud.cloudt.system.model.bo.BusinessObjectBO;
import com.elitescloud.cloudt.system.model.bo.BusinessParamBO;
import com.elitescloud.cloudt.system.model.bo.UnifyQueryParamBO;
import com.elitescloud.cloudt.system.service.SysUnifyQueryQueryService;
import com.elitescloud.cloudt.system.service.common.constant.UnifyQueryTypeEnum;
import com.elitescloud.cloudt.system.service.model.entity.SysUnifyQueryRecordDO;
import com.elitescloud.cloudt.system.service.repo.AppRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessObjectRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessParamRepoProc;
import com.elitescloud.cloudt.system.service.repo.UnifyQueryRepoProc;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class SysUnifyQueryQueryServiceImpl
implements SysUnifyQueryQueryService {
    private static final Logger log = LoggerFactory.getLogger(SysUnifyQueryQueryServiceImpl.class);
    @Autowired
    private UnifyQueryRepoProc repoProc;
    @Autowired
    private BusinessObjectRepoProc businessObjectRepoProc;
    @Autowired
    private BusinessParamRepoProc businessParamRepoProc;
    @Autowired
    private AppRepoProc appRepoProc;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private TextEncryptor textEncryptor;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private SystemProperties systemProperties;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<UnifyQueryRespDTO> query(UnifyQueryQueryDTO paramDTO) {
        UnifyQueryParamBO paramBO = null;
        try {
            paramBO = this.convertAndCheckParam(paramDTO);
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u67e5\u8be2\u5931\u8d25\uff0c" + e.getMessage()));
        }
        SysUnifyQueryRecordDO recordDO = this.convertParam2DO(paramDTO);
        paramBO.getConditionFileTypes().putAll(paramDTO.getConditionFieldTypes());
        recordDO.setQueryTime(LocalDateTime.now());
        this.repoProc.save((Serializable)recordDO);
        try {
            List<Map<String, Object>> queryResult = this.queryByRpc(recordDO, paramBO);
            LocalDateTime finishTime = LocalDateTime.now();
            String queryResultStr = Boolean.FALSE.equals(this.systemProperties.getUnifyQuery().getSaveQueryResult()) ? null : JSONUtil.toJsonString(queryResult);
            this.repoProc.updateQueryResult(recordDO.getId(), true, queryResultStr, null, finishTime, Duration.between(recordDO.getQueryTime(), finishTime).toMillis());
            return ApiResult.ok((Object)new UnifyQueryRespDTO(Boolean.valueOf(true), recordDO.getId().toString(), queryResult, null));
        }
        catch (Exception e) {
            log.error("\u7edf\u4e00\u67e5\u8be2\u5f02\u5e38\uff1a{}", (Object)recordDO.getId(), (Object)e);
            LocalDateTime finishTime = LocalDateTime.now();
            this.repoProc.updateQueryResult(recordDO.getId(), false, null, e.getMessage(), finishTime, Duration.between(recordDO.getQueryTime(), finishTime).toMillis());
            return ApiResult.ok((Object)new UnifyQueryRespDTO(Boolean.valueOf(false), recordDO.getId().toString(), null, e.getMessage()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<UnifyQueryRespDTO> queryBySql(UnifySqlQueryQueryDTO paramDTO) {
        UnifyQueryParamBO paramBO = null;
        try {
            paramBO = this.convertAndCheckParam(paramDTO);
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u67e5\u8be2\u5931\u8d25\uff0c" + e.getMessage()));
        }
        SysUnifyQueryRecordDO recordDO = this.convertParam2DO(paramDTO);
        recordDO.setQueryTime(LocalDateTime.now());
        this.repoProc.save((Serializable)recordDO);
        try {
            List<Map<String, Object>> queryResult = this.queryByRpc(recordDO, paramBO);
            LocalDateTime finishTime = LocalDateTime.now();
            String queryResultStr = Boolean.FALSE.equals(this.systemProperties.getUnifyQuery().getSaveQueryResult()) ? null : JSONUtil.toJsonString(queryResult);
            this.repoProc.updateQueryResult(recordDO.getId(), true, queryResultStr, null, finishTime, Duration.between(recordDO.getQueryTime(), finishTime).toMillis());
            return ApiResult.ok((Object)new UnifyQueryRespDTO(Boolean.valueOf(true), recordDO.getId().toString(), queryResult, null));
        }
        catch (Exception e) {
            log.error("\u7edf\u4e00\u67e5\u8be2\u5f02\u5e38\uff1a{}", (Object)recordDO.getId(), (Object)e);
            LocalDateTime finishTime = LocalDateTime.now();
            this.repoProc.updateQueryResult(recordDO.getId(), false, null, e.getMessage(), finishTime, Duration.between(recordDO.getQueryTime(), finishTime).toMillis());
            return ApiResult.ok((Object)new UnifyQueryRespDTO(Boolean.valueOf(false), recordDO.getId().toString(), null, e.getMessage()));
        }
    }

    private List<Map<String, Object>> queryByRpc(SysUnifyQueryRecordDO recordDO, UnifyQueryParamBO queryParamBO) {
        UnifyQueryClient client = (UnifyQueryClient)DynamicClientHelper.getClient((String)recordDO.getAppCode(), UnifyQueryClient.class, (String)"/secRpc/cloudt/unifyQuery");
        UnifyQueryParam queryParam = new UnifyQueryParam();
        queryParam.setUnifyId(recordDO.getId().toString());
        queryParam.setUnifyVerifier(UUID.fastUUID().toString());
        if (queryParamBO.getQueryType() == UnifyQueryTypeEnum.JPQL) {
            queryParam.setFields(queryParamBO.getBusinessObjectQuery().getQueryFields());
            queryParam.setJpql(recordDO.getSqlTxt());
        } else if (queryParamBO.getQueryType() == UnifyQueryTypeEnum.SQL) {
            queryParam.setSql(recordDO.getSqlTxt());
        } else {
            throw new BusinessException("\u6682\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u7c7b\u578b");
        }
        queryParam.setParams(queryParamBO.getConditions());
        queryParam.setParamsFieldTypes(queryParamBO.getConditionFileTypes());
        this.redisUtils.set(queryParam.getUnifyId(), (Object)this.textEncryptor.encrypt(queryParam.getUnifyVerifier()), 2L, TimeUnit.MINUTES);
        ApiResult rpcResult = client.query(queryParam);
        return (List)rpcResult.computeData();
    }

    private UnifyQueryParamBO convertAndCheckParam(UnifySqlQueryQueryDTO paramDTO) {
        Assert.notNull((Object)paramDTO, (String)"\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)paramDTO.getSql(), (String)"SQL\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)paramDTO.getAppCode(), (String)"appCode\u4e3a\u7a7a", (Object[])new Object[0]);
        String appCode = (String)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.appRepoProc.getCode(paramDTO.getAppCode()));
        Assert.notBlank((CharSequence)appCode, (String)("\u5e94\u7528" + paramDTO.getAppCode() + "\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
        UnifyQueryParamBO paramBO = new UnifyQueryParamBO();
        paramBO.setAppCode(paramDTO.getAppCode());
        paramBO.setQueryType(UnifyQueryTypeEnum.SQL);
        paramBO.setSqlQuery(new UnifyQueryParamBO.SQL(paramDTO.getSql()));
        paramBO.setConditions(paramDTO.getConditions());
        return paramBO;
    }

    private SysUnifyQueryRecordDO convertParam2DO(UnifySqlQueryQueryDTO paramDTO) {
        SysUnifyQueryRecordDO recordDO = new SysUnifyQueryRecordDO();
        recordDO.setUserId(SecurityContextUtil.currentUserId());
        recordDO.setSuccess(Boolean.valueOf(false));
        recordDO.setAppCode(paramDTO.getAppCode());
        recordDO.setBusinessParams(JSONUtil.toJsonString((Object)paramDTO.getConditions()));
        recordDO.setQueryType(UnifyQueryTypeEnum.SQL.name());
        recordDO.setSqlTxt(paramDTO.getSql());
        recordDO.setSqlParams(recordDO.getBusinessParams());
        return recordDO;
    }

    private UnifyQueryParamBO convertAndCheckParam(UnifyQueryQueryDTO paramDTO) {
        Assert.notNull((Object)paramDTO, (String)"\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)paramDTO.getBusinessObjectCode(), (String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> businessParams = CollUtil.isEmpty((Collection)paramDTO.getQueryFields()) ? Collections.emptyList() : paramDTO.getQueryFields().stream().filter(StringUtils::hasText).collect(Collectors.toList());
        UnifyQueryParamBO paramBO = new UnifyQueryParamBO();
        String appCode = (String)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.businessObjectRepoProc.getAppCode(paramDTO.getBusinessObjectCode()));
        Assert.notBlank((CharSequence)appCode, (String)("\u4e1a\u52a1\u5bf9\u8c61" + paramDTO.getBusinessObjectCode() + "\u4e0d\u5b58\u5728\u6216\u6240\u5c5e\u5e94\u7528\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
        paramBO.setAppCode(appCode);
        paramBO.setQueryType(UnifyQueryTypeEnum.JPQL);
        paramBO.setBusinessObjectQuery(new UnifyQueryParamBO.BusinessObject(paramDTO.getBusinessObjectCode(), businessParams));
        paramBO.setConditions(paramDTO.getConditions());
        paramBO.setConditionFileTypes((Map)ObjUtil.defaultIfNull((Object)paramDTO.getConditionFieldTypes(), new HashMap(0)));
        return paramBO;
    }

    private SysUnifyQueryRecordDO convertParam2DO(UnifyQueryQueryDTO paramDTO) {
        SysUnifyQueryRecordDO recordDO = new SysUnifyQueryRecordDO();
        recordDO.setUserId(SecurityContextUtil.currentUserId());
        recordDO.setSuccess(Boolean.valueOf(false));
        recordDO.setBusinessObjectCode(paramDTO.getBusinessObjectCode());
        Map<String, BusinessParamBO> paramAll = ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            BusinessObjectBO businessObject = this.businessObjectRepoProc.getSimple(paramDTO.getBusinessObjectCode());
            if (businessObject == null || Boolean.FALSE.equals(businessObject.getEnabled())) {
                throw new BusinessException("\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528");
            }
            recordDO.setAppCode(businessObject.getAppCode());
            if (CharSequenceUtil.isBlank((CharSequence)businessObject.getAppCode())) {
                throw new BusinessException("\u672a\u77e5\u4e1a\u52a1\u5bf9\u8c61\u7684\u6240\u5c5e\u5e94\u7528");
            }
            return this.businessParamRepoProc.listSimpleBoByBusinessObjectCode(paramDTO.getBusinessObjectCode());
        })).stream().collect(Collectors.toMap(BusinessParamBO::getFieldName, Function.identity(), (t1, t2) -> t1));
        if (paramAll.isEmpty()) {
            throw new BusinessException("\u4e1a\u52a1\u5bf9\u8c61\u7684\u53c2\u6570\u4e3a\u7a7a");
        }
        for (String queryField : paramDTO.getQueryFields()) {
            if (paramAll.containsKey(queryField)) continue;
            throw new BusinessException("\u4e1a\u52a1\u5bf9\u8c61" + paramDTO.getBusinessObjectCode() + "\u4e0d\u5b58\u5728\u53c2\u6570: " + queryField);
        }
        recordDO.setBusinessFields(String.join((CharSequence)",", paramDTO.getQueryFields()));
        if (CollUtil.isNotEmpty((Map)paramDTO.getConditions())) {
            if (paramDTO.getConditionFieldTypes() == null) {
                paramDTO.setConditionFieldTypes(new HashMap(paramDTO.getConditions().size()));
            }
            for (String s : paramDTO.getConditions().keySet()) {
                if (!paramAll.containsKey(s)) {
                    throw new BusinessException("\u4e1a\u52a1\u5bf9\u8c61" + paramDTO.getBusinessObjectCode() + "\u4e0d\u5b58\u5728\u53c2\u6570: " + s);
                }
                paramDTO.getConditionFieldTypes().putIfAbsent(s, paramAll.get(s).getFieldJavaType());
            }
        }
        recordDO.setBusinessParams(JSONUtil.toJsonString((Object)paramDTO.getConditions()));
        recordDO.setQueryType(UnifyQueryTypeEnum.JPQL.name());
        recordDO.setSqlTxt(this.buildSQL(paramDTO, paramAll));
        recordDO.setSqlParams(recordDO.getBusinessParams());
        return recordDO;
    }

    private String buildSQL(UnifyQueryQueryDTO paramDTO, Map<String, BusinessParamBO> businessParamMap) {
        StringBuilder sql = new StringBuilder();
        String tableAlias = "t";
        String entityName = this.obtainEntityName(new ArrayList<BusinessParamBO>(businessParamMap.values()).get(0));
        sql.append("select ");
        int i = 0;
        for (String queryField : paramDTO.getQueryFields()) {
            if (i == 0) {
                sql.append(tableAlias).append(".").append(queryField);
            } else {
                sql.append(", ").append(tableAlias).append(".").append(queryField);
            }
            ++i;
        }
        sql.append(" from ").append(entityName).append(" ").append(tableAlias).append(" ");
        if (CollUtil.isNotEmpty((Map)paramDTO.getConditions())) {
            sql.append(" where ");
            i = 0;
            String conditionRelation = paramDTO.getAnd() == null || paramDTO.getAnd() != false ? "and" : "or";
            boolean valueEquals = paramDTO.getEquals() == null || paramDTO.getEquals() != false;
            String valueRelation = "=";
            Class<?> valueType = null;
            for (Map.Entry entry : paramDTO.getConditions().entrySet()) {
                Class<?> clazz = valueType = entry.getValue() == null ? null : entry.getValue().getClass();
                String string = valueType != null && valueType.isArray() || entry.getValue() instanceof Iterable ? (valueEquals ? "in" : "not in") : (valueRelation = valueEquals ? "=" : "<>");
                if (i != 0) {
                    sql.append(" ").append(conditionRelation).append(" ");
                }
                sql.append((String)entry.getKey()).append(" ");
                if (entry.getValue() == null) {
                    sql.append("is null");
                } else {
                    sql.append(valueRelation).append(" :").append((String)entry.getKey());
                }
                ++i;
            }
        }
        return sql.toString();
    }

    private String obtainEntityName(BusinessParamBO businessParam) {
        if (CharSequenceUtil.isBlank((CharSequence)businessParam.getEntityClassName())) {
            return null;
        }
        return businessParam.getEntityClassName().substring(businessParam.getEntityClassName().lastIndexOf(".") + 1);
    }
}

