/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.dto.SysUserTerminalSaveDTO;
import com.elitescloud.cloudt.system.model.entity.SysUserTerminalDO;
import com.elitescloud.cloudt.system.service.SysUserTerminalService;
import com.elitescloud.cloudt.system.service.repo.SysUserTerminalRepo;
import com.elitescloud.cloudt.system.service.repo.SysUserTerminalRepoProc;
import com.elitescloud.cloudt.system.service.repo.old.SysUserRepoProc;
import com.elitescloud.cloudt.system.service.vo.save.SysUserTerminalSaveVO;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT_USER)
@TenantOrgTransaction(useTenantOrg=false)
public class SysUserTerminalServiceImpl
implements SysUserTerminalService {
    private static final Logger log = LoggerFactory.getLogger(SysUserTerminalServiceImpl.class);
    private final SysUserTerminalRepo userTerminalRepo;
    private final SysUserTerminalRepoProc userTerminalRepoProc;
    private final SysUserRepoProc userRepoProc;

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public ApiResult<Long> save(SysUserTerminalSaveVO saveVO) {
        this.updateByUser(saveVO.getUserId(), (Set)ObjectUtil.defaultIfNull((Object)saveVO.getTerminals(), Collections.emptySet()));
        return ApiResult.ok((Object)saveVO.getUserId());
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public ApiResult<Long> save(SysUserTerminalSaveDTO saveParam) {
        this.updateByUser(saveParam.getUserId(), (Set)ObjectUtil.defaultIfNull((Object)saveParam.getTerminals(), Collections.emptySet()));
        return ApiResult.ok((Object)saveParam.getUserId());
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public ApiResult<Long> save(Long userId, Set<Terminal> terminals) {
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e3a\u7a7a");
        this.updateByUser(userId, (Set)ObjectUtil.defaultIfNull(terminals, Collections.emptySet()));
        return ApiResult.ok((Object)userId);
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public ApiResult<Long> saveForAdd(SysUserTerminalSaveDTO saveParam) {
        Set terminals = saveParam.getTerminals();
        List<Terminal> oldTerminals = this.userTerminalRepoProc.getTerminalByUserId(saveParam.getUserId());
        if (!oldTerminals.isEmpty()) {
            terminals = terminals.stream().filter(t -> !oldTerminals.contains(t)).collect(Collectors.toSet());
        }
        if (terminals.isEmpty()) {
            return ApiResult.ok((Object)saveParam.getUserId());
        }
        this.add(saveParam.getUserId(), terminals);
        return ApiResult.ok((Object)saveParam.getUserId());
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public ApiResult<Long> saveForAdd(Long userId, Set<Terminal> terminals) {
        Assert.notNull((Object)userId, (String)"\u672a\u77e5\u7528\u6237ID");
        if (CollUtil.isEmpty(terminals)) {
            return ApiResult.fail((String)"\u7ec8\u7aef\u4e3a\u7a7a");
        }
        List<Terminal> oldTerminals = this.userTerminalRepoProc.getTerminalByUserId(userId);
        if (!oldTerminals.isEmpty()) {
            terminals = terminals.stream().filter(t -> !oldTerminals.contains(t)).collect(Collectors.toSet());
        }
        if (terminals.isEmpty()) {
            return ApiResult.ok((Object)userId);
        }
        this.add(userId, terminals);
        return ApiResult.ok((Object)userId);
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public ApiResult<Long> saveForReduce(SysUserTerminalSaveDTO saveParam) {
        Set terminals = saveParam.getTerminals().stream().map(Enum::name).collect(Collectors.toSet());
        if (terminals.isEmpty()) {
            return ApiResult.ok((Object)saveParam.getUserId());
        }
        List<SysUserTerminalDO> userTerminals = this.userTerminalRepoProc.queryByUserId(saveParam.getUserId());
        if (userTerminals.isEmpty()) {
            return ApiResult.ok((Object)saveParam.getUserId());
        }
        List<Long> toDelIds = userTerminals.stream().filter(t -> terminals.contains(t.getTerminalCode())).map(BaseModel::getId).collect(Collectors.toList());
        if (!toDelIds.isEmpty()) {
            this.userTerminalRepoProc.deleteById(toDelIds);
        }
        return ApiResult.ok((Object)saveParam.getUserId());
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public ApiResult<List<Terminal>> getByUser(Long userId) {
        List<Terminal> terminals = this.userTerminalRepoProc.getTerminalByUserId(userId);
        return ApiResult.ok(terminals);
    }

    public ApiResult<List<Terminal>> getByUser(String username) {
        Long userId = this.userRepoProc.getIdByUsername(username);
        if (userId == null) {
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        List<Terminal> terminals = this.userTerminalRepoProc.getTerminalByUserId(userId);
        return ApiResult.ok(terminals);
    }

    public ApiResult<Map<Long, List<Terminal>>> getByUser(List<Long> userIds) {
        Map<Long, List<Terminal>> userTerminal = this.userTerminalRepoProc.getTerminalByUserId(userIds);
        return ApiResult.ok(userTerminal);
    }

    private void updateByUser(Long userId, Set<Terminal> terminals) {
        List<SysUserTerminalDO> oldDOList = this.userTerminalRepoProc.queryByUserId(userId);
        if (CollUtil.isNotEmpty(oldDOList)) {
            Set finalNewTerminals = terminals.stream().map(Enum::name).collect(Collectors.toSet());
            List<Long> toDelIds = oldDOList.stream().filter(t -> !finalNewTerminals.contains(t.getTerminalCode())).map(BaseModel::getId).collect(Collectors.toList());
            if (!toDelIds.isEmpty()) {
                this.userTerminalRepoProc.deleteById(toDelIds);
            }
            if (!terminals.isEmpty()) {
                Set oldTerminalCode = oldDOList.stream().map(SysUserTerminalDO::getTerminalCode).collect(Collectors.toSet());
                terminals = terminals.stream().filter(t -> !oldTerminalCode.contains(t.name())).collect(Collectors.toSet());
            }
        }
        this.add(userId, terminals);
    }

    private void add(Long userId, Set<Terminal> terminals) {
        if (!terminals.isEmpty()) {
            LocalDateTime nowTime = LocalDateTime.now();
            List newDataList = terminals.stream().map(t -> {
                SysUserTerminalDO terminalDO = new SysUserTerminalDO();
                terminalDO.setTerminalCode(t.name());
                terminalDO.setUserId(userId);
                terminalDO.setTimeBind(nowTime);
                return terminalDO;
            }).collect(Collectors.toList());
            this.userTerminalRepo.saveAll(newDataList);
        }
    }

    public SysUserTerminalRepo getUserTerminalRepo() {
        return this.userTerminalRepo;
    }

    public SysUserTerminalRepoProc getUserTerminalRepoProc() {
        return this.userTerminalRepoProc;
    }

    public SysUserRepoProc getUserRepoProc() {
        return this.userRepoProc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SysUserTerminalServiceImpl)) {
            return false;
        }
        SysUserTerminalServiceImpl other = (SysUserTerminalServiceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SysUserTerminalRepo this$userTerminalRepo = this.getUserTerminalRepo();
        SysUserTerminalRepo other$userTerminalRepo = other.getUserTerminalRepo();
        if (this$userTerminalRepo == null ? other$userTerminalRepo != null : !this$userTerminalRepo.equals(other$userTerminalRepo)) {
            return false;
        }
        SysUserTerminalRepoProc this$userTerminalRepoProc = this.getUserTerminalRepoProc();
        SysUserTerminalRepoProc other$userTerminalRepoProc = other.getUserTerminalRepoProc();
        if (this$userTerminalRepoProc == null ? other$userTerminalRepoProc != null : !((Object)((Object)this$userTerminalRepoProc)).equals((Object)other$userTerminalRepoProc)) {
            return false;
        }
        SysUserRepoProc this$userRepoProc = this.getUserRepoProc();
        SysUserRepoProc other$userRepoProc = other.getUserRepoProc();
        return !(this$userRepoProc == null ? other$userRepoProc != null : !((Object)((Object)this$userRepoProc)).equals((Object)other$userRepoProc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SysUserTerminalServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SysUserTerminalRepo $userTerminalRepo = this.getUserTerminalRepo();
        result = result * 59 + ($userTerminalRepo == null ? 43 : $userTerminalRepo.hashCode());
        SysUserTerminalRepoProc $userTerminalRepoProc = this.getUserTerminalRepoProc();
        result = result * 59 + ($userTerminalRepoProc == null ? 43 : ((Object)((Object)$userTerminalRepoProc)).hashCode());
        SysUserRepoProc $userRepoProc = this.getUserRepoProc();
        result = result * 59 + ($userRepoProc == null ? 43 : ((Object)((Object)$userRepoProc)).hashCode());
        return result;
    }

    public String toString() {
        return "SysUserTerminalServiceImpl(userTerminalRepo=" + String.valueOf(this.getUserTerminalRepo()) + ", userTerminalRepoProc=" + String.valueOf((Object)this.getUserTerminalRepoProc()) + ", userRepoProc=" + String.valueOf((Object)this.getUserRepoProc()) + ")";
    }

    public SysUserTerminalServiceImpl(SysUserTerminalRepo userTerminalRepo, SysUserTerminalRepoProc userTerminalRepoProc, SysUserRepoProc userRepoProc) {
        this.userTerminalRepo = userTerminalRepo;
        this.userTerminalRepoProc = userTerminalRepoProc;
        this.userRepoProc = userRepoProc;
    }
}

