/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.auth.cas.model.pwd.AuthPwdStrategyConfigDTO;
import com.elitescloud.boot.auth.cas.model.pwd.AuthPwdStrategySaveDTO;
import com.elitescloud.boot.auth.cas.provider.PwdStrategyTransferHelper;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.sys.PwdStrategyConfigRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.PwdStrategyPlatformRespVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.PwdStrategySaveVO;
import com.elitescloud.cloudt.system.service.SystemMngService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemMngServiceImpl
implements SystemMngService {
    @Autowired(required=false)
    private PwdStrategyTransferHelper pwdStrategyTransferHelper;

    @Override
    public ApiResult<Boolean> save(List<PwdStrategySaveVO> saveVOList) {
        Result saveResult;
        if (this.pwdStrategyTransferHelper == null) {
            return ApiResult.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u672a\u542f\u7528\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1");
        }
        ArrayList<AuthPwdStrategySaveDTO> saveDTOList = new ArrayList<AuthPwdStrategySaveDTO>(16);
        if (CollUtil.isNotEmpty(saveVOList)) {
            HashSet<String> existsCodes = new HashSet<String>(16);
            for (PwdStrategySaveVO saveVO : saveVOList) {
                if (existsCodes.contains(saveVO.getStrategyCode())) continue;
                existsCodes.add(saveVO.getStrategyCode());
                AuthPwdStrategySaveDTO saveDTO = new AuthPwdStrategySaveDTO();
                saveDTO.setStrategyCode(saveVO.getStrategyCode());
                saveDTO.setParams(saveVO.getParams());
                saveDTOList.add(saveDTO);
            }
        }
        if (Boolean.FALSE.equals((saveResult = this.pwdStrategyTransferHelper.save(saveDTOList)).getSuccess())) {
            return ApiResult.fail((String)saveResult.getMsg());
        }
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<PwdStrategyConfigRespVO> getPwdStrategy() {
        if (this.pwdStrategyTransferHelper == null) {
            return ApiResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u672a\u542f\u7528\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1");
        }
        return this.getPwdStrategy(false);
    }

    @Override
    public ApiResult<PwdStrategyConfigRespVO> getDefaultPwdStrategy() {
        if (this.pwdStrategyTransferHelper == null) {
            return ApiResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u672a\u542f\u7528\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1");
        }
        return this.getPwdStrategy(true);
    }

    private ApiResult<PwdStrategyConfigRespVO> getPwdStrategy(boolean def) {
        Result queryResult;
        Result result = queryResult = def ? this.pwdStrategyTransferHelper.getDefault() : this.pwdStrategyTransferHelper.get();
        if (Boolean.FALSE.equals(queryResult.getSuccess())) {
            return ApiResult.fail((String)queryResult.getMsg());
        }
        PwdStrategyConfigRespVO respVO = new PwdStrategyConfigRespVO();
        AuthPwdStrategyConfigDTO dataDTO = (AuthPwdStrategyConfigDTO)queryResult.getData();
        if (dataDTO == null) {
            respVO.setDefaultCfg(true);
            return ApiResult.ok((Object)respVO);
        }
        respVO.setDefaultCfg(dataDTO.getDefaultCfg());
        respVO.setStrategyList(CollUtil.isEmpty((Collection)dataDTO.getStrategyList()) ? Collections.emptyList() : dataDTO.getStrategyList().stream().map(t -> {
            PwdStrategyPlatformRespVO vo = new PwdStrategyPlatformRespVO();
            vo.setCode(t.getCode());
            vo.setName(t.getName());
            vo.setExpression(t.getExpression());
            vo.setParameters(t.getParameters());
            vo.setReleatePlatform(t.getBound());
            vo.setRequired(t.getRequired());
            return vo;
        }).collect(Collectors.toList()));
        return ApiResult.ok((Object)respVO);
    }
}

