/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.cas.common.PwdStrategyTypeEnum;
import com.elitescloud.boot.auth.cas.provider.PwdStrategyTransferHelper;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAppRepoProc;
import com.elitescloud.cloudt.system.common.OuterAppAuthProvider;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.model.vo.CommonTenantAppVO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonAppPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonDataRelationQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.CurrencyRateQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysBankBranchPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysBankPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.udc.UdcPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonDataRelationRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonDataSelectorListRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonTaxRateRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.OuterAppSettingRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.SysBankBranchRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.SysBankRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.PwdStrategyRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.udc.UdcWithValuesPageRespVO;
import com.elitescloud.cloudt.system.service.AreaQueryService;
import com.elitescloud.cloudt.system.service.CurrencyQueryService;
import com.elitescloud.cloudt.system.service.CurrencyRateQueryService;
import com.elitescloud.cloudt.system.service.DataRelationInstQueryService;
import com.elitescloud.cloudt.system.service.DataSelectorQueryService;
import com.elitescloud.cloudt.system.service.SysBankQueryService;
import com.elitescloud.cloudt.system.service.SystemQueryService;
import com.elitescloud.cloudt.system.service.TaxRateQueryService;
import com.elitescloud.cloudt.system.service.UdcQueryService;
import com.elitescloud.cloudt.system.service.common.constant.AppAuthTypeEnum;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformAppDO;
import com.elitescloud.cloudt.system.service.model.vo.CommonAreaQueryVO;
import com.elitescloud.cloudt.system.service.model.vo.CommonAreaTreeQueryVO;
import com.elitescloud.cloudt.system.service.model.vo.CommonAreaTreeRespVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class SystemQueryServiceImpl
extends BaseServiceImpl
implements SystemQueryService {
    private static final Logger log = LogManager.getLogger(SystemQueryServiceImpl.class);
    @Autowired
    private SysPlatformAppRepoProc appRepoProc;
    @Autowired
    private AreaQueryService areaQueryService;
    @Autowired
    private CurrencyQueryService currencyQueryService;
    @Autowired
    private TaxRateQueryService taxRateQueryService;
    @Autowired
    private CurrencyRateQueryService currencyRateQueryService;
    @Autowired(required=false)
    private PwdStrategyTransferHelper pwdStrategyTransferHelper;
    @Autowired
    private ObjectProvider<OuterAppAuthProvider> outerAppAuthProviders;
    @Autowired
    private DataSelectorQueryService dataSelectorQueryService;
    @Autowired
    private DataRelationInstQueryService dataRelationInstQueryService;
    @Autowired
    private UdcQueryService udcQueryService;
    @Autowired
    private SysBankQueryService sysBankQueryService;

    @Override
    public ApiResult<List<CommonTenantAppVO>> listApp(Boolean outerApp, Boolean authed) {
        HashSet filterAppCodes = new HashSet(64);
        if (super.isTenantUser()) {
            SysTenantDTO tenant = super.currentTenant();
            if (tenant == null || CollectionUtils.isEmpty((Collection)tenant.getAppCodes())) {
                return ApiResult.ok(Collections.emptyList());
            }
            filterAppCodes.addAll(tenant.getAppCodes());
        }
        List appList = ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.appRepoProc.allEnabled(outerApp, authed))).stream().filter(t -> filterAppCodes.isEmpty() || filterAppCodes.contains(t.getAppCode())).map(t -> new CommonTenantAppVO(t.getAppCode(), t.getAppName(), t.getIcon(), t.getAppOrder(), t.getAdaptedTerminal())).collect(Collectors.toList());
        return ApiResult.ok(appList);
    }

    @Override
    public ApiResult<PagingVO<CommonTenantAppVO>> pageApp(CommonAppPageQueryVO queryVO) {
        List listData = (List)this.listApp(queryVO.getOuterApp(), queryVO.getAuthed()).getData();
        if (CollectionUtils.isEmpty((Collection)listData)) {
            return ApiResult.ok((Object)PagingVO.empty());
        }
        PageRequest pageRequest = queryVO.getPageRequest();
        int offset = (int)pageRequest.getOffset();
        List recordList = CollUtil.sub((List)listData, (int)offset, (int)(offset + pageRequest.getPageSize()));
        PagingVO pageData = PagingVO.builder().total((long)listData.size()).records(recordList).build();
        return ApiResult.ok((Object)pageData);
    }

    @Override
    public ApiResult<List<CommonAreaTreeRespVO>> listArea(CommonAreaQueryVO queryVO) {
        return this.areaQueryService.listArea(queryVO);
    }

    @Override
    public ApiResult<List<CommonAreaTreeRespVO>> treeArea(CommonAreaTreeQueryVO queryVO) {
        return this.areaQueryService.treeArea(queryVO);
    }

    @Override
    public ApiResult<List<CodeNameParam>> listCurrency() {
        return this.currencyQueryService.listCurrency();
    }

    @Override
    public ApiResult<List<CommonTaxRateRespVO>> listTaxRate(String taxRateNo, String taxRateType) {
        return this.taxRateQueryService.queryList(taxRateNo, taxRateType);
    }

    @Override
    public ApiResult<Double> queryCurrentRate(CurrencyRateQueryVO queryVO) {
        return this.currencyRateQueryService.findRatio(queryVO);
    }

    @Override
    public ApiResult<PagingVO<SysBankRespVO>> pageQueryBank(SysBankPageQueryVO queryVO) {
        return this.sysBankQueryService.pageQueryBank(queryVO);
    }

    @Override
    public ApiResult<PagingVO<SysBankBranchRespVO>> pageQueryBankBranch(SysBankBranchPageQueryVO queryVO) {
        return this.sysBankQueryService.pageQueryBankBranch(queryVO);
    }

    @Override
    public ApiResult<List<PwdStrategyRespVO>> listPwdStrategyForCreateAccount() {
        if (this.pwdStrategyTransferHelper == null) {
            return ApiResult.fail((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        Result queryResult = this.pwdStrategyTransferHelper.listByType(PwdStrategyTypeEnum.PWD_UPDATE);
        if (Boolean.FALSE.equals(queryResult.getSuccess())) {
            return ApiResult.fail((String)queryResult.getMsg());
        }
        List strategyList = ((ArrayList)queryResult.getData()).stream().map(t -> {
            PwdStrategyRespVO respVO = new PwdStrategyRespVO();
            respVO.setStrategyCode(t.getCode());
            respVO.setStrategyName(t.getName());
            respVO.setExpression(t.getExpression());
            respVO.setParams((String[])ObjectUtil.defaultIfNull((Object)t.getParameters(), () -> new String[0]));
            return respVO;
        }).collect(Collectors.toList());
        return ApiResult.ok(strategyList);
    }

    @Override
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ApiResult<List<OuterAppSettingRespVO>> listOuterAppSettings() {
        SysTenantDTO currentTenant = super.currentTenant();
        List outerAppList = this.appRepoProc.listOuterApp(currentTenant == null ? null : currentTenant.getId());
        if (outerAppList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Set<String> authedCustomAppCodes = outerAppList.stream().filter(t -> AppAuthTypeEnum.CUSTOM.name().equals(t.getAuthType())).map(SysPlatformAppDO::getAppCode).collect(Collectors.toSet());
        if (!authedCustomAppCodes.isEmpty()) {
            OuterAppAuthProvider authProvider = (OuterAppAuthProvider)this.outerAppAuthProviders.getIfUnique();
            authedCustomAppCodes = authProvider == null ? Collections.emptySet() : (Set)ObjectUtil.defaultIfNull(authProvider.filterAuthed(authedCustomAppCodes), Collections.emptySet());
        }
        Set<String> finalAuthedCustomAppCodes = authedCustomAppCodes;
        List appList = outerAppList.stream().map(t -> {
            OuterAppSettingRespVO respVO = new OuterAppSettingRespVO();
            respVO.setAppCode(t.getAppCode());
            respVO.setAppName(t.getAppName());
            respVO.setIcon(t.getIcon());
            respVO.setShow(AppAuthTypeEnum.UNNECESSARY.name().equals(t.getAuthType()) || finalAuthedCustomAppCodes.contains(t.getAppCode()));
            respVO.setUrl(t.getUrl());
            respVO.setTokenUrl(t.getTokenUrl());
            return respVO;
        }).collect(Collectors.toList());
        return ApiResult.ok(appList);
    }

    @Override
    public ApiResult<List<CommonDataSelectorListRespVO>> listTree(Boolean tree) {
        return this.dataSelectorQueryService.listTree(tree);
    }

    @Override
    public ApiResult<List<CommonDataRelationRespVO>> queryRelation(CommonDataRelationQueryVO queryVO) {
        return this.dataRelationInstQueryService.query(queryVO);
    }

    @Override
    public ApiResult<List<CommonDataRelationRespVO>> queryRelationByRefData(CommonDataRelationQueryVO queryVO) {
        return this.dataRelationInstQueryService.queryByRefData(queryVO);
    }

    @Override
    public ApiResult<PagingVO<UdcWithValuesPageRespVO>> pageQueryUdc(UdcPageQueryVO queryVO) {
        return this.udcQueryService.pageQuery(queryVO);
    }
}

