/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.constant.TaxRateType;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.cacheable.SysCacheTaxRateRpcService;
import com.elitescloud.cloudt.system.convert.TaxRateConvert;
import com.elitescloud.cloudt.system.model.vo.query.extend.TaxRatePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TaxRateDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TaxRatePageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.TaxRateSaveVO;
import com.elitescloud.cloudt.system.service.TaxRateMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysTaxRateDO;
import com.elitescloud.cloudt.system.service.repo.TaxRateRepo;
import com.elitescloud.cloudt.system.service.repo.TaxRateRepoProc;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class TaxRateMngServiceImpl
extends BaseServiceImpl
implements TaxRateMngService {
    private static final TaxRateConvert CONVERT = TaxRateConvert.INSTANCE;
    @Autowired
    private TaxRateRepo repo;
    @Autowired
    private TaxRateRepoProc repoProc;
    @Autowired
    private SysCacheTaxRateRpcService cacheTaxRateRpcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(TaxRateSaveVO saveVO) {
        SysTaxRateDO taxRateDO;
        try {
            taxRateDO = saveVO.getId() == null ? this.convertForInsert(saveVO) : this.convertForUpdate(saveVO);
        }
        catch (IllegalArgumentException e) {
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        this.repo.save(taxRateDO);
        this.clearCache();
        return ApiResult.ok((Object)taxRateDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> delete(Long id) {
        this.repoProc.delete(id);
        this.clearCache();
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id) {
        Boolean enabled = this.repoProc.getEnabled(id);
        enabled = enabled == null || enabled == false;
        this.repoProc.updateEnabled(id, enabled);
        this.clearCache();
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<PagingVO<TaxRatePageRespVO>> page(TaxRatePageQueryVO queryVO) {
        PagingVO<SysTaxRateDO> pageDO = this.repoProc.pageMng(queryVO);
        if (pageDO.isEmpty()) {
            return ApiResult.ok((Object)new PagingVO(pageDO.getTotal(), Collections.emptyList()));
        }
        Map udcMap = super.udcMap((BaseUdc)TaxRateType.OUTPUT);
        PagingVO pageData = this.repoProc.pageMng(queryVO).map(t -> {
            TaxRatePageRespVO respVO = CONVERT.do2PageRespVO((SysTaxRateDO)t);
            respVO.setTaxRateTypeName((String)udcMap.get(t.getTaxRateType()));
            return respVO;
        });
        return ApiResult.ok((Object)pageData);
    }

    @Override
    public ApiResult<TaxRateDetailRespVO> get(Long id) {
        return this.repoProc.getOptional(id).map(t -> {
            TaxRateDetailRespVO respVO = CONVERT.do2DetailRespVO((SysTaxRateDO)t);
            if (CharSequenceUtil.hasBlank((CharSequence[])new CharSequence[]{t.getTaxRateType()})) {
                respVO.setTaxRateTypeName(super.udcValue((BaseUdc)new TaxRateType(t.getTaxRateType())));
            }
            return respVO;
        }).map(ApiResult::ok).orElse(ApiResult.noData());
    }

    private void clearCache() {
        this.cacheTaxRateRpcService.clearCache();
    }

    private SysTaxRateDO convertForInsert(TaxRateSaveVO saveVO) {
        boolean exists = this.repoProc.existsRateNo(saveVO.getTaxRateNo(), null);
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u7a0e\u7387\u7f16\u7801\u5df2\u5b58\u5728");
        Assert.isTrue((saveVO.getTaxRateValue().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u7a0e\u7387\u503c\u4e0d\u80fd\u5c0f\u4e8e0");
        if (saveVO.getEnabled() == null) {
            saveVO.setEnabled(true);
        }
        return CONVERT.saveVo2Do(saveVO);
    }

    private SysTaxRateDO convertForUpdate(TaxRateSaveVO saveVO) {
        SysTaxRateDO taxRateDO = (SysTaxRateDO)this.repoProc.get(saveVO.getId());
        Assert.notNull((Object)taxRateDO, (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        if (!taxRateDO.getTaxRateNo().equals(saveVO.getTaxRateNo())) {
            boolean exists = this.repoProc.existsRateNo(saveVO.getTaxRateNo(), null);
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u7a0e\u7387\u7f16\u7801\u5df2\u5b58\u5728");
        }
        Assert.isTrue((saveVO.getTaxRateValue().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u7a0e\u7387\u503c\u4e0d\u80fd\u5c0f\u4e8e0");
        if (saveVO.getEnabled() == null) {
            saveVO.setEnabled(true);
        }
        CONVERT.copySaveVo2Do(saveVO, taxRateDO);
        return taxRateDO;
    }
}

