/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjUtil;
import com.elitescloud.boot.CloudtContextProperties;
import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.constant.SysThirdApiBusinessType;
import com.elitescloud.cloudt.constant.SysThirdApiSystem;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.convert.ThirdApiLogConvert;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.dto.ThirdApiLogDTO;
import com.elitescloud.cloudt.system.dto.ThirdApiRetryParamDTO;
import com.elitescloud.cloudt.system.dto.req.ThirdApiLogQueryDTO;
import com.elitescloud.cloudt.system.model.entity.SysThirdApiLogDO;
import com.elitescloud.cloudt.system.model.vo.query.extend.ThirdApiLogQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.ThirdApiRetryLogQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiLogAggPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiLogDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiLogPageRespVO;
import com.elitescloud.cloudt.system.service.ThirdApiLogService;
import com.elitescloud.cloudt.system.service.repo.ThirdApiLogRepoProc;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class ThirdApiLogServiceImpl
extends BaseServiceImpl
implements ThirdApiLogService {
    private static final Logger log = LoggerFactory.getLogger(ThirdApiLogServiceImpl.class);
    @Autowired
    private ThirdApiLogRepoProc repoProc;
    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private CloudtContextProperties contextProperties;

    @Override
    public ApiResult<PagingVO<ThirdApiLogDTO>> queryByPage(ThirdApiLogQueryDTO requestDTO) {
        Long tenantId = super.currentTenantId();
        PagingVO pageData = this.repoProc.queryByPage(tenantId, requestDTO).map(t -> {
            ThirdApiLogDTO dto = ThirdApiLogConvert.INSTANCE.do2DTO((SysThirdApiLogDO)((Object)t));
            if (StringUtils.hasText((String)t.getReqHeadersJson())) {
                dto.setReqHeaders((Map)super.json2Obj(t.getReqHeadersJson(), (TypeReference)new TypeReference<Map<String, String[]>>(){}));
            }
            if (StringUtils.hasText((String)t.getReqQueryParamsJson())) {
                dto.setReqQueryParams((Map)super.json2Obj(t.getReqQueryParamsJson(), (TypeReference)new TypeReference<Map<String, String[]>>(){}));
            }
            return dto;
        });
        return ApiResult.ok((Object)pageData);
    }

    @Override
    public ApiResult<PagingVO<ThirdApiLogPageRespVO>> queryByPage(ThirdApiLogQueryVO queryVO) {
        PagedQueryParam queryParam = this.convertPagedQueryParam(queryVO);
        if (queryParam == null) {
            return ApiResult.ok((Object)PagingVO.empty());
        }
        PagingVO pageData = this.repoProc.queryByPage(queryParam.getQueryVO(), queryParam.getTenantId(), queryParam.getServer(), queryParam.getThirdApp()).map(this::do2PageRespVO);
        return ApiResult.ok((Object)pageData);
    }

    @Override
    public ApiResult<List<ThirdApiLogPageRespVO>> listRetryRecord(Long originalId) {
        if (originalId == null) {
            return ApiResult.fail((String)"\u8bb0\u5f55ID\u4e3a\u7a7a");
        }
        List listData = this.repoProc.listRetryRecord(originalId).stream().filter(t -> t.getReqTime() != null).sorted(Comparator.comparing(SysThirdApiLogDO::getReqTime, Comparator.nullsLast(LocalDateTime::compareTo)).reversed()).map(this::do2PageRespVO).collect(Collectors.toList());
        return ApiResult.ok(listData);
    }

    @Override
    public ApiResult<PagingVO<ThirdApiLogPageRespVO>> pageRetryRecord(ThirdApiRetryLogQueryVO queryVO) {
        if (queryVO.getId() == null) {
            return ApiResult.fail((String)"\u8bb0\u5f55ID\u4e3a\u7a7a");
        }
        PagingVO listData = this.repoProc.pageRetryRecord(queryVO.getId(), false, queryVO.getPageRequest()).map(this::do2PageRespVO);
        return ApiResult.ok((Object)listData);
    }

    @Override
    public ApiResult<PagingVO<ThirdApiLogAggPageRespVO>> queryAggByPage(ThirdApiLogQueryVO queryVO) {
        PagedQueryParam queryParam = this.convertPagedQueryParam(queryVO);
        if (queryParam == null) {
            return ApiResult.ok((Object)PagingVO.empty());
        }
        Integer aggDays = this.systemProperties.getThirdApiLog().getAggDefaultDays();
        if (aggDays != null && aggDays > 0 && queryVO.getReqTimeStart() == null && queryVO.getReqTimeEnd() == null) {
            queryVO.setReqTimeEnd(LocalDateTime.now());
            queryVO.setReqTimeStart(queryVO.getReqTimeEnd().minusDays(aggDays.intValue()));
        }
        PagingVO<ThirdApiLogAggPageRespVO> pageData = this.repoProc.queryAggByPage(queryParam.getQueryVO(), queryParam.getTenantId(), queryParam.getServer(), queryParam.getThirdApp());
        pageData.each(this::convertPageRespVO);
        return ApiResult.ok(pageData);
    }

    @Override
    public ApiResult<List<ThirdApiLogPageRespVO>> listAggDetail(ThirdApiLogQueryVO queryVO, Long id) {
        PagedQueryParam queryParam = this.convertPagedQueryParam(queryVO);
        if (queryParam == null) {
            return ApiResult.ok(Collections.emptyList());
        }
        SysThirdApiLogDO record = this.queryOriginalRecord(queryVO, id);
        if (record == null) {
            return ApiResult.fail((String)"\u9009\u62e9\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        List detailList = this.repoProc.listDetailForAgg(queryVO, record).stream().map(this::do2PageRespVO).collect(Collectors.toList());
        return ApiResult.ok(detailList);
    }

    @Override
    public ApiResult<PagingVO<ThirdApiLogPageRespVO>> pageAggDetail(ThirdApiLogQueryVO queryVO, Long id) {
        PagedQueryParam queryParam = this.convertPagedQueryParam(queryVO);
        if (queryParam == null) {
            return ApiResult.ok((Object)PagingVO.empty());
        }
        SysThirdApiLogDO record = this.queryOriginalRecord(queryVO, id);
        if (record == null) {
            return ApiResult.fail((String)"\u9009\u62e9\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        PagingVO detailList = this.repoProc.pageDetailForAgg(queryVO, record).map(this::do2PageRespVO);
        return ApiResult.ok((Object)detailList);
    }

    @Override
    public ApiResult<ThirdApiLogDetailRespVO> getDetail(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u8bb0\u5f55ID\u4e3a\u7a7a");
        }
        return this.repoProc.getOptional(id).map(t -> {
            ThirdApiLogDetailRespVO respVO = ThirdApiLogConvert.INSTANCE.do2DetailRespVO((SysThirdApiLogDO)((Object)t));
            respVO.setBusinessType(this.convertBusinessTypeName(t.getBusinessType()));
            if (Boolean.TRUE.equals(t.getServer())) {
                respVO.setSourceSystem(this.convertSystemName(t.getThirdApp(), true));
                respVO.setTargetSystem(this.currentServerName());
            } else {
                respVO.setSourceSystem(this.currentServerName());
                respVO.setTargetSystem(this.convertSystemName(t.getThirdApp(), false));
            }
            ThirdApiLogDetailRespVO.RetryParamVO retryParamVO = new ThirdApiLogDetailRespVO.RetryParamVO();
            respVO.setRetryParam(retryParamVO);
            if (CharSequenceUtil.isBlank((CharSequence)t.getRetryParamJson())) {
                retryParamVO.setServerAddr(t.getServerAddr());
                retryParamVO.setUri(t.getUri());
                retryParamVO.setReqMethod(t.getReqMethod());
                retryParamVO.setReqQueryParamsJson(t.getReqQueryParamsJson());
                retryParamVO.setReqBody(t.getReqBody());
                retryParamVO.setReqHeadersJson(t.getReqHeadersJson());
            } else {
                ThirdApiRetryParamDTO retryParams = (ThirdApiRetryParamDTO)JSONUtil.json2Obj((String)t.getRetryParamJson(), ThirdApiRetryParamDTO.class, (boolean)true);
                retryParamVO.setServerAddr(CharSequenceUtil.blankToDefault((CharSequence)retryParams.getServerAddr(), (String)this.contextProperties.getServerAddr()));
                retryParamVO.setUri(retryParams.getUri());
                retryParamVO.setReqMethod(retryParams.getReqMethod());
                retryParamVO.setReqQueryParamsJson(super.obj2Json((Object)retryParams.getReqQueryParams()));
                retryParamVO.setReqBody(retryParams.getReqBody());
                retryParamVO.setReqHeadersJson(super.obj2Json((Object)retryParams.getReqHeaders()));
            }
            return respVO;
        }).map(ApiResult::ok).orElse(ApiResult.noData());
    }

    @Override
    public ApiResult<List<CodeNameParam>> listBusinessTypes() {
        List businessTypes = this.querySystemsByUdc(new SysThirdApiBusinessType());
        if (!businessTypes.isEmpty()) {
            return ApiResult.ok(businessTypes);
        }
        businessTypes = this.systemProperties.getThirdApiLog().getBusinessTypes();
        return ApiResult.ok((Object)((List)ObjUtil.defaultIfNull((Object)businessTypes, Collections.emptyList())));
    }

    @Override
    public ApiResult<List<CodeNameParam>> listTargetSystems() {
        List targetSystems = this.querySystemsByUdc(SysThirdApiSystem.YST);
        if (!targetSystems.isEmpty()) {
            return ApiResult.ok(targetSystems);
        }
        targetSystems = this.systemProperties.getThirdApiLog().getTargetSystems();
        return ApiResult.ok((Object)((List)ObjUtil.defaultIfNull((Object)targetSystems, Collections.emptyList())));
    }

    @Override
    public ApiResult<List<CodeNameParam>> listSourceSystems() {
        List sourceSystems = this.querySystemsByUdc(SysThirdApiSystem.YST);
        if (!sourceSystems.isEmpty()) {
            return ApiResult.ok(sourceSystems);
        }
        sourceSystems = this.systemProperties.getThirdApiLog().getSourceSystems();
        return ApiResult.ok((Object)((List)ObjUtil.defaultIfNull((Object)sourceSystems, Collections.emptyList())));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> clearExpiredLogs(LocalDateTime expiredTime) {
        if (expiredTime == null) {
            return ApiResult.fail((String)"\u8fc7\u671f\u65f6\u95f4\u4e3a\u7a7a");
        }
        this.repoProc.clearExpiredLogs(expiredTime);
        return ApiResult.ok((Object)true);
    }

    private <T extends BaseUdc<T>> List<CodeNameParam> querySystemsByUdc(T udc) {
        Map udcValueMap = super.udcMap(udc);
        if (CollUtil.isEmpty((Map)udcValueMap)) {
            return Collections.emptyList();
        }
        ArrayList<CodeNameParam> udcValueList = new ArrayList<CodeNameParam>(udcValueMap.size());
        for (Map.Entry entry : udcValueMap.entrySet()) {
            udcValueList.add(new CodeNameParam((String)entry.getKey(), (String)entry.getValue()));
        }
        return udcValueList;
    }

    private SysThirdApiLogDO queryOriginalRecord(ThirdApiLogQueryVO queryVO, Long id) {
        SysThirdApiLogDO record = (SysThirdApiLogDO)((Object)this.repoProc.get(id));
        if (record == null) {
            return null;
        }
        Integer aggDays = this.systemProperties.getThirdApiLog().getAggDefaultDays();
        if (aggDays != null && aggDays > 0 && queryVO.getReqTimeStart() == null && queryVO.getReqTimeEnd() == null) {
            queryVO.setReqTimeEnd(LocalDateTime.now());
            queryVO.setReqTimeStart(queryVO.getReqTimeEnd().minusDays(aggDays.intValue()));
        }
        return record;
    }

    private String convertBusinessTypeName(String businessType) {
        if (CharSequenceUtil.isBlank((CharSequence)businessType)) {
            return null;
        }
        List types = (List)this.listBusinessTypes().computeData();
        for (CodeNameParam type : types) {
            if (!businessType.equals(type.getCode()) && !businessType.equals(type.getName())) continue;
            return type.getName();
        }
        return businessType;
    }

    private String convertSystemName(String thirdApp, boolean isSource) {
        if (CharSequenceUtil.isBlank((CharSequence)thirdApp)) {
            return null;
        }
        List types = (List)this.listSourceSystems().computeData();
        for (CodeNameParam type : types) {
            if (!thirdApp.equals(type.getCode()) && !thirdApp.equals(type.getName())) continue;
            return type.getName();
        }
        return thirdApp;
    }

    private String convertSystem(String thirdAppName, boolean isSource) {
        if (CharSequenceUtil.isBlank((CharSequence)thirdAppName)) {
            return null;
        }
        List types = (List)this.listSourceSystems().computeData();
        for (CodeNameParam type : types) {
            if (!thirdAppName.equals(type.getName()) && !thirdAppName.equals(type.getCode())) continue;
            return type.getCode();
        }
        return thirdAppName;
    }

    private void convertPageRespVO(ThirdApiLogAggPageRespVO respVO) {
        if (Boolean.TRUE.equals(respVO.getServer())) {
            respVO.setSourceSystem(this.convertSystemName(respVO.getThirdApp(), true));
            respVO.setTargetSystem(this.currentServerName());
        } else {
            respVO.setSourceSystem(this.currentServerName());
            respVO.setTargetSystem(this.convertSystemName(respVO.getThirdApp(), false));
        }
        respVO.setBusinessType(this.convertBusinessTypeName(respVO.getBusinessType()));
    }

    private ThirdApiLogPageRespVO do2PageRespVO(SysThirdApiLogDO logDO) {
        ThirdApiLogPageRespVO respVO = new ThirdApiLogPageRespVO();
        respVO.setId(logDO.getId());
        respVO.setAppCode(logDO.getAppCode());
        if (Boolean.TRUE.equals(logDO.getServer())) {
            respVO.setSourceSystem(this.convertSystemName(logDO.getThirdApp(), true));
            respVO.setTargetSystem(this.currentServerName());
        } else {
            respVO.setSourceSystem(this.currentServerName());
            respVO.setTargetSystem(this.convertSystemName(logDO.getThirdApp(), false));
        }
        respVO.setServerAddr(logDO.getServerAddr());
        respVO.setBusinessType(this.convertBusinessTypeName(logDO.getBusinessType()));
        respVO.setBusinessKey(logDO.getBusinessKey());
        respVO.setUsername(logDO.getUsername());
        respVO.setUri(logDO.getUri());
        respVO.setReqMethod(logDO.getReqMethod());
        respVO.setReqTime(logDO.getReqTime());
        respVO.setRespTime(logDO.getRespTime());
        respVO.setRetryTimes(logDO.getRetryTimes());
        respVO.setRespSuccess(logDO.getRespSuccess());
        respVO.setFailReason(CharSequenceUtil.blankToDefault((CharSequence)logDO.getRetryFailReason(), (String)CharSequenceUtil.blankToDefault((CharSequence)logDO.getRespFailMsg(), (String)logDO.getReqFailMsg())));
        return respVO;
    }

    private String currentServerName() {
        String projectName = (String)super.udcMap((BaseUdc)SysThirdApiSystem.YST).get("YST");
        if (CharSequenceUtil.isNotBlank((CharSequence)projectName)) {
            return projectName;
        }
        return CharSequenceUtil.blankToDefault((CharSequence)this.contextProperties.getProjectName(), (String)"\u4e91\u65f6\u901a");
    }

    private PagedQueryParam convertPagedQueryParam(ThirdApiLogQueryVO queryVO) {
        SysTenantDTO tenant = super.currentTenant();
        Long tenantId = tenant == null ? null : tenant.getId();
        Boolean server = null;
        String thirdApp = null;
        String currentProject = SysThirdApiSystem.YST.getValue();
        String currentProjectName = this.currentServerName();
        if (CharSequenceUtil.equals((CharSequence)queryVO.getSourceSystem(), (CharSequence)currentProject) || CharSequenceUtil.equals((CharSequence)queryVO.getSourceSystem(), (CharSequence)currentProjectName)) {
            server = false;
            thirdApp = this.convertSystem(queryVO.getTargetSystem(), false);
        } else if (CharSequenceUtil.equals((CharSequence)queryVO.getTargetSystem(), (CharSequence)currentProject) || CharSequenceUtil.equals((CharSequence)queryVO.getTargetSystem(), (CharSequence)currentProjectName)) {
            server = true;
            thirdApp = this.convertSystem(queryVO.getSourceSystem(), true);
        } else {
            if (CharSequenceUtil.isAllNotBlank((CharSequence[])new CharSequence[]{queryVO.getSourceSystem(), queryVO.getTargetSystem()})) {
                return null;
            }
            if (CharSequenceUtil.isNotBlank((CharSequence)queryVO.getSourceSystem())) {
                server = true;
            } else if (CharSequenceUtil.isNotBlank((CharSequence)queryVO.getTargetSystem())) {
                server = false;
            }
            thirdApp = CharSequenceUtil.blankToDefault((CharSequence)queryVO.getTargetSystem(), (String)queryVO.getSourceSystem());
        }
        PagedQueryParam queryParam = new PagedQueryParam();
        queryParam.setQueryVO(queryVO);
        queryParam.setTenantId(tenantId);
        queryParam.setServer(server);
        queryParam.setThirdApp(thirdApp);
        return queryParam;
    }

    private static class PagedQueryParam {
        private ThirdApiLogQueryVO queryVO;
        private Long tenantId;
        private Boolean server;
        private String thirdApp;

        private PagedQueryParam() {
        }

        public ThirdApiLogQueryVO getQueryVO() {
            return this.queryVO;
        }

        public void setQueryVO(ThirdApiLogQueryVO queryVO) {
            this.queryVO = queryVO;
        }

        public Long getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(Long tenantId) {
            this.tenantId = tenantId;
        }

        public Boolean getServer() {
            return this.server;
        }

        public void setServer(Boolean server) {
            this.server = server;
        }

        public String getThirdApp() {
            return this.thirdApp;
        }

        public void setThirdApp(String thirdApp) {
            this.thirdApp = thirdApp;
        }
    }
}

