/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.el.coordinator.boot.fsm.model.dto.FileObjDTO;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.excel.common.param.ImportRecordDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.convert.TmplImportRecordConvert;
import com.elitescloud.cloudt.system.dto.SysImportRateDTO;
import com.elitescloud.cloudt.system.dto.req.RecordResultSaveDTO;
import com.elitescloud.cloudt.system.model.vo.query.extend.TmplImportQueryParam;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplImportRecordRespVO;
import com.elitescloud.cloudt.system.service.TmplImportRecordService;
import com.elitescloud.cloudt.system.service.model.entity.SysTmplImportFileDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTmplImportRecordDO;
import com.elitescloud.cloudt.system.service.repo.SysTmplImportFileRepo;
import com.elitescloud.cloudt.system.service.repo.SysTmplImportFileRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysTmplImportRecordRepo;
import com.elitescloud.cloudt.system.service.repo.SysTmplImportRecordRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysTmplRepoProc;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class TmplImportRecordServiceImpl
extends BaseServiceImpl
implements TmplImportRecordService {
    private static final Logger log = LoggerFactory.getLogger(TmplImportRecordServiceImpl.class);
    public static final long DEFAULT_TMPL_ID = -1L;
    @Autowired
    private SysTmplRepoProc tmplRepoProc;
    @Autowired
    private SysTmplImportRecordRepo tmplImportRecordRepo;
    @Autowired
    private SysTmplImportRecordRepoProc tmplImportRecordRepoProc;
    @Autowired
    private SysTmplImportFileRepo tmplImportFileRepo;
    @Autowired
    private SysTmplImportFileRepoProc tmplImportFileRepoProc;
    @Autowired
    private FileService<String> fileService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public com.elitescloud.cloudt.common.base.ApiResult<Long> saveImportRecord(String tmplCode, String fileCode, Map<String, Object> queryParam) {
        Long tmplId = (Long)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.tmplRepoProc.getIdByCode(tmplCode));
        if (tmplId == null) {
            log.info("\u672a\u67e5\u8be2\u5230\u6a21\u677f\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\uff1a{}", (Object)tmplCode);
            tmplId = -1L;
        }
        Long importRecordId = this.save(tmplId, tmplCode, fileCode, queryParam);
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)importRecordId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public com.elitescloud.cloudt.common.base.ApiResult<Long> updateRecordTotal(Long id, Long numTotal) {
        this.tmplImportRecordRepoProc.updateNumTotal(id, numTotal);
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public com.elitescloud.cloudt.common.base.ApiResult<Long> updateImportResult(RecordResultSaveDTO resultSaveDTO) {
        String zipFileCode;
        boolean success;
        if (resultSaveDTO.getRecordId() == null) {
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)"\u8bb0\u5f55ID\u4e3a\u7a7a");
        }
        SysTmplImportRecordDO record = (SysTmplImportRecordDO)this.tmplImportRecordRepoProc.get(resultSaveDTO.getRecordId());
        Assert.notNull((Object)record, (String)"\u672a\u67e5\u8be2\u5230\u8bb0\u5f55");
        long numTotal = (Long)ObjectUtil.defaultIfNull((Object)record.getNumTotal(), (Object)0L);
        long numSuc = (Long)ObjectUtil.defaultIfNull((Object)resultSaveDTO.getNumSuc(), (Object)0L);
        boolean bl = success = numSuc > 0L && numTotal <= numSuc;
        if (Boolean.TRUE.equals(record.getExport())) {
            success = StrUtil.isNotBlank((CharSequence)resultSaveDTO.getFileCode());
        }
        if (success && StringUtils.hasText((String)(zipFileCode = this.zipFiles(resultSaveDTO.getRecordId())))) {
            resultSaveDTO.setFileCode(zipFileCode);
        }
        if (!success && CharSequenceUtil.isBlank((CharSequence)resultSaveDTO.getFailMsg())) {
            if (numTotal == 0L) {
                resultSaveDTO.setFailMsg("\u6570\u636e\u4e3a\u7a7a");
            } else if (numSuc < numTotal) {
                resultSaveDTO.setFailMsg("\u6570\u636e\u672a\u5bfc\u51fa\u5168\u90e8");
            }
        }
        this.tmplImportRecordRepoProc.updateImportResult(resultSaveDTO.getRecordId(), success, resultSaveDTO.getFailMsg(), resultSaveDTO.getCustomTipMsg(), numSuc, resultSaveDTO.getFileCode(), resultSaveDTO.getCostTimeInfo());
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)resultSaveDTO.getRecordId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public com.elitescloud.cloudt.common.base.ApiResult<Long> saveExportFile(Long id, String fileCode, Integer order) {
        FileObjDTO file;
        Long tmplId = this.tmplImportRecordRepoProc.getTmplId(id);
        if (tmplId == null) {
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u5bfc\u5165\u8bb0\u5f55");
        }
        SysTmplImportFileDO importFileDO = new SysTmplImportFileDO();
        importFileDO.setRecordId(id);
        importFileDO.setTmplId(tmplId);
        importFileDO.setFileCode(fileCode);
        importFileDO.setFileOrder((Integer)ObjectUtil.defaultIfNull((Object)order, (Object)0));
        if (StringUtils.hasText((String)fileCode) && (file = (FileObjDTO)this.fileService.getForDto(fileCode).getData()) != null) {
            importFileDO.setFileName(file.getOriginalName());
        }
        this.tmplImportFileRepo.save(importFileDO);
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)importFileDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public com.elitescloud.cloudt.common.base.ApiResult<Long> saveImportFailRecord(Long recordId, String failFileCode) {
        this.tmplImportRecordRepoProc.updateFailFileCode(recordId, failFileCode);
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)recordId);
    }

    @Override
    public com.elitescloud.cloudt.common.base.ApiResult<SysImportRateDTO> getImportRateDto(Long id) {
        Optional<SysImportRateDTO> rateDto = this.tmplImportRecordRepo.findById(id).map(t -> {
            SysImportRateDTO dto = new SysImportRateDTO();
            dto.setFinish(t.getFinish());
            dto.setTmplCode((String)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.tmplRepoProc.getCode(t.getTmplId())));
            dto.setTotal(t.getNumTotal());
            dto.setCount(t.getNumSuc());
            dto.setNumSuccess(t.getNumSuc());
            dto.setFailFileCode(t.getFailFileCode());
            dto.setFailMsgCustom(t.getCustomTipMsg());
            return dto;
        });
        if (rateDto.isPresent()) {
            return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)rateDto.get());
        }
        return com.elitescloud.cloudt.common.base.ApiResult.fail((String)"\u5bfc\u5165\u8bb0\u5f55\u4e0d\u5b58\u5728");
    }

    @Override
    public com.elitescloud.cloudt.common.base.ApiResult<String> getFileCode(Long id) {
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)this.tmplImportRecordRepoProc.getFileCode(id));
    }

    @Override
    public com.elitescloud.cloudt.common.base.ApiResult<List<Long>> queryUnFinished(String appCode) {
        return com.elitescloud.cloudt.common.base.ApiResult.ok(this.tmplImportRecordRepoProc.getUnfinished(appCode));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public com.elitescloud.cloudt.common.base.ApiResult<Boolean> updateResultForSysError(String appCode, String failMsg) {
        List<Long> recordIds = this.tmplImportRecordRepoProc.getUnfinished(appCode);
        if (CollUtil.isEmpty(recordIds)) {
            return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)true);
        }
        failMsg = StringUtils.hasText((String)failMsg) ? failMsg : "\u670d\u52a1\u505c\u6b62";
        this.tmplImportRecordRepoProc.updateResultForError(recordIds, failMsg);
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)true);
    }

    @Override
    public com.elitescloud.cloudt.common.base.ApiResult<PagingVO<TmplImportRecordRespVO>> searchImport(Long tmplId, TmplImportQueryParam queryParam) {
        List fileList;
        PagingVO<SysTmplImportRecordDO> recordDoPage;
        GeneralUserDetails currentUser = super.currentUser(true);
        if (!currentUser.isSystemAdmin() && !currentUser.isTenantAdmin()) {
            queryParam.setUserId(currentUser.getUserId());
        }
        if ((recordDoPage = this.tmplImportRecordRepoProc.pageMng(tmplId, queryParam)).isEmpty()) {
            return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)PagingVO.empty());
        }
        ArrayList<String> fileCodeList = new ArrayList<String>(queryParam.getSize());
        ArrayList<Long> idList = new ArrayList<Long>(queryParam.getSize());
        ArrayList<TmplImportRecordRespVO> respVoList = new ArrayList<TmplImportRecordRespVO>(queryParam.getSize());
        TmplImportRecordConvert convert = TmplImportRecordConvert.INSTANCE;
        for (SysTmplImportRecordDO doo : recordDoPage.getRecords()) {
            TmplImportRecordRespVO vo = convert.do2Vo(doo);
            vo.setUserName(CharSequenceUtil.blankToDefault((CharSequence)doo.getCreator(), (String)doo.getUserName()));
            vo.setFailMsgCustom(doo.getCustomTipMsg());
            respVoList.add(vo);
            if (StringUtils.hasText((String)doo.getFileCode())) {
                fileCodeList.add(doo.getFileCode());
                continue;
            }
            idList.add(doo.getId());
        }
        Map fileCodeMap = idList.isEmpty() ? Collections.emptyMap() : this.tmplImportFileRepoProc.queryByRecordId(idList);
        fileCodeMap.forEach((k, v) -> fileCodeList.addAll((Collection<String>)v));
        Map<Object, Object> fileInfoMap = null;
        if (!fileCodeList.isEmpty() && CollUtil.isNotEmpty((Collection)(fileList = (List)this.fileService.query(fileCodeList).getData()))) {
            fileInfoMap = fileList.stream().collect(Collectors.toMap(FileObjRespVO::getFileCode, t -> t, (t1, t2) -> t1));
        }
        if (fileInfoMap == null) {
            fileInfoMap = Collections.emptyMap();
        }
        for (TmplImportRecordRespVO respVO : respVoList) {
            if (StringUtils.hasText((String)respVO.getFileCode())) {
                respVO.setFileInfo((FileObjRespVO<String>)((FileObjRespVO)fileInfoMap.get(respVO.getFileCode())));
                respVO.setFileInfoList(respVO.getFileInfo() == null ? Collections.emptyList() : List.of(respVO.getFileInfo()));
                continue;
            }
            respVO.setFileInfoList(fileCodeMap.getOrDefault(respVO.getId(), Collections.emptyList()).stream().filter(fileInfoMap::containsKey).map(fileInfoMap::get).collect(Collectors.toList()));
        }
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)PagingVO.builder().total(recordDoPage.getTotal()).records(respVoList).build());
    }

    @Override
    public com.elitescloud.cloudt.common.base.ApiResult<List<FileObjRespVO<String>>> listFileOfExport(Long recordId) {
        SysTmplImportRecordDO record = (SysTmplImportRecordDO)this.tmplImportRecordRepoProc.get(recordId);
        if (record == null) {
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)"\u5bfc\u51fa\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        if (Boolean.FALSE.equals(record.getSucc())) {
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)("\u5bfc\u51fa\u5931\u8d25\uff0c" + CharSequenceUtil.blankToDefault((CharSequence)record.getFailReason(), (String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458")));
        }
        String fileCode = record.getFileCode();
        if (StringUtils.hasText((String)fileCode)) {
            ApiResult fileResult = this.fileService.get(fileCode);
            if (fileResult.getData() != null) {
                return com.elitescloud.cloudt.common.base.ApiResult.ok(List.of((FileObjRespVO)fileResult.getData()));
            }
            return com.elitescloud.cloudt.common.base.ApiResult.ok();
        }
        List<String> fileCodes = this.tmplImportFileRepoProc.queryFileCodeByRecordId(recordId);
        if (fileCodes.isEmpty()) {
            return com.elitescloud.cloudt.common.base.ApiResult.ok(Collections.emptyList());
        }
        List fileList = (List)this.fileService.query(fileCodes).getData();
        if (CollUtil.isEmpty((Collection)fileList)) {
            return com.elitescloud.cloudt.common.base.ApiResult.ok();
        }
        Map<String, FileObjRespVO> fileInfoMap = fileList.stream().collect(Collectors.toMap(FileObjRespVO::getFileCode, t -> t, (t1, t2) -> t1));
        List fileInfoList = fileCodes.stream().filter(fileInfoMap::containsKey).map(fileInfoMap::get).collect(Collectors.toList());
        return com.elitescloud.cloudt.common.base.ApiResult.ok(fileInfoList);
    }

    @Override
    public com.elitescloud.cloudt.common.base.ApiResult<List<ImportRecordDTO>> queryRecord(String tmplCode, Integer hours, Boolean self) {
        Long tmplId;
        Assert.hasText((String)tmplCode, (String)"\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        hours = hours == null ? 72 : hours;
        Long userId = null;
        if (self == null || self.booleanValue()) {
            userId = super.currentUser(true).getUserId();
        }
        if ((tmplId = (Long)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.tmplRepoProc.getIdByCode(tmplCode))) == null) {
            return com.elitescloud.cloudt.common.base.ApiResult.ok(Collections.emptyList());
        }
        TmplImportRecordConvert convert = TmplImportRecordConvert.INSTANCE;
        List recordList = this.tmplImportRecordRepoProc.queryRecentlyList(tmplId, hours, userId).stream().sorted(Comparator.comparing(SysTmplImportRecordDO::getTimeImport).reversed()).map(t -> {
            ImportRecordDTO dto = convert.do2Dto((SysTmplImportRecordDO)t);
            dto.setFailMsgCustom(t.getCustomTipMsg());
            return dto;
        }).collect(Collectors.toList());
        return com.elitescloud.cloudt.common.base.ApiResult.ok(recordList);
    }

    private Long save(Long tmplId, String tmplCode, String fileCode, Map<String, Object> param) {
        SysTmplImportRecordDO recordDO = new SysTmplImportRecordDO();
        recordDO.setTmplId(tmplId);
        recordDO.setTmplCode(tmplCode);
        recordDO.setFileCode(fileCode);
        recordDO.setExport((Boolean)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.tmplRepoProc.getExport(tmplId)));
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user != null) {
            recordDO.setUserId(user.getUserId());
            recordDO.setUserName(user.getUsername());
        }
        recordDO.setTimeImport(LocalDateTime.now());
        recordDO.setFinish(Boolean.valueOf(false));
        try {
            recordDO.setQueryParam(this.objectMapper.writeValueAsString(param));
        }
        catch (JsonProcessingException e) {
            log.error("\u8f6c\u6362\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55\u7684\u67e5\u8be2\u53c2\u6570\u5931\u8d25", (Throwable)e);
        }
        return ((SysTmplImportRecordDO)this.tmplImportRecordRepo.save(recordDO)).getId();
    }

    private String zipFiles(Long id) {
        boolean isZip = (Boolean)SpringContextHolder.getProperty((String)"elitesland.excel.export.zip", Boolean.class, (Object)true);
        if (!isZip) {
            return null;
        }
        List<SysTmplImportFileDO> files = this.tmplImportFileRepoProc.queryByRecordId(id);
        if (files.isEmpty()) {
            return null;
        }
        String[] fileNames = new String[files.size()];
        InputStream[] fileStreams = new InputStream[files.size()];
        int i = 0;
        for (SysTmplImportFileDO file : files) {
            fileNames[i] = file.getFileName();
            try {
                StreamingResponseBody fileStream = (StreamingResponseBody)this.fileService.download(file.getFileCode(), null).getBody();
                fileStreams[i] = super.streamingResponseBodyToInputStream(fileStream);
            }
            catch (IOException e) {
                log.error("\u538b\u7f29\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                return null;
            }
            ++i;
        }
        String fileName = fileNames[0].substring(0, fileNames[0].lastIndexOf("_")) + ".zip";
        File zipFile = this.createTempFile(fileName);
        ZipUtil.zip((File)zipFile, (String[])fileNames, (InputStream[])fileStreams);
        return ((FileObjRespVO)this.fileService.upload(zipFile).getData()).getFileCode();
    }

    private File createTempFile(String fileName) {
        File file = new File(System.getProperty("java.io.tmpdir"), fileName);
        file.delete();
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", e);
        }
        return file;
    }
}

