/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl.old;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.spi.common.ServiceProviderLoader;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.convert.old.SysUserConvert;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.model.entity.SysUserCompanyDO;
import com.elitescloud.cloudt.system.param.SysUserBatchSwitchParam;
import com.elitescloud.cloudt.system.param.SysUserNewParam;
import com.elitescloud.cloudt.system.param.SysUserQueryParam;
import com.elitescloud.cloudt.system.param.SysUserUpdateParam;
import com.elitescloud.cloudt.system.provider.dto.SysUserRpcDTO;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcDtoParam;
import com.elitescloud.cloudt.system.service.ISysSettingService;
import com.elitescloud.cloudt.system.service.SysUserTerminalService;
import com.elitescloud.cloudt.system.service.UserQueryService;
import com.elitescloud.cloudt.system.service.dto.SysSettingDTO;
import com.elitescloud.cloudt.system.service.manager.UserMngManager;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.old.ISysUserService;
import com.elitescloud.cloudt.system.service.repo.SysUserCompanyRepoProc;
import com.elitescloud.cloudt.system.service.repo.old.SysUserRepo;
import com.elitescloud.cloudt.system.service.repo.old.SysUserRepoProc;
import com.elitescloud.cloudt.system.spi.SysUserServiceSpi;
import com.elitescloud.cloudt.system.vo.SysRoleVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserDetailsVO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitescloud.coord.messenger.sender.provider.MsgCarrierDubboService;
import com.elitescloud.coord.messenger.sender.provider.param.GeneralDubboCarrier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class SysUserServiceImpl
implements ISysUserService {
    private static final Logger log = LoggerFactory.getLogger(SysUserServiceImpl.class);
    @Autowired
    private SysUserCompanyRepoProc userCompanyRepoProc;
    @Autowired
    private SysUserRepo sysUserRepo;
    @Autowired
    private SysUserRepoProc sysUserRepoProc;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private ISysSettingService sysSettingService;
    @Autowired
    private SysUserTerminalService userTerminalService;
    @Autowired
    private MsgCarrierDubboService msgCarrierDubboService;
    @Autowired
    private TenantClientProvider tenantClientProvider;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private UserMngManager userMngManager;
    @Autowired
    private UserQueryService userQueryService;
    private AtomicBoolean userServiceSpiLoaded = new AtomicBoolean(false);
    private List<SysUserServiceSpi> userServiceSpiList = new ArrayList<SysUserServiceSpi>();

    public PagingVO<SysUserVO> search(SysUserQueryParam param) {
        PagingVO<SysUserDO> users = this.sysUserRepoProc.selectSysUser(param);
        List records = users.getRecords();
        if (records == null || records.isEmpty()) {
            return PagingVO.builder().build();
        }
        List userIds = records.stream().map(BaseModel::getId).collect(Collectors.toList());
        List userVos = users.getRecords().stream().map(u -> {
            SysUserVO userVo = SysUserConvert.INSTANCE.doToVo((SysUserDO)u);
            return userVo;
        }).collect(Collectors.toList());
        return PagingVO.builder().total(users.getTotal()).records(userVos).build();
    }

    public SysUserDetailsVO findDetailsById(Long id) {
        SysTenantDTO currentTenant = this.tenantClientProvider.getCurrentTenant();
        SysUserDetailsVO detailsVO = this.sysUserRepoProc.findDetailsById(id);
        if (detailsVO != null) {
            this.tenantDataIsolateProvider.byTenantDirectly(() -> {
                SysUserCompanyDO userCompany;
                ApiResult userTerminal = this.userTerminalService.getByUser(id);
                if (CollUtil.isNotEmpty((Collection)((Collection)userTerminal.getData()))) {
                    detailsVO.setTerminals((List)userTerminal.getData());
                }
                if ((userCompany = this.userCompanyRepoProc.queryByUserId(id)) != null) {
                    detailsVO.setOuId(userCompany.getOuId());
                    detailsVO.setOuCode(userCompany.getOuCode());
                    detailsVO.setOuName(userCompany.getOuName());
                }
                return null;
            }, currentTenant);
        }
        return detailsVO;
    }

    public SysUserDTO getById(Long id) {
        return this.sysUserRepo.findById(id).map(u -> {
            SysUserDTO userDto = SysUserConvert.INSTANCE.doToDto((SysUserDO)u);
            return userDto;
        }).orElse(null);
    }

    public List<SysUserVO> getByIds(List<Long> ids) {
        return this.sysUserRepo.findAllByIdIn(ids).stream().map(SysUserConvert.INSTANCE::doToVo).collect(Collectors.toList());
    }

    public SysUserDTO getUserByUsername(String username) {
        return this.userQueryService.getUserByUsername(username);
    }

    public SysUserDTO getUserByMobile(String mobile) {
        return this.userQueryService.getUserByMobile(mobile);
    }

    public SysUserDTO getUserByEmail(String email) {
        return this.userQueryService.getUserByEmail(email);
    }

    public SysUserDTO getUserById(Long id) {
        return this.userQueryService.getUserById(id);
    }

    public SysUserDTO getUserByAccount(String account) {
        return this.userQueryService.getUserByAccount(account);
    }

    public SysUserDTO getUserByWechatOpenid(String wechatOpenid) {
        return this.userQueryService.getUserByWechatOpenid(wechatOpenid);
    }

    public Long getUserIdByUsername(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return null;
        }
        return this.sysUserRepoProc.getIdByUsername(username);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long create(SysUserNewParam userNewParam, String password) throws BusinessException {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        this.checkForAdd(userNewParam, currentUser);
        SysUserDO sysUser = SysUserConvert.INSTANCE.newToDo(userNewParam);
        List notifySettings = this.sysSettingService.findSettingsBySettingNo("SYS_PWD_NOTIFY_TYPE");
        String rawPassword = StringUtils.isNotBlank((CharSequence)password) ? password : (org.springframework.util.CollectionUtils.isEmpty((Collection)notifySettings) ? this.generateDefaultPwd() : this.generateRandomPwd());
        sysUser.setPassword(this.passwordEncoder.encode((CharSequence)rawPassword));
        SysUserDO newUser = (SysUserDO)this.sysUserRepo.save(sysUser);
        Long id = newUser.getId();
        SysTenantDTO tenantDTO = null;
        if (userNewParam.getTenantId() != null && (tenantDTO = this.tenantClientProvider.getTenant(userNewParam.getTenantId())) == null) {
            throw new BusinessException("\u79df\u6237\u4e0d\u5b58\u5728");
        }
        tenantDTO = (SysTenantDTO)ObjectUtil.defaultIfNull(tenantDTO, (Object)this.obtainCurrentTenantForCreateUser(currentUser));
        this.tenantDataIsolateProvider.byTenantDirectly(() -> {
            this.saveOrUpdateUserTerminal(id, userNewParam);
            this.saveOrUpdateUserCompany(newUser);
            return null;
        }, tenantDTO);
        if (StringUtils.isBlank((CharSequence)password) && !org.springframework.util.CollectionUtils.isEmpty((Collection)notifySettings)) {
            SysSettingDTO notifySetting = (SysSettingDTO)notifySettings.get(0);
            this.sendPwdSmsNotify(sysUser.getMobile(), rawPassword, notifySetting.getSettingVal(), "sms-init-pwd");
        }
        this.expendUserServiceSpi(spi -> spi.afterUserAdd(userNewParam, id));
        return id;
    }

    private void checkForAdd(SysUserNewParam userNewParam, GeneralUserDetails currentUser) {
        if (userNewParam.getEnabled() == null) {
            userNewParam.setEnabled(Boolean.valueOf(false));
        }
        this.expendUserServiceSpi(spi -> spi.beforeUserAdd(userNewParam));
        if (this.sysUserRepo.existsByUsername(userNewParam.getUsername())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7528\u6237\uff1a" + userNewParam.getUsername() + ", \u5df2\u7ecf\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)userNewParam.getMobile())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u624b\u673a\u53f7\u5fc5\u586b");
        }
        if (this.sysUserRepo.existsByMobile(userNewParam.getMobile())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u76f8\u540c\u7684\u624b\u673a\u53f7\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        if (StringUtils.isNotBlank((CharSequence)userNewParam.getEmail()) && this.sysUserRepo.existsByEmail(userNewParam.getEmail())) {
            throw new BusinessException("\u76f8\u540c\u7684\u90ae\u7bb1\u5730\u5740\u5df2\u7ecf\u5b58\u5728");
        }
        this.checkUserPermission(currentUser, userNewParam.getRoleIds());
    }

    private void expendUserServiceSpi(Consumer<SysUserServiceSpi> userServiceSpiConsumer) {
        if (this.userServiceSpiLoaded.compareAndSet(false, true)) {
            this.userServiceSpiList = ServiceProviderLoader.loadProviderInstances(SysUserServiceSpi.class);
        }
        if (this.userServiceSpiList.isEmpty()) {
            log.info("\u7528\u6237\u7ba1\u7406SysUserServiceSpi\u65e0\u6269\u5c55\u5b9e\u73b0");
            return;
        }
        for (SysUserServiceSpi spi : this.userServiceSpiList) {
            log.info("\u3010{}\u3011SPI\u8c03\u7528...", (Object)spi.getServiceName());
            userServiceSpiConsumer.accept(spi);
        }
    }

    private SysTenantDTO obtainCurrentTenantForCreateUser(GeneralUserDetails currentUser) {
        if (currentUser != null) {
            if (currentUser.isSystemAdmin() || currentUser.isOperation()) {
                return null;
            }
            return currentUser.getTenant();
        }
        return this.tenantClientProvider.getCurrentTenant();
    }

    private void checkUserPermission(GeneralUserDetails currentUser, List<Long> roleIds) {
        if (roleIds == null || roleIds.isEmpty()) {
            return;
        }
        if (currentUser == null || currentUser.isSystemAdmin()) {
            return;
        }
    }

    private void saveOrUpdateUserTerminal(Long id, SysUserNewParam userNewParam) {
        HashSet<Terminal> terminals = new HashSet<Terminal>(4);
        if (CollUtil.isNotEmpty((Collection)userNewParam.getTerminals())) {
            terminals.addAll(userNewParam.getTerminals());
        }
        if (CharSequenceUtil.equals((CharSequence)userNewParam.getSourceType(), (CharSequence)"sys")) {
            terminals.add(Terminal.BACKEND);
        } else if (CharSequenceUtil.equals((CharSequence)userNewParam.getSourceType(), (CharSequence)"wec")) {
            terminals.add(Terminal.APP);
        }
        if (!terminals.isEmpty()) {
            this.userTerminalService.saveForAdd(id, terminals);
            userNewParam.setTerminals(terminals);
        }
    }

    private void saveOrUpdateUserCompany(SysUserDO user) {
    }

    @Transactional(rollbackFor={Exception.class})
    public Long update(SysUserUpdateParam userUpdateParam) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        Optional userOpt = this.sysUserRepo.findById(userUpdateParam.getId());
        if (userOpt.isEmpty()) {
            throw new BusinessException("ID\u4e3a\uff1a" + userUpdateParam.getId() + "\uff0c \u7684\u7528\u6237\u4e0d\u5b58\u5728");
        }
        SysUserDO sysUserDO = (SysUserDO)userOpt.get();
        if (StringUtils.isNotBlank((CharSequence)userUpdateParam.getMobile()) && this.sysUserRepo.existsByMobileAndIdNot(userUpdateParam.getMobile(), userUpdateParam.getId())) {
            throw new BusinessException("\u624b\u673a\u53f7\u7801\uff1a" + userUpdateParam.getMobile() + ", \u5df2\u7ecf\u5b58\u5728");
        }
        if (StringUtils.isNotBlank((CharSequence)userUpdateParam.getEmail()) && this.sysUserRepo.existsByEmailAndIdNot(userUpdateParam.getEmail(), userUpdateParam.getId())) {
            throw new BusinessException("\u7535\u5b50\u90ae\u7bb1\uff1a" + userUpdateParam.getEmail() + ", \u5df2\u7ecf\u5b58\u5728");
        }
        SysUserConvert.INSTANCE.updateToDo(userUpdateParam, sysUserDO);
        this.sysUserRepo.save(sysUserDO);
        this.tenantDataIsolateProvider.byTenantAuto(() -> {
            if (CollUtil.isNotEmpty((Collection)userUpdateParam.getTerminals())) {
                this.userTerminalService.save(sysUserDO.getId(), userUpdateParam.getTerminals());
            }
            this.saveOrUpdateUserCompany(sysUserDO);
            return null;
        });
        this.expendUserServiceSpi(spi -> spi.afterUserUpdate(sysUserDO.getId()));
        return sysUserDO.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean switchUserStatus(Long id) {
        SysUserDO user;
        Optional userOpt = this.sysUserRepo.findById(id);
        if (userOpt.isEmpty()) {
            throw new BusinessException(ApiCode.FAIL, "ID\u4e3a\uff1a" + id + "\uff0c\u7684\u7528\u6237\u4e0d\u5b58\u5728");
        }
        user.setEnabled(Boolean.valueOf((user = (SysUserDO)userOpt.get()).getEnabled() == false));
        this.sysUserRepo.save(user);
        return user.getEnabled();
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> updateUserWechatOpenid(String userName, String openid) {
        return ApiResult.fail();
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchSwitchUserStatus(SysUserBatchSwitchParam param) {
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)param.getUserIds())) {
            return;
        }
        for (Long userId : param.getUserIds()) {
            this.userMngManager.updateEnabled(userId, param.isEnable());
        }
    }

    public Set<SysRoleVO> listRolesByUsername(String username) {
        Optional<SysUserDO> user = this.sysUserRepo.findByUsername(username);
        if (user.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.emptySet();
    }

    public SysUserDTO current() {
        GeneralUserDetails details = SecurityContextUtil.currentUser();
        if (details != null) {
            return details.getUser();
        }
        return null;
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public List<SysUserRpcDTO> findUserRpcDtoByParam(SysUserRpcDtoParam param) {
        if (CollectionUtils.isNotEmpty((Collection)param.getRoleIds())) {
            List<Long> filterIds = param.getRoleIds().stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
            List<Long> userIds = this.sysUserRepoProc.findUserIdsByRoleIds(filterIds);
            if (param.getUserIds() == null) {
                param.setUserIds(userIds);
            } else {
                param.getUserIds().addAll(userIds);
            }
        }
        return (List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.sysUserRepoProc.findRpcDtoByParam(param));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> idList) {
        this.sysUserRepoProc.delete(idList);
        for (Long id : idList) {
            this.expendUserServiceSpi(spi -> spi.afterUserDelete(id));
        }
    }

    private String generateDefaultPwd() {
        return this.userMngManager.getDefaultPassword();
    }

    private String generateRandomPwd() {
        return RandomUtil.randomString((int)8);
    }

    private void sendPwdSmsNotify(String to, String pwd, String transType, String templateCode) {
        HashMap<String, String> templateValues = new HashMap<String, String>(2);
        templateValues.put("pwd", pwd);
        GeneralDubboCarrier carrier = GeneralDubboCarrier.builder().tos(new String[]{to}).isRichContent(Boolean.valueOf(false)).transType(transType).templateCode(templateCode).templateValues(templateValues).build();
        ApiResult response = this.msgCarrierDubboService.generalSend(Collections.singletonList(carrier));
        if (!response.isSuccess()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, response.getData().toString());
        }
    }
}

