/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.model.bo.BusinessOperationParamBO;
import com.google.common.base.Functions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Component;

@Component
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class BusinessObjectManager {
    public List<BusinessOperationParamBO> convertParam(@NotEmpty List<BusinessOperationParamBO> paramBoList, Predicate<BusinessOperationParamBO> predicate) {
        return this.convertParam(paramBoList, predicate, Function.identity(), BusinessOperationParamBO::setChildrenParams);
    }

    public <T> List<T> convertParam(@NotEmpty List<BusinessOperationParamBO> paramBoList, Predicate<BusinessOperationParamBO> predicate, @NotNull Function<BusinessOperationParamBO, T> paramConvert, @NotNull BiConsumer<T, List<T>> childrenConsumer) {
        if (CollUtil.isEmpty(paramBoList)) {
            return Collections.emptyList();
        }
        Map<String, List<BusinessOperationParamWrapper>> paramWrappers = paramBoList.stream().filter(t -> {
            if (CharSequenceUtil.isBlank((CharSequence)t.getFieldName())) {
                return false;
            }
            return predicate == null || predicate.test((BusinessOperationParamBO)t);
        }).map(BusinessOperationParamWrapper::new).collect(Collectors.groupingBy(BusinessOperationParamWrapper::getParentPath));
        if (paramWrappers.isEmpty()) {
            return Collections.emptyList();
        }
        List<BusinessOperationParamWrapper> paramsRootList = paramWrappers.get("#root#");
        return this.convertParamWithChildren(paramsRootList, paramWrappers, paramConvert, childrenConsumer);
    }

    public List<BusinessOperationParamBO> attemptObtainPagingData(@NotEmpty List<BusinessOperationParamBO> paramList) {
        if (CollUtil.isEmpty(paramList)) {
            return Collections.emptyList();
        }
        Map paramNames = paramList.stream().collect(Collectors.toMap(BusinessOperationParamBO::getFieldName, Functions.identity(), (t1, t2) -> t1));
        if (paramNames.containsKey("total") && paramNames.containsKey("records")) {
            return (List)ObjUtil.defaultIfNull(((BusinessOperationParamBO)paramNames.get("records")).getChildrenParams(), Collections.emptyList());
        }
        return Collections.emptyList();
    }

    private <T> List<T> convertParamWithChildren(List<BusinessOperationParamWrapper> paramWrappers, Map<String, List<BusinessOperationParamWrapper>> childrenMap, Function<BusinessOperationParamBO, T> paramConvert, BiConsumer<T, List<T>> childrenConsumer) {
        if (CollUtil.isEmpty(paramWrappers)) {
            return Collections.emptyList();
        }
        return paramWrappers.stream().map(t -> {
            Object param = paramConvert.apply(t.paramBO);
            childrenConsumer.accept(param, this.convertParamWithChildren((List)childrenMap.get(t.paramBO.getParamPath()), childrenMap, paramConvert, childrenConsumer));
            return param;
        }).collect(Collectors.toList());
    }

    static class BusinessOperationParamWrapper {
        private final BusinessOperationParamBO paramBO;
        private final String parentPath;

        public BusinessOperationParamWrapper(BusinessOperationParamBO paramBO) {
            this.paramBO = paramBO;
            this.parentPath = this.obtainParentPath(paramBO.getParamPath());
        }

        private String obtainParentPath(String paramPath) {
            if (CharSequenceUtil.isBlank((CharSequence)paramPath)) {
                return "#root#";
            }
            int index = paramPath.lastIndexOf(":");
            if (index < 0) {
                return "#root#";
            }
            String parent = paramPath.substring(0, index);
            while (parent.endsWith(":")) {
                parent = parent.substring(0, parent.length() - 1);
            }
            return parent;
        }

        public String getParentPath() {
            return this.parentPath;
        }
    }
}

