/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.DataSelectorConverter;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonDataSelectorRespVO;
import com.elitescloud.cloudt.system.service.model.entity.SysDataSelectorDO;
import com.elitescloud.cloudt.system.service.repo.DataSelectorGroupRepoProc;
import com.elitescloud.cloudt.system.service.repo.DataSelectorRepoProc;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
@Component
public class DataSelectorManager {
    @Autowired
    private DataSelectorRepoProc repoProc;
    @Autowired
    private DataSelectorGroupRepoProc groupRepoProc;

    public CommonDataSelectorRespVO getRespVO(@NotBlank String dataSelectorCode) {
        SysDataSelectorDO selectorDO = this.repoProc.getByCode(dataSelectorCode);
        if (selectorDO == null || Boolean.FALSE.equals(selectorDO.getEnabled())) {
            return null;
        }
        CommonDataSelectorRespVO respVO = DataSelectorConverter.INSTANCE.do2CommonRespVO(selectorDO);
        if (StringUtils.hasText((String)respVO.getGroupCode())) {
            respVO.setGroupName(this.groupRepoProc.getNameByCode(respVO.getGroupCode()));
        }
        respVO.setApiHeaders((Map)JSONUtil.json2Obj((String)selectorDO.getApiHeadersJson(), (TypeReference)new TypeReference<HashMap<String, String>>(){}));
        respVO.setApiReqBody((Map)JSONUtil.json2Obj((String)selectorDO.getApiReqBodyJson(), (TypeReference)new TypeReference<HashMap<String, Object>>(){}));
        respVO.setApiReqParams((Map)JSONUtil.json2Obj((String)selectorDO.getApiReqParamsJson(), (TypeReference)new TypeReference<HashMap<String, String>>(){}));
        respVO.setDataFields(StringUtils.hasText((String)selectorDO.getDataFieldsStr()) ? Arrays.stream(selectorDO.getDataFieldsStr().split(",")).collect(Collectors.toList()) : Collections.emptyList());
        respVO.setExtAttributes((Map)JSONUtil.json2Obj((String)selectorDO.getExtAttributesJson(), (TypeReference)new TypeReference<HashMap<String, Object>>(){}));
        return respVO;
    }
}

