/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.service.repo.EmployeeOrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class EmployeeQueryManager {
    private static final Logger log = LogManager.getLogger(EmployeeQueryManager.class);
    @Autowired
    private EmployeeRepoProc repoProc;
    @Autowired
    private EmployeeOrgRepoProc employeeOrgRepoProc;
    @Autowired
    private OrgRepoProc orgRepoProc;

    public Map<Long, List<IdCodeNameParam>> getEmployeeOrgsByUserIds(Collection<Long> userIds) {
        if (CollUtil.isEmpty(userIds)) {
            return Collections.emptyMap();
        }
        return this.employeeOrgRepoProc.getOrgsByUserId(userIds, true);
    }

    public List<List<IdCodeNameParam>> getEmployeeOrgsWithParent(long employeeId) {
        List<Long> orgIds = this.employeeOrgRepoProc.getOrgIdByEmployeeId(employeeId);
        if (orgIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<IdCodeNameParam>> respList = new ArrayList<List<IdCodeNameParam>>(orgIds.size());
        for (Long orgId : orgIds) {
            List<SysOrgBasicDTO> orgs = this.orgRepoProc.getBasicDtoOfParents(orgId);
            boolean existsDisabled = orgs.stream().anyMatch(t -> t.getEnabled() == false);
            if (existsDisabled) continue;
            List paramList = orgs.stream().map(t -> {
                IdCodeNameParam param = new IdCodeNameParam();
                param.setId(t.getId());
                param.setCode(t.getCode());
                param.setName(t.getPrettyName());
                return param;
            }).collect(Collectors.toList());
            respList.add(paramList);
        }
        return respList;
    }

    public Map<Long, SysEmployeeBasicDTO> getEmployeeLeader(long employeeId) {
        Map<Long, Long> leaderIdMap = this.employeeOrgRepoProc.getEmployeeOrgIdAndLeaderId(employeeId);
        if (leaderIdMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Collection<Long> leaderUserIds = leaderIdMap.values();
        Map<Long, SysEmployeeBasicDTO> emaployeeMap = this.repoProc.queryBasicByUserIds(leaderUserIds).stream().collect(Collectors.toMap(SysEmployeeBasicDTO::getUserId, t -> t, (t1, t2) -> t1));
        HashMap<Long, SysEmployeeBasicDTO> result = new HashMap<Long, SysEmployeeBasicDTO>();
        for (Map.Entry<Long, Long> entry : leaderIdMap.entrySet()) {
            SysEmployeeBasicDTO emp = emaployeeMap.get(entry.getValue());
            if (emp == null) continue;
            result.put(entry.getKey(), emp);
        }
        return result;
    }
}

