/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.RandomUtil;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.common.param.FileByteVO;
import com.elitescloud.boot.common.param.FileInfoVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.FileUtil;
import com.elitescloud.boot.util.StrUtil;
import com.elitescloud.cloudt.system.model.entity.SysResourceByteDO;
import com.elitescloud.cloudt.system.service.repo.ResourceByteRepoProc;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Component
public class ResourceByteMngManager {
    private static final Logger log = LoggerFactory.getLogger(ResourceByteMngManager.class);
    public static final String BUSINESS_TYPE_TMPL = "tmpl";
    @Autowired
    private ResourceByteRepoProc repoProc;
    @Autowired
    private FileService<String> fileService;

    @Transactional(rollbackFor={Exception.class})
    public FileInfoVO saveResource(@NotNull MultipartFile multipartFile, @NotBlank String businessType, String businessKey, boolean temp) {
        if (multipartFile == null || multipartFile.isEmpty()) {
            throw new BusinessException("\u8d44\u6e90\u6587\u4ef6\u4e3a\u7a7a");
        }
        Assert.notBlank((CharSequence)businessType, (String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CharSequenceUtil.isBlank((CharSequence)businessKey)) {
            businessKey = this.generateBusinessKey();
        }
        SysResourceByteDO byteDO = new SysResourceByteDO();
        byteDO.setResourceType(businessType);
        byteDO.setResourceKey(businessKey);
        try {
            byteDO.setResource(multipartFile.getBytes());
        }
        catch (IOException e) {
            throw new IllegalStateException("\u4fdd\u5b58\u8d44\u6e90\u5931\u8d25", e);
        }
        byteDO.setMimeType(multipartFile.getContentType());
        byteDO.setSuffix(FileUtil.getSuffix((String)multipartFile.getOriginalFilename()));
        byteDO.setResourceName(multipartFile.getOriginalFilename());
        byteDO.setShowName(multipartFile.getOriginalFilename());
        byteDO.setSize(multipartFile.getSize());
        byteDO.setTemp(temp);
        this.repoProc.save((Serializable)((Object)byteDO));
        return this.convertVO(byteDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public FileInfoVO saveResourceForCompatibility(@NotBlank String fileCode, @NotBlank String businessType, String businessKey, boolean temp) {
        Assert.notBlank((CharSequence)fileCode, (String)"\u6587\u4ef6\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        FileObjRespVO fileInfo = (FileObjRespVO)this.fileService.get(fileCode).getData();
        Assert.notNull((Object)fileInfo, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        HttpEntity resp = this.fileService.download(fileCode, null);
        if (resp == null || !resp.hasBody() || resp.getBody() == null) {
            throw new BusinessException("\u6587\u4ef6\u4fe1\u606f\u4e3a\u7a7a");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ((StreamingResponseBody)resp.getBody()).writeTo((OutputStream)outputStream);
        }
        catch (Exception e) {
            log.warn("\u8f6c\u6210\u6a21\u677f\u6587\u4ef6{}\u5931\u8d25", (Object)fileCode, (Object)e);
            throw new BusinessException("\u5b58\u50a8\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        byte[] contents = outputStream.toByteArray();
        return this.saveResourceForCompatibility(contents, fileInfo, businessType, businessKey, temp);
    }

    @Transactional(rollbackFor={Exception.class})
    public FileInfoVO saveResourceForCompatibility(@NotBlank byte[] resource, @NotNull FileObjRespVO<?> fileObjRespVO, @NotBlank String businessType, String businessKey, boolean temp) {
        if (ArrayUtil.isEmpty((byte[])resource)) {
            throw new BusinessException("\u8d44\u6e90\u6587\u4ef6\u4e3a\u7a7a");
        }
        Assert.notNull(fileObjRespVO, (String)"\u8d44\u6e90\u6587\u4ef6\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)businessType, (String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CharSequenceUtil.isBlank((CharSequence)businessKey)) {
            businessKey = fileObjRespVO.getFileCode();
        }
        String suffix = StrUtil.blankToDefault((String)fileObjRespVO.getSuffix(), () -> FileUtil.getSuffix((String)fileObjRespVO.getOriginalName()));
        SysResourceByteDO byteDO = new SysResourceByteDO();
        byteDO.setResourceType(businessType);
        byteDO.setResourceKey(businessKey);
        byteDO.setResource(resource);
        byteDO.setMimeType(StrUtil.blankToDefault((String)fileObjRespVO.getMimeType(), () -> FileUtil.convertMimeTypeByFilename((String)fileObjRespVO.getOriginalName())));
        byteDO.setSuffix(suffix);
        byteDO.setResourceName(fileObjRespVO.getOriginalName());
        byteDO.setShowName(fileObjRespVO.getOriginalName());
        byteDO.setSize(fileObjRespVO.getFileSize());
        byteDO.setTemp(temp);
        this.repoProc.save((Serializable)((Object)byteDO));
        return this.convertVO(byteDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateTemp(@NotBlank String businessKey, boolean temp) {
        Assert.notBlank((CharSequence)businessKey, (String)"\u8d44\u6e90\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        this.repoProc.updateTemp(businessKey, temp);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(@NotNull Long id) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a", (Object[])new Object[0]);
        this.repoProc.delete(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByBusinessKey(@NotBlank String businessType) {
        Assert.notBlank((CharSequence)businessType, (String)"\u4e1a\u52a1\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        this.repoProc.deleteByResourceKey(businessType);
    }

    public byte[] getResourceContent(@NotBlank String businessKey) {
        Assert.notBlank((CharSequence)businessKey, (String)"\u8d44\u6e90\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.repoProc.getResourceByResourceKey(businessKey);
    }

    public FileInfoVO get(@NotBlank String businessKey) {
        Assert.notBlank((CharSequence)businessKey, (String)"\u4e1a\u52a1\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        SysResourceByteDO resourceInfo = this.repoProc.getByResourceKey(businessKey);
        if (resourceInfo == null) {
            return null;
        }
        return this.convertVO(resourceInfo);
    }

    public FileInfoVO getForCompatibility(@NotBlank String fileCode) {
        Assert.notBlank((CharSequence)fileCode, (String)"\u6587\u4ef6\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        FileInfoVO fileInfo = this.get(fileCode);
        if (fileInfo != null) {
            return fileInfo;
        }
        FileObjRespVO objInfo = (FileObjRespVO)this.fileService.get(fileCode).getData();
        if (objInfo == null) {
            return null;
        }
        fileInfo = new FileInfoVO();
        fileInfo.setFileCode(fileCode);
        fileInfo.setOriginalName(objInfo.getOriginalName());
        fileInfo.setFileSize(objInfo.getFileSize());
        fileInfo.setSuffix(objInfo.getSuffix());
        fileInfo.setMimeType(objInfo.getMimeType());
        fileInfo.setUploadTime(objInfo.getUploadTime());
        fileInfo.setUrlPreview(objInfo.getUrlPreview());
        fileInfo.setUrlDownload(objInfo.getUrlDownload());
        fileInfo.setUrlDelete(objInfo.getUrlDelete());
        fileInfo.setUrl(objInfo.getUrl());
        return fileInfo;
    }

    public FileByteVO getFileForCompatibility(@NotBlank String fileCode) {
        Assert.notBlank((CharSequence)fileCode, (String)"\u6587\u4ef6\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        SysResourceByteDO resourceInfo = this.repoProc.getByResourceKey(fileCode);
        if (resourceInfo != null) {
            FileByteVO byteVO = new FileByteVO();
            byteVO.setBytes(resourceInfo.getResource());
            byteVO.setOriginalName(resourceInfo.getResourceName());
            byteVO.setFileSize(resourceInfo.getSize());
            byteVO.setSuffix(resourceInfo.getSuffix());
            byteVO.setMimeType(resourceInfo.getMimeType());
            return byteVO;
        }
        FileObjRespVO objInfo = (FileObjRespVO)this.fileService.get(fileCode).getData();
        if (objInfo == null) {
            return null;
        }
        HttpEntity resp = this.fileService.download(fileCode, null);
        if (resp == null || !resp.hasBody() || resp.getBody() == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ((StreamingResponseBody)resp.getBody()).writeTo((OutputStream)outputStream);
        }
        catch (Exception e) {
            log.warn("\u8f6c\u6210\u6a21\u677f\u6587\u4ef6{}\u5931\u8d25", (Object)fileCode, (Object)e);
            throw new BusinessException("\u5b58\u50a8\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        byte[] contents = outputStream.toByteArray();
        FileByteVO byteVO = new FileByteVO();
        byteVO.setBytes(contents);
        byteVO.setOriginalName(objInfo.getOriginalName());
        byteVO.setFileSize(objInfo.getFileSize());
        byteVO.setSuffix(objInfo.getSuffix());
        byteVO.setMimeType(objInfo.getMimeType());
        return byteVO;
    }

    private FileInfoVO convertVO(SysResourceByteDO byteDO) {
        FileInfoVO vo = new FileInfoVO();
        vo.setFileCode(byteDO.getResourceKey());
        vo.setOriginalName(byteDO.getResourceName());
        vo.setFileSize(byteDO.getSize());
        vo.setSuffix(byteDO.getSuffix());
        vo.setMimeType(byteDO.getMimeType());
        vo.setUploadTime(byteDO.getCreateTime());
        vo.setUrlPreview(null);
        vo.setUrlDownload(null);
        vo.setUrlDelete(null);
        vo.setUrl(null);
        return vo;
    }

    private String generateBusinessKey() {
        return DatetimeUtil.currentTimeLong() + RandomUtil.randomNumbers((int)6);
    }
}

