/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.constant.Gender;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.common.InnerUserEnum;
import com.elitescloud.cloudt.system.cacheable.SysCacheUserRpcService;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.constant.TenantType;
import com.elitescloud.cloudt.system.constant.UserSourceType;
import com.elitescloud.cloudt.system.convert.UserConvert;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.model.entity.SysUserTerminalDO;
import com.elitescloud.cloudt.system.service.ISysSettingService;
import com.elitescloud.cloudt.system.service.callback.UserChangedCallback;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.manager.AreaManager;
import com.elitescloud.cloudt.system.service.manager.PermissionMngManager;
import com.elitescloud.cloudt.system.service.manager.RoleMngManager;
import com.elitescloud.cloudt.system.service.model.bo.SysRoleSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysUserSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysUserTypeBO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserTypeDO;
import com.elitescloud.cloudt.system.service.repo.RoleRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysUserTerminalRepo;
import com.elitescloud.cloudt.system.service.repo.SysUserTerminalRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantUserRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRoleRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserTypeRepoProc;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class UserMngManager {
    private static final Logger log = LoggerFactory.getLogger(UserMngManager.class);
    private static final UserConvert CONVERT = UserConvert.INSTANCE;
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private SysUserTerminalRepo userTerminalRepo;
    @Autowired
    private SysUserTerminalRepoProc userTerminalRepoProc;
    @Autowired
    private UserTypeRepoProc userTypeRepoProc;
    @Autowired
    private UserRoleRepoProc userRoleRepoProc;
    @Autowired
    private RoleRepoProc roleRepoProc;
    @Autowired
    private TenantUserRepoProc tenantUserRepoProc;
    @Autowired
    private ObjectProvider<UserChangedCallback> userChangedCallbackObjectProvider;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private AuthorizationProperties authorizationProperties;
    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private AuthorizationSdkProperties authorizationSdkProperties;
    @Autowired(required=false)
    private UserTransferHelper userTransferHelper;
    @Autowired
    private TenantClientProvider tenantClientProvider;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private AreaManager areaManager;
    @Autowired
    private PermissionMngManager permissionMngManager;
    @Autowired
    private RoleMngManager roleMngManager;
    @Autowired
    private ISysSettingService sysSettingService;
    @Autowired
    private SysCacheUserRpcService cacheUserRpcService;

    public SysUserDO upsert(@NotNull SysUserSaveBO saveBO) {
        Long id = saveBO.getId();
        long tenantId = this.currentTenantId();
        SysUserDO userDO = id == null ? this.checkForInsert(saveBO) : this.checkForUpdate(saveBO, false);
        this.userRepoProc.save((Serializable)userDO);
        this.saveUserTypes(saveBO, userDO.getId(), tenantId);
        Set<String> userTypes = this.userTypeRepoProc.getUserType(userDO.getId(), tenantId);
        this.tenantDataIsolateProvider.byTenantAuto(() -> {
            this.saveUserTerminal(saveBO, userDO.getId());
            this.saveUserRole(userTypes, saveBO.getRoleCodesAdd(), userDO.getId(), tenantId);
            return null;
        });
        this.userChangedCallbackObjectProvider.forEach(callback -> callback.onUpsert(id == null, saveBO, userDO));
        this.cacheUserRpcService.clearCache();
        return userDO;
    }

    public void check(@NotNull SysUserSaveBO saveBO) {
        if (saveBO.getId() == null) {
            this.checkForInsert(saveBO);
            return;
        }
        this.checkForUpdate(saveBO, true);
    }

    public void updateEnabled(long id, Boolean enabled) {
        SysTenantDTO tenant = this.tenantClientProvider.getCurrentTenant();
        if (tenant == null || tenant.getType() == TenantType.OPERATION) {
            this.userRepoProc.updateEnabled(id, enabled);
        } else {
            int boundTenantNum = this.tenantUserRepoProc.listTenantIdByUserID(id, null).size();
            if (boundTenantNum <= 1) {
                this.userRepoProc.updateEnabled(id, enabled);
            }
        }
        this.userChangedCallbackObjectProvider.forEach(callback -> callback.onEnabled(Long.valueOf(id), enabled.booleanValue()));
        this.cacheUserRpcService.clearCache();
    }

    public void resetPassword(long id) {
        this.updatePassword(id, this.getDefaultPassword(), null, true);
    }

    public void updatePassword(long id, @NotBlank String password, String originalPassword, Boolean needReset) {
        Assert.hasText((String)password, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        boolean validated = this.isMatchedPassword(id, password, originalPassword);
        Assert.isTrue((boolean)validated, (String)"\u5f53\u524d\u5bc6\u7801\u4e0d\u6b63\u786e");
        String passwordNew = this.encryptPassword(password);
        this.userRepoProc.updatePassword(id, needReset == null || needReset != false, passwordNew);
        this.userChangedCallbackObjectProvider.forEach(callback -> callback.onUpdatePassword(Long.valueOf(id), password, originalPassword));
    }

    public void updateMobile(long id, String mobile) {
        if (StringUtils.hasText((String)mobile)) {
            List<Long> existsIds = this.userRepoProc.getIdByMobile(mobile);
            if (existsIds.contains(id)) {
                return;
            }
            if (this.systemProperties.getMobileUnique().booleanValue()) {
                Assert.isTrue((boolean)existsIds.isEmpty(), (String)"\u624b\u673a\u53f7\u5df2\u5b58\u5728");
            }
        }
        this.userRepoProc.updateMobile(id, mobile);
        this.userChangedCallbackObjectProvider.forEach(callback -> callback.onUpdateMobile(Long.valueOf(id), mobile));
        this.cacheUserRpcService.clearCache();
    }

    public void updateEmail(long id, String email) {
        if (StringUtils.hasText((String)email)) {
            List<Long> existsIds = this.userRepoProc.getIdByEmail(email);
            if (existsIds.contains(id)) {
                return;
            }
            if (this.systemProperties.getEmailUnique().booleanValue()) {
                Assert.isTrue((boolean)existsIds.isEmpty(), (String)"\u90ae\u7bb1\u5df2\u5b58\u5728");
            }
        }
        this.userRepoProc.updateEmail(id, email);
        this.userChangedCallbackObjectProvider.forEach(callback -> callback.onUpdateEmail(Long.valueOf(id), email));
        this.cacheUserRpcService.clearCache();
    }

    public void updateOuterKey(long id, String outerKey) {
        List<Long> existsIds;
        if (StringUtils.hasText((String)outerKey) && (existsIds = this.userRepoProc.getIdByOuterKey(outerKey)).contains(id)) {
            return;
        }
        this.userRepoProc.updateOuterKey(id, outerKey);
        this.cacheUserRpcService.clearCache();
    }

    public void delete(long id) {
        Long casUserId;
        String username = this.userRepoProc.getUsername(id);
        for (InnerUserEnum value : InnerUserEnum.values()) {
            if (!value.getUsername().equalsIgnoreCase(username)) continue;
            throw new IllegalStateException("\u5185\u7f6e\u8d26\u6237\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        SysTenantDTO tenant = this.tenantClientProvider.getCurrentTenant();
        List<Long> tenantIdsBelong = this.tenantUserRepoProc.listTenantIdByUserID(id, null);
        if (tenant == null || tenant.getType() == TenantType.OPERATION || tenantIdsBelong.isEmpty() || tenantIdsBelong.size() == 1 && Objects.equals(tenantIdsBelong.get(0), tenant.getId())) {
            casUserId = this.userRepoProc.getCasUserId(id);
            this.userRepoProc.delete(id);
            this.tenantUserRepoProc.deleteByUserId(id);
        } else {
            casUserId = null;
            this.tenantUserRepoProc.delete(tenant.getId(), id);
            this.userTypeRepoProc.deleteByUserId(id, tenant.getId());
            this.tenantDataIsolateProvider.byTenantDirectly(() -> {
                this.userTerminalRepoProc.deleteByUserId(id);
                this.userRoleRepoProc.deleteByUser(id);
                return null;
            }, tenant);
        }
        this.userChangedCallbackObjectProvider.forEach(callback -> callback.onDelete(Long.valueOf(id), casUserId));
        this.cacheUserRpcService.clearCache();
    }

    public void updateUserType(long id, @NotBlank String userType, String identityId) {
        SysUserTypeDO userTypeDO;
        long tenantId = this.currentTenantId();
        List<SysUserTypeBO> userTypeBoList = this.userTypeRepoProc.getUserTypeBO(id, tenantId);
        boolean isBlankOfIdentityId = CharSequenceUtil.isBlank((CharSequence)identityId);
        boolean existsNoIdentityId = false;
        for (SysUserTypeBO sysUserTypeBO : userTypeBoList) {
            if (!userType.equals(sysUserTypeBO.getUserType())) continue;
            if (isBlankOfIdentityId) {
                return;
            }
            if (identityId.equals(sysUserTypeBO.getIdentityId())) {
                return;
            }
            if (!CharSequenceUtil.isBlank((CharSequence)sysUserTypeBO.getIdentityId())) continue;
            existsNoIdentityId = true;
        }
        if (isBlankOfIdentityId) {
            userTypeDO = new SysUserTypeDO();
            userTypeDO.setUserId(Long.valueOf(id));
            userTypeDO.setType(userType);
            userTypeDO.setIdentityId(null);
            userTypeDO.setSysTenantId(Long.valueOf(tenantId));
            this.userTypeRepoProc.save((Serializable)userTypeDO);
            return;
        }
        if (existsNoIdentityId) {
            this.userTypeRepoProc.updateIdentityId(id, tenantId, userType, identityId);
            return;
        }
        userTypeDO = new SysUserTypeDO();
        userTypeDO.setUserId(Long.valueOf(id));
        userTypeDO.setType(userType);
        userTypeDO.setIdentityId(identityId);
        userTypeDO.setSysTenantId(Long.valueOf(tenantId));
        this.userTypeRepoProc.save((Serializable)userTypeDO);
    }

    public void deleteUserType(long id, @NotBlank String userType, String identityId) {
        long tenantId = this.currentTenantId();
        this.userTypeRepoProc.deleteIdentityId(id, tenantId, userType, identityId);
    }

    public List<UserChangedCallback> getUserChangedCallbacks() {
        return this.userChangedCallbackObjectProvider.stream().collect(Collectors.toList());
    }

    public SysUserSaveBO getUserSaveBO(long id) {
        SysUserDO userDO = (SysUserDO)this.userRepoProc.get(id);
        if (userDO == null) {
            return null;
        }
        SysUserSaveBO saveBO = CONVERT.do2SaveBo(userDO);
        saveBO.setAreaBO(this.areaManager.getAreaBO(userDO.getProvinceCode(), userDO.getCityCode(), userDO.getCountyCode()));
        long tenantId = this.currentTenantId();
        saveBO.setTerminals(new HashSet<String>(this.userTerminalRepoProc.getTerminalStrByUserId(id)));
        saveBO.setUserTypes(new HashSet<SysUserTypeBO>(this.userTypeRepoProc.getUserTypeBO(id, tenantId)));
        return saveBO;
    }

    public String getDefaultPassword() {
        SysSettingVO setting = this.sysSettingService.oneByNo("SYS_DEFAULT_USER_PWD");
        if (setting != null && StrUtil.isNotBlank((CharSequence)setting.getSettingVal())) {
            return setting.getSettingVal();
        }
        return StrUtil.blankToDefault((CharSequence)this.authorizationProperties.getDefaultPassword(), (String)"123456");
    }

    private boolean isMatchedPassword(long id, String password, String originalPassword) {
        Long casUserId;
        if (Boolean.TRUE.equals(this.authorizationSdkProperties.getCasClient().getSupportValidatePassword()) && (casUserId = this.userRepoProc.getCasUserId(id)) != null && this.userTransferHelper != null) {
            log.info("\u901a\u8fc7CAS\u6821\u9a8c\u5bc6\u7801\uff1a{}", (Object)id);
            try {
                Result validateResult = this.userTransferHelper.validatePwd(casUserId, originalPassword, password);
                if (Boolean.FALSE.equals(validateResult.getSuccess())) {
                    throw new BusinessException(validateResult.getMsg());
                }
                return true;
            }
            catch (Exception e) {
                if (e instanceof BusinessException) {
                    throw e;
                }
                log.error("\u901a\u8fc7CAS\u6821\u9a8c\u5bc6\u7801\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CharSequenceUtil.isBlank((CharSequence)originalPassword)) {
            return true;
        }
        String pwdEncoded = this.userRepoProc.getPassword(id);
        return this.passwordEncoder.matches((CharSequence)originalPassword, pwdEncoded);
    }

    private void saveUserRole(Set<String> userTypes, Set<String> rolesAdd, Long userId, Long tenantId) {
        HashSet<String> newRoleCodes = new HashSet<String>(8);
        HashMap<String, String> addRoleMap = new HashMap<String, String>(8);
        if (CollUtil.isNotEmpty((Map)this.systemProperties.getDefaultUserTypeRole()) && CollUtil.isNotEmpty(userTypes)) {
            for (Map.Entry entry : this.systemProperties.getDefaultUserTypeRole().entrySet()) {
                if (!userTypes.contains(entry.getKey()) || CharSequenceUtil.isBlank((CharSequence)((CodeNameParam)entry.getValue()).getCode())) continue;
                addRoleMap.put(((CodeNameParam)entry.getValue()).getCode(), ((CodeNameParam)entry.getValue()).getName());
            }
            newRoleCodes.addAll(addRoleMap.keySet());
            log.info("\u7528\u6237\u9ed8\u8ba4\u89d2\u8272\uff1a{}", (Object)JSONUtil.toJsonString(newRoleCodes));
        }
        if (CollUtil.isNotEmpty(rolesAdd)) {
            newRoleCodes.addAll(rolesAdd);
        }
        if (newRoleCodes.isEmpty()) {
            return;
        }
        if (!addRoleMap.isEmpty()) {
            Set<String> existsRoleCodes = this.roleRepoProc.getIdAndCodeByCode(addRoleMap.keySet()).keySet();
            for (Map.Entry newRole : addRoleMap.entrySet()) {
                if (existsRoleCodes.contains(newRole.getKey())) continue;
                SysRoleSaveBO roleSaveBO = new SysRoleSaveBO();
                roleSaveBO.setCode((String)newRole.getKey());
                roleSaveBO.setName((String)newRole.getValue());
                roleSaveBO.setEnabled(Boolean.valueOf(true));
                roleSaveBO.setGroupId(Long.valueOf(-1L));
                roleSaveBO.setType(BelongType.TENANT.getValue());
                roleSaveBO.setTypeId(tenantId.toString());
                this.roleMngManager.upsert(roleSaveBO);
            }
        }
        this.permissionMngManager.addUserRole(Set.of(userId), newRoleCodes);
    }

    private void saveUserTerminal(SysUserSaveBO saveBO, Long userId) {
        List<String> terminalOld = this.userTerminalRepoProc.getTerminalStrByUserId(userId);
        LocalDateTime now = LocalDateTime.now();
        if (CollUtil.isNotEmpty((Collection)saveBO.getTerminalsAdd())) {
            if (CollUtil.isEmpty((Collection)saveBO.getTerminals())) {
                List terminalsToAdd = saveBO.getTerminalsAdd().stream().filter(t -> !terminalOld.contains(t)).map(t -> {
                    SysUserTerminalDO userTerminalDO = new SysUserTerminalDO();
                    userTerminalDO.setUserId(userId);
                    userTerminalDO.setTerminalCode((String)t);
                    userTerminalDO.setTimeBind(now);
                    return userTerminalDO;
                }).collect(Collectors.toList());
                if (!terminalsToAdd.isEmpty()) {
                    this.userTerminalRepo.saveAll(terminalsToAdd);
                }
                return;
            }
            saveBO.getTerminals().addAll(saveBO.getTerminalsAdd());
        }
        if (CollectionUtils.isEmpty((Collection)saveBO.getTerminals())) {
            if (terminalOld.isEmpty()) {
                return;
            }
            this.userTerminalRepoProc.deleteByUserId(userId);
            return;
        }
        List userTerminals = saveBO.getTerminals().stream().filter(t -> !terminalOld.contains(t)).map(t -> {
            SysUserTerminalDO userTerminalDO = new SysUserTerminalDO();
            userTerminalDO.setUserId(userId);
            userTerminalDO.setTerminalCode((String)t);
            userTerminalDO.setTimeBind(now);
            return userTerminalDO;
        }).collect(Collectors.toList());
        if (!userTerminals.isEmpty()) {
            this.userTerminalRepo.saveAll(userTerminals);
        }
        if (terminalOld.isEmpty()) {
            return;
        }
        Set<String> terminalsToDel = terminalOld.stream().filter(t -> !saveBO.getTerminals().contains(t)).collect(Collectors.toSet());
        if (!terminalsToDel.isEmpty()) {
            this.userTerminalRepoProc.delete(userId, terminalsToDel);
        }
    }

    private long currentTenantId() {
        SysTenantDTO tenant = this.tenantClientProvider.getSessionTenant();
        if (tenant == null) {
            tenant = this.tenantClientProvider.getCurrentTenant();
        }
        return tenant == null ? TenantConstant.DEFAULT_TENANT_ID : tenant.getId();
    }

    private void saveUserTypes(SysUserSaveBO saveBO, Long userId, Long tenantId) {
        String type;
        Object tempTypesOfNoIds;
        Object key;
        SysUserTypeDO userTypeDO;
        if (CollUtil.isNotEmpty((Collection)saveBO.getUserTypes())) {
            saveBO.setUserTypes(saveBO.getUserTypes().stream().filter(t -> CharSequenceUtil.isNotBlank((CharSequence)t.getUserType())).collect(Collectors.toSet()));
        }
        if (CollUtil.isNotEmpty((Collection)saveBO.getUserTypesAdd())) {
            saveBO.setUserTypesAdd(saveBO.getUserTypesAdd().stream().filter(t -> CharSequenceUtil.isNotBlank((CharSequence)t.getUserType())).collect(Collectors.toSet()));
        }
        if (CollUtil.isEmpty((Collection)saveBO.getUserTypes()) && CollUtil.isEmpty((Collection)saveBO.getUserTypesAdd())) {
            this.userTypeRepoProc.deleteByUserId(userId, tenantId);
            return;
        }
        List<SysUserTypeDO> typeOldList = this.userTypeRepoProc.getUserTypeList(userId, tenantId);
        Map typesMapOfNoId = typeOldList.isEmpty() ? Collections.emptyMap() : typeOldList.stream().filter(t -> CharSequenceUtil.isBlank((CharSequence)t.getIdentityId())).collect(Collectors.toMap(SysUserTypeDO::getType, t -> t, (t1, t2) -> t1));
        Map typesMapOfHasId = typeOldList.isEmpty() ? Collections.emptyMap() : typeOldList.stream().filter(t -> CharSequenceUtil.isNotBlank((CharSequence)t.getIdentityId())).collect(Collectors.toMap(t -> t.getType() + ":" + t.getIdentityId(), t -> t, (t1, t2) -> t1));
        HashSet<String> typesOfNoId = new HashSet<String>();
        HashSet<Object> typesOfHasId = new HashSet<Object>();
        if (CollUtil.isNotEmpty((Collection)saveBO.getUserTypesAdd())) {
            for (SysUserTypeBO sysUserTypeBO : saveBO.getUserTypesAdd()) {
                if (CharSequenceUtil.isBlank((CharSequence)sysUserTypeBO.getIdentityId())) {
                    if (typesMapOfNoId.containsKey(sysUserTypeBO.getUserType()) || typesOfNoId.contains(sysUserTypeBO.getUserType())) {
                        typesOfNoId.add(sysUserTypeBO.getUserType());
                        continue;
                    }
                    typesOfNoId.add(sysUserTypeBO.getUserType());
                    userTypeDO = new SysUserTypeDO();
                    userTypeDO.setUserId(userId);
                    userTypeDO.setType(sysUserTypeBO.getUserType());
                    userTypeDO.setIdentityId(null);
                    userTypeDO.setSysTenantId(tenantId);
                    this.userTypeRepoProc.save((Serializable)userTypeDO);
                    continue;
                }
                key = sysUserTypeBO.getUserType() + ":" + sysUserTypeBO.getIdentityId();
                if (typesMapOfHasId.containsKey(key) || typesOfHasId.contains(key)) {
                    typesOfHasId.add(key);
                    continue;
                }
                typesOfHasId.add(key);
                SysUserTypeDO userTypeDO2 = new SysUserTypeDO();
                userTypeDO2.setUserId(userId);
                userTypeDO2.setType(sysUserTypeBO.getUserType());
                userTypeDO2.setIdentityId(sysUserTypeBO.getIdentityId());
                userTypeDO2.setSysTenantId(tenantId);
                this.userTypeRepoProc.save((Serializable)userTypeDO2);
            }
        }
        if (CollectionUtils.isEmpty((Collection)saveBO.getUserTypes())) {
            tempTypesOfNoIds = new HashSet(typesMapOfNoId.keySet());
            tempTypesOfNoIds.addAll(typesOfNoId);
            HashSet hashSet = new HashSet(typesMapOfHasId.keySet());
            hashSet.addAll(typesOfHasId);
            key = tempTypesOfNoIds.iterator();
            block1: while (key.hasNext()) {
                type = (String)key.next();
                for (String s : hashSet) {
                    if (!type.equals(s.split(":")[0])) continue;
                    this.userTypeRepoProc.deleteIdentityId(userId, tenantId, type, null);
                    continue block1;
                }
            }
            return;
        }
        for (SysUserTypeBO sysUserTypeBO : saveBO.getUserTypes()) {
            if (CharSequenceUtil.isBlank((CharSequence)sysUserTypeBO.getIdentityId())) {
                if (typesOfNoId.contains(sysUserTypeBO.getUserType())) continue;
                typesOfNoId.add(sysUserTypeBO.getUserType());
                if (typesMapOfNoId.containsKey(sysUserTypeBO.getUserType())) continue;
                userTypeDO = new SysUserTypeDO();
                userTypeDO.setUserId(userId);
                userTypeDO.setType(sysUserTypeBO.getUserType());
                userTypeDO.setIdentityId(null);
                userTypeDO.setSysTenantId(tenantId);
                this.userTypeRepoProc.save((Serializable)userTypeDO);
                continue;
            }
            if (typesOfHasId.contains(sysUserTypeBO.getUserType() + ":" + sysUserTypeBO.getIdentityId())) continue;
            typesOfHasId.add(sysUserTypeBO.getUserType() + ":" + sysUserTypeBO.getIdentityId());
            if (typesMapOfHasId.containsKey(sysUserTypeBO.getUserType() + ":" + sysUserTypeBO.getIdentityId())) continue;
            userTypeDO = new SysUserTypeDO();
            userTypeDO.setUserId(userId);
            userTypeDO.setType(sysUserTypeBO.getUserType());
            userTypeDO.setIdentityId(sysUserTypeBO.getIdentityId());
            userTypeDO.setSysTenantId(tenantId);
            this.userTypeRepoProc.save((Serializable)userTypeDO);
        }
        if (!typesMapOfNoId.isEmpty()) {
            for (Map.Entry entry : typesMapOfNoId.entrySet()) {
                if (typesOfNoId.contains(((SysUserTypeDO)entry.getValue()).getType())) continue;
                this.userTypeRepoProc.delete(((SysUserTypeDO)entry.getValue()).getId());
            }
        }
        if (!typesMapOfHasId.isEmpty()) {
            for (Map.Entry entry : typesMapOfHasId.entrySet()) {
                if (typesOfHasId.contains(((SysUserTypeDO)entry.getValue()).getType() + ":" + ((SysUserTypeDO)entry.getValue()).getIdentityId())) continue;
                this.userTypeRepoProc.delete(((SysUserTypeDO)entry.getValue()).getId());
            }
        }
        tempTypesOfNoIds = new HashSet(typesMapOfNoId.keySet());
        tempTypesOfNoIds.addAll(typesOfNoId);
        HashSet hashSet = new HashSet(typesMapOfHasId.keySet());
        hashSet.addAll(typesOfHasId);
        Iterator iterator = tempTypesOfNoIds.iterator();
        block6: while (iterator.hasNext()) {
            type = (String)iterator.next();
            for (String s : hashSet) {
                if (!type.equals(s.split(":")[0])) continue;
                this.userTypeRepoProc.deleteIdentityId(userId, tenantId, type, null);
                continue block6;
            }
        }
    }

    private SysUserDO checkForInsert(SysUserSaveBO saveBO) {
        SysUserDO userDO = CONVERT.saveBo2Do(saveBO, saveBO.getAreaBO());
        Assert.hasText((String)saveBO.getUsername(), (String)"\u767b\u5f55\u8d26\u53f7\u4e3a\u7a7a");
        boolean exists = this.userRepoProc.existsUsername(saveBO.getUsername());
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728");
        if (StringUtils.hasText((String)saveBO.getOuterKey())) {
            exists = this.userRepoProc.existsOuterKey(saveBO.getOuterKey());
            if (exists) {
                throw new BusinessException("\u5916\u90e8\u6807\u8bc6\u5df2\u5b58\u5728");
            }
        } else {
            saveBO.setOuterKey("");
        }
        if (StrUtil.isBlank((CharSequence)saveBO.getPassword())) {
            saveBO.setPassword(this.getDefaultPassword());
        }
        userDO.setPassword(this.encryptPassword(saveBO.getPassword()));
        userDO.setNeedReset((Boolean)ObjectUtil.defaultIfNull((Object)saveBO.getNeedReset(), (Object)true));
        userDO.setLastName(CharSequenceUtil.blankToDefault((CharSequence)saveBO.getFullName(), (String)saveBO.getUsername()));
        userDO.setFirstName(null);
        if (StringUtils.hasText((String)saveBO.getGender())) {
            Gender gender = Gender.valueOf((String)saveBO.getGender());
            Assert.notNull((Object)gender, (String)("\u672a\u77e5\u6027\u522b\u7c7b\u578b" + saveBO.getGender()));
        } else {
            userDO.setGender(Gender.SECRET.getValue());
        }
        userDO.setMobile(CharSequenceUtil.nullToDefault((CharSequence)saveBO.getMobile(), (String)""));
        if (this.systemProperties.getMobileUnique().booleanValue() && StringUtils.hasText((String)saveBO.getMobile())) {
            exists = this.userRepoProc.existsMobile(saveBO.getMobile());
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        userDO.setEmail(CharSequenceUtil.nullToDefault((CharSequence)saveBO.getEmail(), (String)""));
        if (this.systemProperties.getEmailUnique().booleanValue() && StringUtils.hasText((String)saveBO.getEmail())) {
            exists = this.userRepoProc.existsEmail(saveBO.getEmail());
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u90ae\u7bb1\u5df2\u5b58\u5728");
        }
        userDO.setIdCard(CharSequenceUtil.nullToDefault((CharSequence)saveBO.getIdCard(), (String)""));
        if (this.systemProperties.getIdCardUnique().booleanValue() && StringUtils.hasText((String)saveBO.getIdCard())) {
            exists = this.userRepoProc.existsIdCard(saveBO.getIdCard());
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728");
        }
        if (saveBO.getEnabled() == null) {
            userDO.setEnabled(Boolean.valueOf(true));
        }
        if (StringUtils.hasText((String)saveBO.getSourceType())) {
            UserSourceType sourceType = UserSourceType.parse((String)saveBO.getSourceType());
            Assert.notNull((Object)sourceType, (String)"\u672a\u77e5\u8d26\u53f7\u6765\u6e90\u7c7b\u578b");
        }
        this.checkUserTerminal(saveBO.getTerminals());
        this.checkUserTerminal(saveBO.getTerminalsAdd());
        userDO.setTenantId(TenantConstant.DEFAULT_TENANT_ID);
        userDO.setSyncCas(Boolean.valueOf(true));
        return userDO;
    }

    private SysUserDO checkForUpdate(SysUserSaveBO saveBO, boolean checkOnly) {
        SysUserDO userDO = (SysUserDO)this.userRepoProc.get(saveBO.getId());
        Assert.notNull((Object)userDO, (String)"\u8d26\u53f7\u4e0d\u5b58\u5728");
        boolean exists = false;
        Assert.hasText((String)saveBO.getUsername(), (String)"\u767b\u5f55\u8d26\u53f7\u4e3a\u7a7a");
        if (this.systemProperties.getUsernameEditable().booleanValue()) {
            if (!userDO.getUsername().equals(saveBO.getUsername())) {
                exists = this.userRepoProc.existsUsername(saveBO.getUsername());
                Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728");
            }
        } else {
            Long idTemp = this.userRepoProc.getIdByUsername(saveBO.getUsername());
            if (idTemp != null && idTemp.longValue() != saveBO.getId().longValue()) {
                throw new IllegalArgumentException("\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728");
            }
        }
        if (StringUtils.hasText((String)saveBO.getOuterKey())) {
            exists = this.userRepoProc.existsOuterKey(saveBO.getOuterKey(), userDO.getId());
            if (exists) {
                throw new BusinessException("\u5916\u90e8\u6807\u8bc6\u5df2\u5b58\u5728");
            }
        } else {
            saveBO.setOuterKey("");
        }
        String pwd = userDO.getPassword();
        if (StringUtils.hasText((String)saveBO.getPassword())) {
            pwd = this.encryptPassword(saveBO.getPassword());
        }
        if (saveBO.getNeedReset() == null) {
            saveBO.setNeedReset((Boolean)ObjectUtil.defaultIfNull((Object)userDO.getNeedReset(), (Object)true));
        }
        userDO.setLastName(saveBO.getFullName());
        userDO.setFirstName(null);
        if (StringUtils.hasText((String)saveBO.getGender())) {
            Gender gender = Gender.valueOf((String)saveBO.getGender());
            Assert.notNull((Object)gender, (String)("\u672a\u77e5\u6027\u522b\u7c7b\u578b" + saveBO.getGender()));
        } else {
            saveBO.setGender(Gender.SECRET.getValue());
        }
        if (this.systemProperties.getMobileUnique().booleanValue() && StringUtils.hasText((String)saveBO.getMobile()) && !saveBO.getMobile().equals(userDO.getMobile())) {
            exists = this.userRepoProc.existsMobile(saveBO.getMobile());
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        if (this.systemProperties.getEmailUnique().booleanValue() && StringUtils.hasText((String)saveBO.getEmail()) && !saveBO.getEmail().equals(userDO.getEmail())) {
            exists = this.userRepoProc.existsEmail(saveBO.getEmail());
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u90ae\u7bb1\u5df2\u5b58\u5728");
        }
        if (this.systemProperties.getIdCardUnique().booleanValue() && StringUtils.hasText((String)saveBO.getIdCard()) && !saveBO.getIdCard().equals(userDO.getIdCard())) {
            exists = this.userRepoProc.existsIdCard(saveBO.getIdCard());
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728");
        }
        if (saveBO.getEnabled() == null) {
            saveBO.setEnabled(Boolean.valueOf(true));
        }
        saveBO.setSourceType(userDO.getSourceType());
        this.checkUserTerminal(saveBO.getTerminals());
        this.checkUserTerminal(saveBO.getTerminalsAdd());
        if (checkOnly) {
            return userDO;
        }
        CONVERT.copySaveBo2Do(saveBO, saveBO.getAreaBO(), userDO);
        userDO.setId(saveBO.getId());
        userDO.setPassword(pwd);
        userDO.setSyncCas(Boolean.valueOf(true));
        return userDO;
    }

    private void checkUserTerminal(Set<String> terminals) {
        if (CollUtil.isEmpty(terminals)) {
            return;
        }
        for (String terminal : terminals) {
            Assert.notNull((Object)Terminal.parse((String)terminal), (String)("\u672a\u77e5\u7ec8\u7aef\u7c7b\u578b" + terminal));
        }
    }

    private String encryptPassword(String password) {
        if (!StringUtils.hasText((String)password)) {
            password = this.getDefaultPassword();
        }
        return this.passwordEncoder.encode((CharSequence)password);
    }
}

