/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.bo.BusinessOperationParamBO;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectParamInEnum;
import com.elitescloud.cloudt.system.service.common.constant.OpenApiSourceEnum;
import com.elitescloud.cloudt.system.service.model.entity.QSysBusinessOperationParamDO;
import com.elitescloud.cloudt.system.service.model.entity.SysBusinessOperationParamDO;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class BusinessOperationParamRepoProc
extends BaseRepoProc<SysBusinessOperationParamDO> {
    private static final QSysBusinessOperationParamDO QDO = QSysBusinessOperationParamDO.sysBusinessOperationParamDO;

    public BusinessOperationParamRepoProc() {
        super((EntityPathBase)QDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteForGatherByOpenApiCode(@NotBlank String openApiCode) {
        BooleanExpression predicate = BusinessOperationParamRepoProc.QDO.openApiCode.eq((Object)openApiCode).and((Predicate)BusinessOperationParamRepoProc.QDO.dataSource.in((Object[])new String[]{OpenApiSourceEnum.GATHER_PULL.name(), OpenApiSourceEnum.GATHER_PUSH.name()}));
        super.delete((Predicate)predicate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByBusinessObjectId(long businessObjectId) {
        super.delete((Predicate)BusinessOperationParamRepoProc.QDO.businessObjectId.eq((Object)businessObjectId));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByBusinessObjectId(Collection<Long> businessObjectIds) {
        super.delete((Predicate)BusinessOperationParamRepoProc.QDO.businessObjectId.in(businessObjectIds));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByBusinessOperationId(long businessOperationId) {
        super.delete((Predicate)BusinessOperationParamRepoProc.QDO.businessOperationId.eq((Object)businessOperationId));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByBusinessOperationId(Collection<Long> businessOperationIds) {
        super.delete((Predicate)BusinessOperationParamRepoProc.QDO.businessOperationId.in(businessOperationIds));
    }

    public List<SysBusinessOperationParamDO> listByOpenApiCode(@NotBlank String openApiCode) {
        return super.getList((Predicate)BusinessOperationParamRepoProc.QDO.openApiCode.eq((Object)openApiCode), new OrderSpecifier[0]);
    }

    public List<BusinessOperationParamBO> listBoByOperationId(long businessOperationId, BusinessObjectParamInEnum paramIn) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)BusinessOperationParamRepoProc.QDO.businessOperationId, (Object)businessOperationId).andEq((SimpleExpression)BusinessOperationParamRepoProc.QDO.paramIn, (Object)(paramIn == null ? null : paramIn.getValue())).build();
        return super.getList(this.qBeanSimpleBO(), predicate, new OrderSpecifier[0]);
    }

    public List<BusinessOperationParamBO> listBoByOperationCode(String businessOperationCode, BusinessObjectParamInEnum paramIn) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)BusinessOperationParamRepoProc.QDO.businessOperationCode, (Object)businessOperationCode).andEq((SimpleExpression)BusinessOperationParamRepoProc.QDO.paramIn, (Object)(paramIn == null ? null : paramIn.getValue())).build();
        return super.getList(this.qBeanSimpleBO(), predicate, new OrderSpecifier[0]);
    }

    private QBean<BusinessOperationParamBO> qBeanSimpleBO() {
        return Projections.bean(BusinessOperationParamBO.class, (Expression[])new Expression[]{BusinessOperationParamRepoProc.QDO.id, BusinessOperationParamRepoProc.QDO.businessOperationCode, BusinessOperationParamRepoProc.QDO.fieldName, BusinessOperationParamRepoProc.QDO.fieldDescription, BusinessOperationParamRepoProc.QDO.fieldType, BusinessOperationParamRepoProc.QDO.fieldJavaType, BusinessOperationParamRepoProc.QDO.fieldPermissionFilter, BusinessOperationParamRepoProc.QDO.request, BusinessOperationParamRepoProc.QDO.ref, BusinessOperationParamRepoProc.QDO.refValue, BusinessOperationParamRepoProc.QDO.depth, BusinessOperationParamRepoProc.QDO.paramPath, BusinessOperationParamRepoProc.QDO.apiResult, BusinessOperationParamRepoProc.QDO.pagingResult, BusinessOperationParamRepoProc.QDO.paramIn, BusinessOperationParamRepoProc.QDO.required, BusinessOperationParamRepoProc.QDO.deprecated, BusinessOperationParamRepoProc.QDO.single, BusinessOperationParamRepoProc.QDO.enabled});
    }
}

