/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.org.EmpGroupEmpPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmpGroupEmpPageRespVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmpGroupDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmpGroupEmpDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmpGroupEmpDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class EmpGroupEmpRepoProc
extends BaseRepoProc<SysEmpGroupEmpDO> {
    private static final QSysEmpGroupEmpDO QDO = QSysEmpGroupEmpDO.sysEmpGroupEmpDO;
    private static final QSysEmpGroupDO QDO_GROUP = QSysEmpGroupDO.sysEmpGroupDO;
    private static final QSysEmployeeDO QDO_EMP = QSysEmployeeDO.sysEmployeeDO;

    public EmpGroupEmpRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void deleteEmployeeByGroupId(long groupId) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{EmpGroupEmpRepoProc.QDO.groupId.eq((Object)groupId)}).execute();
    }

    public void deleteEmployeeByGroupId(long groupId, long empId) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{EmpGroupEmpRepoProc.QDO.groupId.eq((Object)groupId).and((Predicate)EmpGroupEmpRepoProc.QDO.empId.eq((Object)empId))}).execute();
    }

    public List<Long> getEmployeeIdOfGroup(long groupId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)EmpGroupEmpRepoProc.QDO.empId).from((EntityPath)QDO)).where((Predicate)EmpGroupEmpRepoProc.QDO.groupId.eq((Object)groupId))).fetch();
    }

    public List<Long> getEmployeeIdOfGroup(String groupCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)EmpGroupEmpRepoProc.QDO.empId).from((EntityPath)QDO)).where((Predicate)EmpGroupEmpRepoProc.QDO.groupId.eq((Expression)JPAExpressions.select((Expression)EmpGroupEmpRepoProc.QDO_GROUP.id).from(new EntityPath[]{QDO_GROUP}).where(new Predicate[]{EmpGroupEmpRepoProc.QDO_GROUP.code.eq((Object)groupCode)})))).fetch();
    }

    public PagingVO<EmpGroupEmpPageRespVO> pageMng(EmpGroupEmpPageQueryVO queryVO) {
        if (queryVO.getGroupId() == null) {
            return PagingVO.empty();
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(true, (SimpleExpression)EmpGroupEmpRepoProc.QDO.groupId, (Object)queryVO.getGroupId()).andLike((StringExpression)EmpGroupEmpRepoProc.QDO_EMP.code, queryVO.getEmployeeCode()).andLike((StringExpression)EmpGroupEmpRepoProc.QDO_EMP.lastName, queryVO.getEmpName()).build();
        QBean bean = Projections.bean(EmpGroupEmpPageRespVO.class, (Expression[])new Expression[]{EmpGroupEmpRepoProc.QDO_EMP.id.as("employeeId"), EmpGroupEmpRepoProc.QDO_EMP.code.as("employeeCode"), EmpGroupEmpRepoProc.QDO_EMP.lastName.as("employeeName"), EmpGroupEmpRepoProc.QDO_EMP.userId.as("userId"), EmpGroupEmpRepoProc.QDO_EMP.duty.as("duty"), EmpGroupEmpRepoProc.QDO_EMP.enabled.as("enabled"), EmpGroupEmpRepoProc.QDO_EMP.served.as("served"), EmpGroupEmpRepoProc.QDO.createTime.as("createTime")});
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)bean).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_EMP)).on((Predicate)EmpGroupEmpRepoProc.QDO_EMP.id.eq((Expression)EmpGroupEmpRepoProc.QDO.empId))).where(predicate);
        return super.queryByPage(jpaQuery, queryVO.getPageRequest());
    }

    public List<Long> queryUserIdOfGroup(@NotEmpty String groupCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)EmpGroupEmpRepoProc.QDO_EMP.userId).from((EntityPath)QDO_EMP)).where((Predicate)EmpGroupEmpRepoProc.QDO_EMP.id.in((SubQueryExpression)JPAExpressions.select((Expression)EmpGroupEmpRepoProc.QDO.empId).from(new EntityPath[]{QDO}).where(new Predicate[]{EmpGroupEmpRepoProc.QDO.groupId.eq((Expression)JPAExpressions.select((Expression)EmpGroupEmpRepoProc.QDO_GROUP.id).from(new EntityPath[]{QDO_GROUP}).where(new Predicate[]{EmpGroupEmpRepoProc.QDO_GROUP.code.eq((Object)groupCode)}))})))).fetch();
    }

    public Map<String, List<Long>> queryUserIdOfGroup(@NotEmpty Collection<String> groupCodes) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{EmpGroupEmpRepoProc.QDO_EMP.userId, EmpGroupEmpRepoProc.QDO_GROUP.code}).from((EntityPath)QDO_EMP)).leftJoin((EntityPath)QDO)).on((Predicate)EmpGroupEmpRepoProc.QDO.empId.eq((Expression)EmpGroupEmpRepoProc.QDO_EMP.id))).leftJoin((EntityPath)QDO_GROUP)).on((Predicate)EmpGroupEmpRepoProc.QDO_GROUP.id.eq((Expression)EmpGroupEmpRepoProc.QDO.groupId))).where((Predicate)EmpGroupEmpRepoProc.QDO_GROUP.code.in(groupCodes))).fetch().stream().collect(Collectors.groupingBy(t -> (String)t.get((Expression)EmpGroupEmpRepoProc.QDO_GROUP.code), Collectors.collectingAndThen(Collectors.toList(), t -> t.stream().map(tt -> (Long)tt.get((Expression)EmpGroupEmpRepoProc.QDO_EMP.userId)).collect(Collectors.toList()))));
    }

    public Map<String, List<IdCodeNameParam>> queryUserOfGroup(@NotEmpty Collection<String> groupCodes) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{EmpGroupEmpRepoProc.QDO_EMP.userId, EmpGroupEmpRepoProc.QDO_EMP.code, EmpGroupEmpRepoProc.QDO_EMP.username, EmpGroupEmpRepoProc.QDO_EMP.lastName, EmpGroupEmpRepoProc.QDO_EMP.firstName, EmpGroupEmpRepoProc.QDO_GROUP.code}).from((EntityPath)QDO_EMP)).leftJoin((EntityPath)QDO)).on((Predicate)EmpGroupEmpRepoProc.QDO.empId.eq((Expression)EmpGroupEmpRepoProc.QDO_EMP.id))).leftJoin((EntityPath)QDO_GROUP)).on((Predicate)EmpGroupEmpRepoProc.QDO_GROUP.id.eq((Expression)EmpGroupEmpRepoProc.QDO.groupId))).where((Predicate)EmpGroupEmpRepoProc.QDO_GROUP.code.in(groupCodes))).fetch().stream().collect(Collectors.groupingBy(t -> (String)t.get((Expression)EmpGroupEmpRepoProc.QDO_GROUP.code), Collectors.mapping(t -> {
            IdCodeNameParam idCodeNameParam = new IdCodeNameParam();
            idCodeNameParam.setId((Long)t.get((Expression)EmpGroupEmpRepoProc.QDO_EMP.userId));
            idCodeNameParam.setCode(CharSequenceUtil.blankToDefault((CharSequence)((CharSequence)t.get((Expression)EmpGroupEmpRepoProc.QDO_EMP.code)), (String)((String)t.get((Expression)EmpGroupEmpRepoProc.QDO_EMP.username))));
            idCodeNameParam.setName(this.getUserFullName((String)t.get((Expression)EmpGroupEmpRepoProc.QDO_EMP.lastName), (String)t.get((Expression)EmpGroupEmpRepoProc.QDO_EMP.firstName)));
            return idCodeNameParam;
        }, Collectors.toList())));
    }

    public List<Long> queryEmpIdOfSameGroup(long empId) {
        QSysEmpGroupEmpDO qdoSub = new QSysEmpGroupEmpDO("qdoSub");
        JPQLQuery groupSubQuery = (JPQLQuery)JPAExpressions.select((Expression)EmpGroupEmpRepoProc.QDO_GROUP.id).from(new EntityPath[]{QDO_GROUP}).where(new Predicate[]{EmpGroupEmpRepoProc.QDO_GROUP.id.in((SubQueryExpression)JPAExpressions.select((Expression)qdoSub.groupId).from(new EntityPath[]{qdoSub}).where(new Predicate[]{qdoSub.empId.eq((Object)empId)})).and((Predicate)EmpGroupEmpRepoProc.QDO_GROUP.enabled.eq(Boolean.valueOf(true)))});
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)EmpGroupEmpRepoProc.QDO.empId).from((EntityPath)QDO)).where((Predicate)EmpGroupEmpRepoProc.QDO.groupId.in((SubQueryExpression)groupSubQuery))).fetch();
    }

    public List<Long> queryEmpUserIdOfSameGroup(long empId) {
        QSysEmpGroupEmpDO qdoSub = new QSysEmpGroupEmpDO("qdoSub");
        JPQLQuery groupSubQuery = (JPQLQuery)JPAExpressions.select((Expression)EmpGroupEmpRepoProc.QDO_GROUP.id).from(new EntityPath[]{QDO_GROUP}).where(new Predicate[]{EmpGroupEmpRepoProc.QDO_GROUP.id.in((SubQueryExpression)JPAExpressions.select((Expression)qdoSub.groupId).from(new EntityPath[]{qdoSub}).where(new Predicate[]{qdoSub.empId.eq((Object)empId)})).and((Predicate)EmpGroupEmpRepoProc.QDO_GROUP.enabled.eq(Boolean.valueOf(true)))});
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)EmpGroupEmpRepoProc.QDO_EMP.userId).from((EntityPath)QDO_EMP)).where((Predicate)EmpGroupEmpRepoProc.QDO_EMP.id.in((SubQueryExpression)JPAExpressions.select((Expression)EmpGroupEmpRepoProc.QDO.empId).from(new EntityPath[]{QDO}).where(new Predicate[]{EmpGroupEmpRepoProc.QDO.groupId.in((SubQueryExpression)groupSubQuery)})).and((Predicate)EmpGroupEmpRepoProc.QDO_EMP.userId.isNotNull()))).fetch().stream().distinct().collect(Collectors.toList());
    }

    protected String getUserFullName(String lastName, String firstName) {
        if (!StringUtils.hasText((String)lastName)) {
            return firstName;
        }
        return lastName + CharSequenceUtil.blankToDefault((CharSequence)firstName, (String)"");
    }
}

