/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformApiManageDO;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformMenusApiDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformApiManageDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusApiDO;
import com.elitescloud.cloudt.system.model.vo.resp.api.SysMenuApiRespVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformAppDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformMenusDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformMenusDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.springframework.stereotype.Repository;

@Repository
public class MenuApiRepoProc
extends BaseRepoProc<SysPlatformMenusApiDO> {
    private static final QSysPlatformMenusApiDO QDO = QSysPlatformMenusApiDO.sysPlatformMenusApiDO;
    private static final QSysPlatformApiManageDO QDO_API = QSysPlatformApiManageDO.sysPlatformApiManageDO;
    private static final QSysPlatformMenusDO QDO_MENU = QSysPlatformMenusDO.sysPlatformMenusDO;
    private static final QSysPlatformAppDO QDO_APP = QSysPlatformAppDO.sysPlatformAppDO;

    public MenuApiRepoProc() {
        super((EntityPathBase)QDO);
    }

    public Map<String, Long> queryNumOfApi(Collection<String> appCodes) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)MenuApiRepoProc.QDO.appCode, appCodes).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{MenuApiRepoProc.QDO.menusCode, MenuApiRepoProc.QDO.apiId}).from((EntityPath)QDO)).where(predicate)).fetch().stream().collect(Collectors.groupingBy(t -> (String)ObjectUtil.defaultIfNull((Object)((String)t.get((Expression)MenuApiRepoProc.QDO.menusCode)), (Object)"unknown"), Collectors.counting()));
    }

    public List<SysPlatformApiManageDO> queryApiOfMenu(@NotBlank String menuCode) {
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)QDO_API).where((Predicate)MenuApiRepoProc.QDO_API.id.in((SubQueryExpression)JPAExpressions.select((Expression)MenuApiRepoProc.QDO.apiId).from(new EntityPath[]{QDO}).where(new Predicate[]{MenuApiRepoProc.QDO.menusCode.eq((Object)menuCode)})))).fetch();
    }

    public Map<String, List<IdCodeNameParam>> queryApiOfMenu(Collection<String> appCodes) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{MenuApiRepoProc.QDO.menusCode, MenuApiRepoProc.QDO_API.id, MenuApiRepoProc.QDO_API.apiCode, MenuApiRepoProc.QDO_API.apiName}).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_API)).on((Predicate)MenuApiRepoProc.QDO.apiId.eq((Expression)MenuApiRepoProc.QDO_API.id))).where((Predicate)MenuApiRepoProc.QDO.appCode.in(appCodes))).fetch().stream().collect(Collectors.groupingBy(t -> (String)t.get((Expression)MenuApiRepoProc.QDO.menusCode), Collectors.mapping(t -> new IdCodeNameParam((Long)t.get((Expression)MenuApiRepoProc.QDO_API.id), (String)t.get((Expression)MenuApiRepoProc.QDO_API.apiCode), (String)t.get((Expression)MenuApiRepoProc.QDO_API.apiName)), Collectors.toList())));
    }

    public Map<String, List<SysMenuApiRespVO>> queryApiDetailOfMenu(Collection<String> appCodes) {
        QBean qBean = Projections.bean(SysMenuApiRespVO.class, (Expression[])new Expression[]{MenuApiRepoProc.QDO_API.id, MenuApiRepoProc.QDO_API.appCode, MenuApiRepoProc.QDO_API.apiName.as("name"), MenuApiRepoProc.QDO_API.apiCode.as("code"), MenuApiRepoProc.QDO_API.requestType, MenuApiRepoProc.QDO_API.apiPath, MenuApiRepoProc.QDO_API.apiDescribe, MenuApiRepoProc.QDO_APP.appName, MenuApiRepoProc.QDO.menusCode});
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBean).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_API)).on((Predicate)MenuApiRepoProc.QDO_API.id.eq((Expression)MenuApiRepoProc.QDO.apiId))).leftJoin((EntityPath)QDO_APP)).on((Predicate)MenuApiRepoProc.QDO_API.appCode.eq((Expression)MenuApiRepoProc.QDO_APP.appCode))).where((Predicate)MenuApiRepoProc.QDO_API.appCode.in(appCodes))).fetch().stream().collect(Collectors.groupingBy(SysMenuApiRespVO::getMenusCode));
    }

    public List<Long> getMenuIdByApiId(long apiId, String appCode) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)MenuApiRepoProc.QDO.apiId, (Object)apiId).andEq((SimpleExpression)MenuApiRepoProc.QDO.appCode, (Object)appCode).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)MenuApiRepoProc.QDO.menusId).from((EntityPath)QDO)).where(predicate)).fetch();
    }

    public List<SysPlatformMenusDO> getMenuDetailByApiId(long apiId, String appCode) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)MenuApiRepoProc.QDO.apiId, (Object)apiId).andEq((SimpleExpression)MenuApiRepoProc.QDO.appCode, (Object)appCode).build();
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)QDO_MENU).where((Predicate)MenuApiRepoProc.QDO_MENU.menusCode.in((SubQueryExpression)JPAExpressions.select((Expression)MenuApiRepoProc.QDO.menusCode).from(new EntityPath[]{QDO}).where(new Predicate[]{predicate})))).fetch();
    }
}

