/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.entity.QSysMqRetryDO;
import com.elitescloud.cloudt.system.model.entity.SysMqRetryDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class MqMessageRetryRepoProc
extends BaseRepoProc<SysMqRetryDO> {
    private static final QSysMqRetryDO QDO = QSysMqRetryDO.sysMqRetryDO;

    public MqMessageRetryRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void deleteExpiredMessage(LocalDateTime expiredTime) {
        super.delete((Predicate)MqMessageRetryRepoProc.QDO.createTime.before((Comparable)expiredTime));
    }

    public void deleteRetryByMessageId(@NotBlank String messageId, Boolean consumer) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)MqMessageRetryRepoProc.QDO.messageId, (Object)messageId).andEq((SimpleExpression)MqMessageRetryRepoProc.QDO.consumer, (Object)consumer).build();
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{predicate}).execute();
    }

    public void deleteRetryByMessageId(@NotBlank String messageId) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)MqMessageRetryRepoProc.QDO.messageId, (Object)messageId).build();
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{predicate}).execute();
    }

    public SysMqRetryDO getByMessageId(@NotBlank String messageId, Boolean consumer) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)MqMessageRetryRepoProc.QDO.messageId, (Object)messageId).andEq((SimpleExpression)MqMessageRetryRepoProc.QDO.consumer, (Object)consumer).build();
        return (SysMqRetryDO)((Object)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)QDO).where(predicate)).limit(1L)).fetchOne());
    }

    public Integer getVersionByMessageId(@NotBlank String messageId) {
        return (Integer)super.getValueByValue(MqMessageRetryRepoProc.QDO.auditDataVersion, (Path)MqMessageRetryRepoProc.QDO.messageId, (Object)messageId);
    }

    public List<SysMqRetryDO> queryRetry(String lastMessageId, int size) {
        QSysMqRetryDO qdoSub = new QSysMqRetryDO("sub");
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)QDO).where(StringUtils.hasText((String)lastMessageId) ? MqMessageRetryRepoProc.QDO.sendTimeNext.after((Expression)JPAExpressions.select(qdoSub.sendTimeNext).from(new EntityPath[]{qdoSub}).where(new Predicate[]{qdoSub.messageId.eq((Object)lastMessageId)})) : null)).orderBy(MqMessageRetryRepoProc.QDO.sendTimeNext.asc())).limit((long)size)).fetch();
    }
}

