/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonPublishedNoticePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.NoticePageMngQueryVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysNoticeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysNoticeDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.ComparableExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.TemporalExpression;
import java.time.LocalDateTime;
import java.util.Collection;
import javax.validation.constraints.NotEmpty;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class NoticeRepoProc
extends BaseRepoProc<SysNoticeDO> {
    private static final QSysNoticeDO QDO = QSysNoticeDO.sysNoticeDO;

    public NoticeRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateTxtId(long id, long txtId) {
        super.updateValue((Path)NoticeRepoProc.QDO.txtId, (Object)txtId, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePublish(@NotEmpty Collection<Long> ids, LocalDateTime publishTime) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)NoticeRepoProc.QDO.published, (Object)true).set((Path)NoticeRepoProc.QDO.publishTime, (Object)publishTime).where(new Predicate[]{NoticeRepoProc.QDO.id.in(ids).and((Predicate)NoticeRepoProc.QDO.published.eq(Boolean.valueOf(false))).and((Predicate)NoticeRepoProc.QDO.publishTime.isNull())}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePublish(@NotEmpty Collection<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)NoticeRepoProc.QDO.published, (Object)true).where(new Predicate[]{NoticeRepoProc.QDO.id.in(ids).and((Predicate)NoticeRepoProc.QDO.published.eq(Boolean.valueOf(false))).and((Predicate)NoticeRepoProc.QDO.publishTime.isNotNull())}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateRevoke(@NotEmpty Collection<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)NoticeRepoProc.QDO.published, (Object)false).setNull((Path)NoticeRepoProc.QDO.publishTime).where(new Predicate[]{NoticeRepoProc.QDO.id.in(ids).and((Predicate)NoticeRepoProc.QDO.published.eq(Boolean.valueOf(true)))}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void increaseNum(long id) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)NoticeRepoProc.QDO.readAmount, (Expression)NoticeRepoProc.QDO.readAmount.add((Number)1)).where(new Predicate[]{NoticeRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public PagingVO<SysNoticeDO> pageMng(NoticePageMngQueryVO queryVO, boolean sys) {
        Predicate predate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)NoticeRepoProc.QDO.authorId, (Object)queryVO.getAuthorId()).andLike((StringExpression)NoticeRepoProc.QDO.title, queryVO.getTitle()).andEq((SimpleExpression)NoticeRepoProc.QDO.category, (Object)queryVO.getCategory()).andEq((SimpleExpression)NoticeRepoProc.QDO.noticeType, (Object)queryVO.getNoticeType()).andEq((SimpleExpression)NoticeRepoProc.QDO.top, (Object)queryVO.getTop()).andEq((SimpleExpression)NoticeRepoProc.QDO.published, (Object)queryVO.getPublished()).andEq((SimpleExpression)NoticeRepoProc.QDO.sys, (Object)sys).andBetween((TemporalExpression)NoticeRepoProc.QDO.publishTime, (Comparable)queryVO.getPublishTimeStart(), (Comparable)queryVO.getPublishTimeEnd()).andLike(new StringExpression[]{NoticeRepoProc.QDO.title, NoticeRepoProc.QDO.summaries}, queryVO.getKeyword()).build();
        return super.queryByPage(predate, queryVO.getPageRequest(), NoticeRepoProc.QDO.createTime.desc());
    }

    public PagingVO<SysNoticeDO> pagePublished(CommonPublishedNoticePageQueryVO queryVO) {
        Predicate predate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)NoticeRepoProc.QDO.category, (Object)queryVO.getCategory()).andEq((SimpleExpression)NoticeRepoProc.QDO.noticeType, (Object)queryVO.getNoticeType()).andLoe((ComparableExpression)NoticeRepoProc.QDO.publishTime, (Comparable)LocalDateTime.now()).andEq((SimpleExpression)NoticeRepoProc.QDO.published, (Object)true).andEq((SimpleExpression)NoticeRepoProc.QDO.sys, (Object)queryVO.getSys()).andLike((StringExpression)NoticeRepoProc.QDO.title, queryVO.getTitle()).andLike(new StringExpression[]{NoticeRepoProc.QDO.title, NoticeRepoProc.QDO.summaries}, queryVO.getKeyword()).build();
        PageRequest pageRequest = queryVO.getPageRequest();
        pageRequest = pageRequest.withSort(Sort.Direction.DESC, new String[]{NoticeRepoProc.QDO.top.getMetadata().getName(), NoticeRepoProc.QDO.publishTime.getMetadata().getName()});
        return super.queryByPage(predate, pageRequest);
    }
}

