/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.sys.OpenApiOperationPageQueryVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysOpenApiOperationDO;
import com.elitescloud.cloudt.system.service.model.entity.SysOpenApiOperationDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class OpenApiOperationRepoProc
extends BaseRepoProc<SysOpenApiOperationDO> {
    private static final Logger log = LoggerFactory.getLogger(OpenApiOperationRepoProc.class);
    private static final QSysOpenApiOperationDO QDO = QSysOpenApiOperationDO.sysOpenApiOperationDO;

    public OpenApiOperationRepoProc() {
        super((EntityPathBase)QDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByOpenApiId(long openId) {
        super.delete((Predicate)OpenApiOperationRepoProc.QDO.openApiInfoId.eq((Object)openId));
    }

    public Map<Long, Long> countByOpenApiId(Collection<Long> openApiIds) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{OpenApiOperationRepoProc.QDO.openApiInfoId, OpenApiOperationRepoProc.QDO.openApiInfoId.count()}).from((EntityPath)QDO)).where((Predicate)OpenApiOperationRepoProc.QDO.openApiInfoId.in(openApiIds))).groupBy((Expression)OpenApiOperationRepoProc.QDO.openApiInfoId)).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get((Expression)OpenApiOperationRepoProc.QDO.openApiInfoId), t -> (Long)t.get((Expression)OpenApiOperationRepoProc.QDO.openApiInfoId.count()), (t1, t2) -> t1));
    }

    public Map<Long, Long> countByFeignOpenApiId(Collection<Long> openApiIds) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{OpenApiOperationRepoProc.QDO.openApiInfoId, OpenApiOperationRepoProc.QDO.openApiInfoId.count()}).from((EntityPath)QDO)).where((Predicate)OpenApiOperationRepoProc.QDO.openApiInfoId.in(openApiIds).and((Predicate)OpenApiOperationRepoProc.QDO.apiType.eq((Object)2)))).groupBy((Expression)OpenApiOperationRepoProc.QDO.openApiInfoId)).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get((Expression)OpenApiOperationRepoProc.QDO.openApiInfoId), t -> (Long)t.get((Expression)OpenApiOperationRepoProc.QDO.openApiInfoId.count()), (t1, t2) -> t1));
    }

    public PagingVO<SysOpenApiOperationDO> pageMng(OpenApiOperationPageQueryVO queryVO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)OpenApiOperationRepoProc.QDO.openApiInfoId, (Object)queryVO.getOpenApiId()).andLike((StringExpression)OpenApiOperationRepoProc.QDO.summary, queryVO.getSummary()).andLike((StringExpression)OpenApiOperationRepoProc.QDO.description, queryVO.getDescription()).andLike((StringExpression)OpenApiOperationRepoProc.QDO.url, queryVO.getUrl()).andLike((StringExpression)OpenApiOperationRepoProc.QDO.operationGroup, queryVO.getOperationGroup()).andEq((SimpleExpression)OpenApiOperationRepoProc.QDO.apiType, (Object)queryVO.getApiType()).andEq((SimpleExpression)OpenApiOperationRepoProc.QDO.businessOperation, (Object)queryVO.getBusinessOperation()).build();
        return super.queryByPage(predicate, queryVO.getPageRequest());
    }

    public List<String> selectDistinctOperationGroupByApiType() {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)OpenApiOperationRepoProc.QDO.apiType, (Object)2).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)OpenApiOperationRepoProc.QDO.operationGroup).from((EntityPath)QDO)).where(predicate)).fetchAll()).fetch();
    }

    public List<SysOpenApiOperationDO> listByOpenApiId(long openApiId) {
        return super.getList((Predicate)OpenApiOperationRepoProc.QDO.openApiInfoId.eq((Object)openApiId), new OrderSpecifier[0]);
    }
}

