/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.bo.PermissionBO;
import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import com.elitescloud.cloudt.system.service.model.entity.QSysRoleDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysRolePermissionDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantMenuTreeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysRolePermissionDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantMenuTreeDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class RolePermissionRepoProc
extends BaseRepoProc<SysRolePermissionDO> {
    private static final QSysRolePermissionDO QDO = QSysRolePermissionDO.sysRolePermissionDO;
    private static final QSysRoleDO QDO_ROLE = QSysRoleDO.sysRoleDO;
    private static final QSysTenantMenuTreeDO QDO_TENANT_MENU_TREE = QSysTenantMenuTreeDO.sysTenantMenuTreeDO;

    public RolePermissionRepoProc() {
        super((EntityPathBase)QDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByRole(long roleId) {
        super.deleteByValue((Path)RolePermissionRepoProc.QDO.roleId, (Object)roleId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByRole(@NotEmpty Collection<Long> roleIds, String appCode) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)RolePermissionRepoProc.QDO.roleId.in(roleIds), (Object[])new Boolean[0]).andEq((SimpleExpression)RolePermissionRepoProc.QDO.appCode, (Object)appCode).build();
        super.delete(predicate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByRole(long roleId, @NotBlank String appCode, @NotEmpty Collection<String> permissionType, boolean custom) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{RolePermissionRepoProc.QDO.roleId.eq((Object)roleId).and((Predicate)RolePermissionRepoProc.QDO.appCode.eq((Object)appCode)).and((Predicate)RolePermissionRepoProc.QDO.permissionType.in(permissionType)).and(this.predicateOfCustom(custom, QDO))}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByRole(long roleId, String appCode, String permissionType, Collection<String> permissionCodes, Boolean custom) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)RolePermissionRepoProc.QDO.permissionCode, permissionCodes).andEq((SimpleExpression)RolePermissionRepoProc.QDO.permissionType, (Object)permissionType).andEq((SimpleExpression)RolePermissionRepoProc.QDO.appCode, (Object)appCode).andEq((SimpleExpression)RolePermissionRepoProc.QDO.roleId, (Object)roleId).and(this.predicateOfCustom(custom, QDO)).build();
        super.delete(predicate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByRoleBatch(Collection<Long> roleIds, String appCode, String permissionType, Collection<String> permissionCodes, Boolean custom) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)RolePermissionRepoProc.QDO.permissionCode, permissionCodes).andEq((SimpleExpression)RolePermissionRepoProc.QDO.permissionType, (Object)permissionType).andEq((SimpleExpression)RolePermissionRepoProc.QDO.appCode, (Object)appCode).and((Predicate)RolePermissionRepoProc.QDO.roleId.in(roleIds)).and(this.predicateOfCustom(custom, QDO)).build();
        super.delete(predicate);
    }

    public List<SysRolePermissionDO> listByRole(long roleId) {
        return super.getListByValue((Path)RolePermissionRepoProc.QDO.roleId, (Object)roleId, new OrderSpecifier[0]);
    }

    public List<SysRolePermissionDO> listByRoles(@NotEmpty Collection<Long> roleIds, String appCode) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)RolePermissionRepoProc.QDO.roleId, roleIds).andEq((SimpleExpression)RolePermissionRepoProc.QDO.appCode, (Object)appCode).build();
        return super.getList(predicate, new OrderSpecifier[0]);
    }

    public List<String> getCodeByRole(long roleId, Collection<String> appCodes, Collection<String> permissionType) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)RolePermissionRepoProc.QDO.roleId, (Object)roleId).andIn((SimpleExpression)RolePermissionRepoProc.QDO.appCode, appCodes).andIn((SimpleExpression)RolePermissionRepoProc.QDO.permissionType, permissionType).build();
        return super.getValueList((Path)RolePermissionRepoProc.QDO.permissionCode, predicate, new OrderSpecifier[0]);
    }

    public List<PermissionBO> getPermissionByRole(long roleId, String appCode, Collection<String> permissionType, Boolean custom) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)RolePermissionRepoProc.QDO.roleId, (Object)roleId).andEq((SimpleExpression)RolePermissionRepoProc.QDO.appCode, (Object)appCode).andIn((SimpleExpression)RolePermissionRepoProc.QDO.permissionType, permissionType).and(this.predicateOfCustom(custom, QDO)).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PermissionBO.class, (Expression[])new Expression[]{RolePermissionRepoProc.QDO.roleId, RolePermissionRepoProc.QDO.appCode, RolePermissionRepoProc.QDO.permissionCode, RolePermissionRepoProc.QDO.permissionType})).from((EntityPath)QDO)).where(predicate)).fetch();
    }

    public List<PermissionBO> getPermissionByRole(@NotEmpty Collection<Long> roleIds, String appCode, Collection<String> permissionType, Boolean custom) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().and((Predicate)RolePermissionRepoProc.QDO.roleId.in(roleIds)).andEq((SimpleExpression)RolePermissionRepoProc.QDO.appCode, (Object)appCode).andIn((SimpleExpression)RolePermissionRepoProc.QDO.permissionType, permissionType).andEq((SimpleExpression)RolePermissionRepoProc.QDO.custom, (Object)custom).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PermissionBO.class, (Expression[])new Expression[]{RolePermissionRepoProc.QDO.roleId, RolePermissionRepoProc.QDO.appCode, RolePermissionRepoProc.QDO.permissionCode, RolePermissionRepoProc.QDO.permissionType})).from((EntityPath)QDO)).where(predicate)).fetch();
    }

    public List<PermissionBO> queryPermissionByRole(Collection<String> roleCodes, Collection<String> permissionType, Boolean custom) {
        JPQLQuery roleIdsQuery = (JPQLQuery)JPAExpressions.select((Expression)RolePermissionRepoProc.QDO_ROLE.id).from(new EntityPath[]{QDO_ROLE}).where(new Predicate[]{RolePermissionRepoProc.QDO_ROLE.code.in(roleCodes).and((Predicate)RolePermissionRepoProc.QDO_ROLE.enabled.eq(Boolean.valueOf(true)))});
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn(true, (SimpleExpression)RolePermissionRepoProc.QDO.roleId, (SubQueryExpression)roleIdsQuery).andIn((SimpleExpression)RolePermissionRepoProc.QDO.permissionType, permissionType).and(this.predicateOfCustom(custom, QDO)).build();
        return super.getList(this.qBeanPermissionBO(), predicate, new OrderSpecifier[0]);
    }

    public List<SysTenantMenuTreeDO> queryMenuForCustom(Collection<String> roleCodes, Collection<String> permissionType) {
        JPQLQuery roleIdsQuery = (JPQLQuery)JPAExpressions.select((Expression)RolePermissionRepoProc.QDO_ROLE.id).from(new EntityPath[]{QDO_ROLE}).where(new Predicate[]{RolePermissionRepoProc.QDO_ROLE.code.in(roleCodes).and((Predicate)RolePermissionRepoProc.QDO_ROLE.enabled.eq(Boolean.valueOf(true)))});
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO_TENANT_MENU_TREE).from((EntityPath)QDO_TENANT_MENU_TREE)).leftJoin((EntityPath)QDO)).on((Predicate)RolePermissionRepoProc.QDO.permissionCode.eq((Expression)RolePermissionRepoProc.QDO_TENANT_MENU_TREE.menuCode))).where((Predicate)RolePermissionRepoProc.QDO.roleId.in((SubQueryExpression)roleIdsQuery).and((Predicate)RolePermissionRepoProc.QDO.permissionType.in(permissionType)).and((Predicate)RolePermissionRepoProc.QDO.custom.eq(Boolean.valueOf(true))))).fetch();
    }

    public Map<String, Set<Long>> queryPermissionCodeAndRolesByRoles(@NotEmpty Collection<Long> roleIds, boolean includeMenu, boolean includeAction) {
        HashSet<String> permissionTypes = new HashSet<String>(4);
        if (includeMenu) {
            permissionTypes.add(MenuTreeNodeType.MENU.getValue());
        }
        if (includeAction) {
            permissionTypes.add(MenuTreeNodeType.ACTION.getValue());
        }
        if (permissionTypes.isEmpty()) {
            return Collections.emptyMap();
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)RolePermissionRepoProc.QDO.roleId, roleIds).andIn((SimpleExpression)RolePermissionRepoProc.QDO.permissionType, permissionTypes).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{RolePermissionRepoProc.QDO.permissionCode, RolePermissionRepoProc.QDO.roleId}).from((EntityPath)QDO)).where(predicate)).fetch().stream().collect(Collectors.groupingBy(t -> (String)t.get((Expression)RolePermissionRepoProc.QDO.permissionCode), Collectors.mapping(t -> (Long)t.get((Expression)RolePermissionRepoProc.QDO.roleId), Collectors.toSet())));
    }

    public List<String> queryPermissionCodesByRoles(@NotEmpty Collection<Long> roleIds, boolean includeMenu, boolean includeAction) {
        HashSet<String> permissionTypes = new HashSet<String>(4);
        if (includeMenu) {
            permissionTypes.add(MenuTreeNodeType.MENU.getValue());
        }
        if (includeAction) {
            permissionTypes.add(MenuTreeNodeType.ACTION.getValue());
        }
        if (permissionTypes.isEmpty()) {
            return Collections.emptyList();
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)RolePermissionRepoProc.QDO.roleId, roleIds).andIn((SimpleExpression)RolePermissionRepoProc.QDO.permissionType, permissionTypes).build();
        return super.getValueList((Path)RolePermissionRepoProc.QDO.permissionCode, predicate, new OrderSpecifier[0]);
    }

    public Set<String> queryPermissionCodeByRoles(Collection<String> roleCodes, Collection<String> permissionType, boolean custom) {
        return this.queryPermissionCodeByRoles(roleCodes, permissionType, null, custom);
    }

    public Set<String> queryPermissionCodeByRoles(Collection<String> roleCodes, Collection<String> permissionType, Collection<String> permissionCodes, boolean custom) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().and(CollUtil.isNotEmpty(roleCodes), () -> RolePermissionRepoProc.QDO.roleId.in((SubQueryExpression)JPAExpressions.select((Expression)RolePermissionRepoProc.QDO_ROLE.id).from(new EntityPath[]{QDO_ROLE}).where(new Predicate[]{RolePermissionRepoProc.QDO_ROLE.code.in(roleCodes).and((Predicate)RolePermissionRepoProc.QDO_ROLE.enabled.eq(Boolean.valueOf(true)))}))).andIn(CollUtil.isNotEmpty(permissionCodes), (SimpleExpression)RolePermissionRepoProc.QDO.permissionCode, permissionCodes).andIn(CollUtil.isNotEmpty(permissionType), (SimpleExpression)RolePermissionRepoProc.QDO.permissionType, permissionType).and(this.predicateOfCustom(custom, QDO)).build();
        return new HashSet<String>(((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)RolePermissionRepoProc.QDO.permissionCode).from((EntityPath)QDO)).where(predicate)).fetch());
    }

    public Map<String, Set<String>> queryRoleCodeForApi(boolean custom) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{RolePermissionRepoProc.QDO.permissionCode, RolePermissionRepoProc.QDO_ROLE.code}).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_ROLE)).on((Predicate)RolePermissionRepoProc.QDO_ROLE.id.eq((Expression)RolePermissionRepoProc.QDO.roleId))).where((Predicate)RolePermissionRepoProc.QDO.permissionType.eq((Object)MenuTreeNodeType.API.getValue()).and(this.predicateOfCustom(custom, QDO)).and((Predicate)RolePermissionRepoProc.QDO_ROLE.enabled.eq(Boolean.valueOf(true))))).fetch().stream().collect(Collectors.groupingBy(t -> (String)t.get((Expression)RolePermissionRepoProc.QDO.permissionCode), Collectors.collectingAndThen(Collectors.toList(), t -> t.stream().map(tt -> (String)tt.get((Expression)RolePermissionRepoProc.QDO_ROLE.code)).collect(Collectors.toSet()))));
    }

    private Predicate predicateOfCustom(Boolean custom, QSysRolePermissionDO qModel) {
        if (custom == null) {
            return null;
        }
        return custom != false ? qModel.custom.eq(Boolean.valueOf(true)) : qModel.custom.eq(Boolean.valueOf(false)).or((Predicate)qModel.custom.isNull());
    }

    private QBean<PermissionBO> qBeanPermissionBO() {
        return Projections.bean(PermissionBO.class, (Expression[])new Expression[]{RolePermissionRepoProc.QDO.appCode, RolePermissionRepoProc.QDO.permissionCode, RolePermissionRepoProc.QDO.permissionType});
    }
}

