/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.entity.QSysPositionDO;
import com.elitescloud.cloudt.system.model.entity.QSysPositionOrgDO;
import com.elitescloud.cloudt.system.model.entity.SysPositionDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysOrgDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;

@Repository
public class SysPositionRepoProc
extends BaseRepoProc<SysPositionDO> {
    private static final QSysPositionDO QDO = QSysPositionDO.sysPositionDO;
    private static final QSysPositionOrgDO QDO_POST_ORG = QSysPositionOrgDO.sysPositionOrgDO;
    private static final QSysOrgDO QDO_ORG = QSysOrgDO.sysOrgDO;

    public SysPositionRepoProc() {
        super((EntityPathBase)QDO);
    }

    public List<IdCodeNameParam> queryCodeNames(String orgCode, Long orgId, Integer size, String postName) {
        BaseRepoProc.PredicateBuilder predicateBuilder = BaseRepoProc.PredicateBuilder.builder();
        if (orgId != null) {
            predicateBuilder.andIn((SimpleExpression)SysPositionRepoProc.QDO.positionCode, (SubQueryExpression)JPAExpressions.select((Expression)SysPositionRepoProc.QDO_POST_ORG.positionCode).from(new EntityPath[]{QDO_POST_ORG}).where(new Predicate[]{SysPositionRepoProc.QDO_POST_ORG.orgCode.eq((Expression)JPAExpressions.select((Expression)SysPositionRepoProc.QDO_ORG.code).from(new EntityPath[]{QDO_ORG}).where(new Predicate[]{SysPositionRepoProc.QDO_ORG.id.eq((Object)orgId)}))}));
        } else if (CharSequenceUtil.isNotBlank((CharSequence)orgCode)) {
            predicateBuilder.andIn((SimpleExpression)SysPositionRepoProc.QDO.positionCode, (SubQueryExpression)JPAExpressions.select((Expression)SysPositionRepoProc.QDO_POST_ORG.positionCode).from(new EntityPath[]{QDO_POST_ORG}).where(new Predicate[]{SysPositionRepoProc.QDO_POST_ORG.orgCode.eq((Object)orgCode)}));
        }
        predicateBuilder.andLike((StringExpression)SysPositionRepoProc.QDO.positionName, postName);
        QBean qBean = Projections.bean(IdCodeNameParam.class, (Expression[])new Expression[]{SysPositionRepoProc.QDO.id, SysPositionRepoProc.QDO.positionCode.as("code"), SysPositionRepoProc.QDO.positionName.as("name")});
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBean).from((EntityPath)QDO)).where(predicateBuilder.build());
        if (size != null) {
            jpaQuery.limit((long)size.intValue());
        }
        return jpaQuery.fetch();
    }

    public List<IdCodeNameParam> queryIdCodeNamesByCodes(@NotEmpty Collection<String> positionCodes) {
        QBean qBean = Projections.bean(IdCodeNameParam.class, (Expression[])new Expression[]{SysPositionRepoProc.QDO.id, SysPositionRepoProc.QDO.positionCode.as("code"), SysPositionRepoProc.QDO.positionName.as("name")});
        return super.getList(qBean, (Predicate)SysPositionRepoProc.QDO.positionCode.in(positionCodes), new OrderSpecifier[0]);
    }
}

