/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.entity.QSysVersionDO;
import com.elitescloud.cloudt.system.model.entity.SysVersionDO;
import com.elitescloud.cloudt.system.model.vo.query.version.SysVersionPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.version.SysVersionRespVO;
import com.elitescloud.cloudt.system.service.repo.SysVersionRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SysVersionRepoProc
extends BaseRepoProc<SysVersionDO> {
    private static final QSysVersionDO QDO = QSysVersionDO.sysVersionDO;
    @Autowired
    private SysVersionRepo sysVersionRepo;

    public SysVersionRepoProc() {
        super((EntityPathBase)QDO);
    }

    public QBean<SysVersionRespVO> sysVersionBean() {
        return Projections.bean(SysVersionRespVO.class, (Expression[])new Expression[]{SysVersionRepoProc.QDO.id, SysVersionRepoProc.QDO.versionNo, SysVersionRepoProc.QDO.describeMsg, SysVersionRepoProc.QDO.changeContent, SysVersionRepoProc.QDO.status, SysVersionRepoProc.QDO.createTime});
    }

    public String getActiveVersion() {
        return (String)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SysVersionRepoProc.QDO.versionNo).from((EntityPath)QDO)).where((Predicate)SysVersionRepoProc.QDO.status.eq(Boolean.TRUE))).orderBy(SysVersionRepoProc.QDO.createTime.desc())).limit(1L)).fetchOne();
    }

    public List<String> queryVersionList() {
        return super.getValueList((Path)SysVersionRepoProc.QDO.versionNo, new OrderSpecifier[0]);
    }

    public SysVersionRespVO getActiveVersionDetail() {
        BooleanExpression predicate = SysVersionRepoProc.QDO.status.eq(Boolean.TRUE);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.sysVersionBean()).from((EntityPath)QDO)).where((Predicate)predicate);
        return (SysVersionRespVO)jpaQuery.fetchOne();
    }

    public PagingVO<SysVersionRespVO> page(SysVersionPageQueryVO query) {
        Predicate predicate = this.pageWhere(query);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.sysVersionBean()).from((EntityPath)QDO)).where(predicate);
        return super.queryByPage(jpaQuery, query.getPageRequest(), SysVersionRepoProc.QDO.createTime.desc());
    }

    public Predicate pageWhere(SysVersionPageQueryVO query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)query.getVersionNo())) {
            list.add(SysVersionRepoProc.QDO.versionNo.contains(query.getVersionNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getDescribeMsg())) {
            list.add(SysVersionRepoProc.QDO.describeMsg.contains(query.getDescribeMsg()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getChangeContent())) {
            list.add(SysVersionRepoProc.QDO.changeContent.contains(query.getChangeContent()));
        }
        if (ObjectUtils.isNotEmpty((Object)query.getStatus())) {
            list.add(SysVersionRepoProc.QDO.status.eq(query.getStatus()));
        }
        return ExpressionUtils.allOf(list);
    }

    public Long getStatusCount(Long id, Boolean status) {
        BooleanExpression e = SysVersionRepoProc.QDO.status.eq(status);
        if (ObjectUtils.isNotEmpty((Object)id)) {
            e = e.and((Predicate)SysVersionRepoProc.QDO.id.ne((Object)id));
        }
        return this.sysVersionRepo.count((Predicate)e);
    }

    public Long getVersionNoCount(Long id, String versionNo) {
        BooleanExpression e = SysVersionRepoProc.QDO.versionNo.eq((Object)versionNo);
        if (ObjectUtils.isNotEmpty((Object)id)) {
            e = e.and((Predicate)SysVersionRepoProc.QDO.id.ne((Object)id));
        }
        return this.sysVersionRepo.count((Predicate)e);
    }

    @Transactional(rollbackFor={Exception.class})
    public SysVersionDO saveVersion(SysVersionDO sysVersionDO) {
        return (SysVersionDO)((Object)this.sysVersionRepo.save((Object)sysVersionDO));
    }

    @Transactional(rollbackFor={Exception.class})
    public void del(Long id) {
        this.sysVersionRepo.deleteById(id);
    }

    public SysVersionDO getById(Long id) {
        Optional optional = this.sysVersionRepo.findById(id);
        return (SysVersionDO)((Object)optional.get());
    }
}

