/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.SysTaxRateQueryDTO;
import com.elitescloud.cloudt.system.model.vo.query.extend.TaxRatePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonTaxRateRespVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysTaxRateDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTaxRateDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.TemporalExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class TaxRateRepoProc
extends BaseRepoProc<SysTaxRateDO> {
    private static final QSysTaxRateDO QDO = QSysTaxRateDO.sysTaxRateDO;

    public TaxRateRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateEnabled(long id, Boolean enabled) {
        super.updateValue((Path)TaxRateRepoProc.QDO.enabled, (Object)enabled, id);
    }

    public boolean existsRateNo(String rateNo, Long id) {
        return super.exists((Path)TaxRateRepoProc.QDO.taxRateNo, (Object)rateNo, id);
    }

    public Boolean getEnabled(long id) {
        return (Boolean)super.getValue((Path)TaxRateRepoProc.QDO.enabled, id);
    }

    public SysTaxRateDO getByTaxRateNo(@NotBlank String taxRateNo, String taxRateType) {
        BooleanExpression predicate = TaxRateRepoProc.QDO.taxRateNo.eq((Object)taxRateNo);
        if (CharSequenceUtil.isNotBlank((CharSequence)taxRateType)) {
            predicate = predicate.and((Predicate)TaxRateRepoProc.QDO.taxRateType.eq((Object)taxRateType).or((Predicate)TaxRateRepoProc.QDO.taxRateType.isNull()));
        }
        return (SysTaxRateDO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)QDO).where((Predicate)predicate)).limit(1L)).fetchOne();
    }

    public PagingVO<SysTaxRateDO> pageMng(TaxRatePageQueryVO queryVO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)TaxRateRepoProc.QDO.taxRateType, (Object)queryVO.getTaxRateType()).andLike(StringUtils.hasText((String)queryVO.getTaxRateNo()), (StringExpression)TaxRateRepoProc.QDO.taxRateNo, queryVO.getTaxRateNo()).andLike(StringUtils.hasText((String)queryVO.getTaxRateDesc()), (StringExpression)TaxRateRepoProc.QDO.taxRateDesc, queryVO.getTaxRateDesc()).andEq(queryVO.getEnabled() != null, (SimpleExpression)TaxRateRepoProc.QDO.enabled, (Object)queryVO.getEnabled()).andAfter(queryVO.getValidFromS() != null, (TemporalExpression)TaxRateRepoProc.QDO.validFrom, (Comparable)queryVO.getValidFromS()).andBefore(queryVO.getValidFromE() != null, (TemporalExpression)TaxRateRepoProc.QDO.validFrom, (Comparable)queryVO.getValidFromE()).andAfter(queryVO.getValidToS() != null, (TemporalExpression)TaxRateRepoProc.QDO.validTo, (Comparable)queryVO.getValidToS()).andBefore(queryVO.getValidToE() != null, (TemporalExpression)TaxRateRepoProc.QDO.validTo, (Comparable)queryVO.getValidToE()).build();
        return super.queryByPage(predicate, queryVO.getPageRequest(), TaxRateRepoProc.QDO.createTime.desc());
    }

    public List<CommonTaxRateRespVO> queryList(String taxRateNo, String taxRateType) {
        LocalDateTime now = LocalDateTime.now();
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)TaxRateRepoProc.QDO.taxRateNo, (Object)taxRateNo).andEq((SimpleExpression)TaxRateRepoProc.QDO.taxRateType, (Object)taxRateType).and(true, () -> TaxRateRepoProc.QDO.validFrom.loe((Comparable)now)).and(true, () -> TaxRateRepoProc.QDO.validTo.goe((Comparable)now)).andEq((SimpleExpression)TaxRateRepoProc.QDO.enabled, (Object)true).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CommonTaxRateRespVO.class, (Expression[])new Expression[]{TaxRateRepoProc.QDO.taxRateNo, TaxRateRepoProc.QDO.taxRateType, TaxRateRepoProc.QDO.taxRateValue, TaxRateRepoProc.QDO.taxRateDesc})).from((EntityPath)QDO)).where(predicate)).fetch();
    }

    public List<SysTaxRateDO> queryList(SysTaxRateQueryDTO queryDTO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().and(StringUtils.hasText((String)queryDTO.getTaxRateType()), () -> TaxRateRepoProc.QDO.taxRateType.eq((Object)queryDTO.getTaxRateType()).or((Predicate)TaxRateRepoProc.QDO.taxRateType.isNull())).andIn((SimpleExpression)TaxRateRepoProc.QDO.taxRateNo, (Collection)queryDTO.getTaxRateNos()).andIn((SimpleExpression)TaxRateRepoProc.QDO.taxRateValue, (Collection)queryDTO.getTaxRates()).build();
        return super.getList(predicate, new OrderSpecifier[0]);
    }
}

