/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.ThirdApiLogQueryDTO;
import com.elitescloud.cloudt.system.model.entity.QSysThirdApiLogDO;
import com.elitescloud.cloudt.system.model.entity.SysThirdApiLogDO;
import com.elitescloud.cloudt.system.model.vo.query.extend.ThirdApiLogQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiLogAggPageRespVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Repository;

@Repository
public class ThirdApiLogRepoProc
extends BaseRepoProc<SysThirdApiLogDO> {
    private static final QSysThirdApiLogDO QDO = QSysThirdApiLogDO.sysThirdApiLogDO;

    public ThirdApiLogRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateLastRetryLogId(long id, long lastRetryLogId) {
        super.updateValue(ThirdApiLogRepoProc.QDO.lastRetryId, (Object)lastRetryLogId, id);
    }

    public void updateReqResult(long id, boolean success, String failReason) {
        Long retryTimes = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)ThirdApiLogRepoProc.QDO.id.count()).from((EntityPath)QDO)).where((Predicate)ThirdApiLogRepoProc.QDO.originalId.eq((Object)id))).fetchOne();
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)ThirdApiLogRepoProc.QDO.reqSuccess, (Object)success).set((Path)ThirdApiLogRepoProc.QDO.retryFailReason, (Object)failReason).set(ThirdApiLogRepoProc.QDO.respTime, (Object)LocalDateTime.now()).set(ThirdApiLogRepoProc.QDO.retryTimes, (Object)((Long)ObjectUtil.defaultIfNull((Object)retryTimes, (Object)0L)).intValue()).where(new Predicate[]{ThirdApiLogRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public void updateRetryTimes(long id) {
        Long retryTimes = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)ThirdApiLogRepoProc.QDO.id.count()).from((EntityPath)QDO)).where((Predicate)ThirdApiLogRepoProc.QDO.originalId.eq((Object)id))).fetchOne();
        this.jpaQueryFactory.update((EntityPath)QDO).set(ThirdApiLogRepoProc.QDO.retryTimes, (Object)((Long)ObjectUtil.defaultIfNull((Object)retryTimes, (Object)0L)).intValue()).where(new Predicate[]{ThirdApiLogRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public void updateRespResult(long id, boolean success, String failReason, String respBody) {
        Long retryTimes = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)ThirdApiLogRepoProc.QDO.id.count()).from((EntityPath)QDO)).where((Predicate)ThirdApiLogRepoProc.QDO.originalId.eq((Object)id))).fetchOne();
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)ThirdApiLogRepoProc.QDO.reqSuccess, (Object)true).set((Path)ThirdApiLogRepoProc.QDO.respSuccess, (Object)success).set(ThirdApiLogRepoProc.QDO.respTime, (Object)LocalDateTime.now()).set((Path)ThirdApiLogRepoProc.QDO.retryFailReason, (Object)failReason).set((Path)ThirdApiLogRepoProc.QDO.respBody, (Object)respBody).set(ThirdApiLogRepoProc.QDO.retryTimes, (Object)((Long)ObjectUtil.defaultIfNull((Object)retryTimes, (Object)0L)).intValue()).where(new Predicate[]{ThirdApiLogRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public void updateReqTime(long id, LocalDateTime reqTime) {
        super.updateValue(ThirdApiLogRepoProc.QDO.reqTime, (Object)reqTime, id);
    }

    public void updateRetryFailResult(long id, String reason) {
        Long retryTimes = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)ThirdApiLogRepoProc.QDO.id.count()).from((EntityPath)QDO)).where((Predicate)ThirdApiLogRepoProc.QDO.originalId.eq((Object)id))).fetchOne();
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)ThirdApiLogRepoProc.QDO.retryFailReason, (Object)reason).set(ThirdApiLogRepoProc.QDO.retryTimes, (Object)((Long)ObjectUtil.defaultIfNull((Object)retryTimes, (Object)0L)).intValue()).where(new Predicate[]{ThirdApiLogRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public void clearExpiredLogs(@NotNull LocalDateTime expiredTime) {
        super.delete((Predicate)ThirdApiLogRepoProc.QDO.reqTime.lt((Comparable)expiredTime));
    }

    public Long getOriginalLogId(long id) {
        Boolean retried;
        Long originalId = (Long)super.getValue(ThirdApiLogRepoProc.QDO.originalId, id);
        if (originalId == null && Boolean.FALSE.equals(retried = (Boolean)super.getValue((Path)ThirdApiLogRepoProc.QDO.retried, id))) {
            return id;
        }
        return originalId;
    }

    public LocalDateTime getLastReqTime(long originalId) {
        return (LocalDateTime)super.getValue(ThirdApiLogRepoProc.QDO.reqTime, (Predicate)ThirdApiLogRepoProc.QDO.originalId.eq((Object)originalId).and((Predicate)ThirdApiLogRepoProc.QDO.reqTime.isNotNull()), new OrderSpecifier[]{ThirdApiLogRepoProc.QDO.reqTime.desc()});
    }

    public Map<Long, Long> queryLastRetry(Collection<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{ThirdApiLogRepoProc.QDO.id, ThirdApiLogRepoProc.QDO.lastRetryId}).from((EntityPath)QDO)).where((Predicate)ThirdApiLogRepoProc.QDO.id.in(ids))).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get(ThirdApiLogRepoProc.QDO.id), t -> (Long)t.get(ThirdApiLogRepoProc.QDO.lastRetryId), (t1, t2) -> t1));
    }

    public PagingVO<SysThirdApiLogDO> queryByPage(Long sysTenantId, ThirdApiLogQueryDTO requestDTO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(ThirdApiLogRepoProc.QDO.sysTenantId, (Object)sysTenantId).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.appCode, (Object)requestDTO.getAppCode()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.restful, (Object)requestDTO.getRestful()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.server, (Object)requestDTO.getServer()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.clientId, (Object)requestDTO.getClientId()).andEq(ThirdApiLogRepoProc.QDO.userId, (Object)requestDTO.getUserId()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.username, (Object)requestDTO.getUsername()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.uri, (Object)requestDTO.getUri()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.reqSuccess, (Object)requestDTO.getReqSuccess()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.respSuccess, (Object)requestDTO.getRespSuccess()).andBetween(ThirdApiLogRepoProc.QDO.reqTime, (Comparable)requestDTO.getReqTimeStart(), (Comparable)requestDTO.getReqTimeEnd()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.retried, (Object)false).build();
        return super.queryByPage(predicate, requestDTO.getPageRequest());
    }

    public PagingVO<SysThirdApiLogDO> queryByPage(ThirdApiLogQueryVO queryVO, Long sysTenantId, Boolean server, String thirdApp) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.appCode, (Object)queryVO.getAppCode()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.server, (Object)server).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.thirdApp, (Object)thirdApp).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.businessType, (Object)queryVO.getBusinessType()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.businessKey, (Object)queryVO.getBusinessKey()).andRightLike((StringExpression)ThirdApiLogRepoProc.QDO.uri, queryVO.getUri()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.respSuccess, (Object)queryVO.getRespSuccess()).andBetween(ThirdApiLogRepoProc.QDO.reqTime, (Comparable)queryVO.getReqTimeStart(), (Comparable)queryVO.getReqTimeEnd()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.retried, (Object)false).andEq(ThirdApiLogRepoProc.QDO.sysTenantId, (Object)sysTenantId).build();
        return super.queryByPage(predicate, queryVO.getPageRequest(), ThirdApiLogRepoProc.QDO.reqTime.desc());
    }

    public PagingVO<ThirdApiLogAggPageRespVO> queryAggByPage(ThirdApiLogQueryVO queryVO, Long sysTenantId, Boolean server, String thirdApp) {
        PageRequest pageRequest;
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.appCode, (Object)queryVO.getAppCode()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.server, (Object)server).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.thirdApp, (Object)thirdApp).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.businessType, (Object)queryVO.getBusinessType()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.businessKey, (Object)queryVO.getBusinessKey()).andRightLike((StringExpression)ThirdApiLogRepoProc.QDO.uri, queryVO.getUri()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.respSuccess, (Object)queryVO.getRespSuccess()).andBetween(ThirdApiLogRepoProc.QDO.reqTime, (Comparable)queryVO.getReqTimeStart(), (Comparable)queryVO.getReqTimeEnd()).andEq(ThirdApiLogRepoProc.QDO.sysTenantId, (Object)sysTenantId).build();
        QBean qbean = Projections.bean(ThirdApiLogAggPageRespVO.class, (Expression[])new Expression[]{ThirdApiLogRepoProc.QDO.thirdApp, ThirdApiLogRepoProc.QDO.businessType, ThirdApiLogRepoProc.QDO.businessKey, ThirdApiLogRepoProc.QDO.respSuccess, ThirdApiLogRepoProc.QDO.reqTime.max().as("reqTime"), QDO.count().as("reqTimes"), ThirdApiLogRepoProc.QDO.id.max().as("id")});
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qbean).from((EntityPath)QDO)).where(predicate)).groupBy(new Expression[]{ThirdApiLogRepoProc.QDO.thirdApp, ThirdApiLogRepoProc.QDO.businessType, ThirdApiLogRepoProc.QDO.businessKey, ThirdApiLogRepoProc.QDO.server, ThirdApiLogRepoProc.QDO.respSuccess});
        PagingVO pageData = super.queryByPage(jpaQuery, PageRequest.of((int)(pageRequest = queryVO.getPageRequest()).getPageNumber(), (int)pageRequest.getPageSize()), ThirdApiLogRepoProc.QDO.reqTime.max().desc());
        if (pageData.isEmpty()) {
            return pageData;
        }
        Set ids = pageData.stream().map(ThirdApiLogAggPageRespVO::getId).collect(Collectors.toSet());
        Map<Long, SysThirdApiLogDO> detailMap = super.get(ids).stream().collect(Collectors.toMap(BaseModel::getId, t -> t, (t1, t2) -> t1));
        pageData.each(t -> {
            SysThirdApiLogDO detail = (SysThirdApiLogDO)((Object)((Object)detailMap.get(t.getId())));
            if (detail == null) {
                return;
            }
            t.setAppCode(detail.getAppCode());
            t.setServer(detail.getServer());
            t.setServerAddr(detail.getServerAddr());
            t.setUri(detail.getUri());
            t.setReqMethod(detail.getReqMethod());
        });
        return pageData;
    }

    public List<SysThirdApiLogDO> listDetailForAgg(ThirdApiLogQueryVO queryVO, SysThirdApiLogDO recordDO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.appCode, (Object)recordDO.getAppCode()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.server, (Object)recordDO.getServer()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.thirdApp, (Object)recordDO.getThirdApp()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.businessType, (Object)recordDO.getBusinessType()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.businessKey, (Object)recordDO.getBusinessKey()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.respSuccess, (Object)recordDO.getRespSuccess()).andBetween(ThirdApiLogRepoProc.QDO.reqTime, (Comparable)queryVO.getReqTimeStart(), (Comparable)queryVO.getReqTimeEnd()).andEq(ThirdApiLogRepoProc.QDO.sysTenantId, (Object)recordDO.getSysTenantId()).build();
        return super.getList(predicate, new OrderSpecifier[0]).stream().sorted(Comparator.comparing(SysThirdApiLogDO::getReqTime, Comparator.nullsFirst(LocalDateTime::compareTo))).collect(Collectors.toList());
    }

    public PagingVO<SysThirdApiLogDO> pageDetailForAgg(ThirdApiLogQueryVO queryVO, SysThirdApiLogDO recordDO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.appCode, (Object)recordDO.getAppCode()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.server, (Object)recordDO.getServer()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.thirdApp, (Object)recordDO.getThirdApp()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.businessType, (Object)recordDO.getBusinessType()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.businessKey, (Object)recordDO.getBusinessKey()).andEq((SimpleExpression)ThirdApiLogRepoProc.QDO.respSuccess, (Object)recordDO.getRespSuccess()).andBetween(ThirdApiLogRepoProc.QDO.reqTime, (Comparable)queryVO.getReqTimeStart(), (Comparable)queryVO.getReqTimeEnd()).andEq(ThirdApiLogRepoProc.QDO.sysTenantId, (Object)recordDO.getSysTenantId()).build();
        return super.queryByPage(predicate, queryVO.getPageRequest(), ThirdApiLogRepoProc.QDO.reqTime.asc());
    }

    public List<SysThirdApiLogDO> listRetryRecord(long originalId) {
        return super.getListByValue(ThirdApiLogRepoProc.QDO.originalId, (Object)originalId, new OrderSpecifier[0]);
    }

    public PagingVO<SysThirdApiLogDO> pageRetryRecord(long originalId, Boolean requestTimeIsNull, PageRequest pageRequest) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(ThirdApiLogRepoProc.QDO.originalId, (Object)originalId).and(requestTimeIsNull != null, () -> Boolean.TRUE.equals(requestTimeIsNull) ? ThirdApiLogRepoProc.QDO.reqTime.isNull() : ThirdApiLogRepoProc.QDO.reqTime.isNotNull()).build();
        return super.queryByPage(predicate, pageRequest, ThirdApiLogRepoProc.QDO.reqTime.desc());
    }
}

