/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.system.service.common.constant.ThirdPartAccountType;
import com.elitescloud.cloudt.system.service.model.bo.ThirdPartAccountBO;
import com.elitescloud.cloudt.system.service.model.entity.QSysThirdPartyAccountDO;
import com.elitescloud.cloudt.system.service.model.entity.SysThirdPartyAccountDO;
import com.fasterxml.jackson.core.type.TypeReference;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.springframework.stereotype.Repository;

@Repository
public class ThirdPartyAccountRepoProc
extends BaseRepoProc<SysThirdPartyAccountDO> {
    private static final QSysThirdPartyAccountDO QDO = QSysThirdPartyAccountDO.sysThirdPartyAccountDO;

    public ThirdPartyAccountRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateCasId(long id, Long casId) {
        super.updateValue((Path)ThirdPartyAccountRepoProc.QDO.casId, (Object)casId, id);
    }

    public Long getCasId(long id) {
        return (Long)super.getValue((Path)ThirdPartyAccountRepoProc.QDO.casId, id);
    }

    public Long getTenantIdByAccount(@NotBlank String account) {
        return (Long)super.getValueByValue((Path)ThirdPartyAccountRepoProc.QDO.sysTenantId, (Path)ThirdPartyAccountRepoProc.QDO.account, (Object)account);
    }

    public SysThirdPartyAccountDO getOneByType(@NotBlank ThirdPartAccountType accountType, @NotBlank String businessType, long tenantId) {
        return (SysThirdPartyAccountDO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)QDO).where((Predicate)ThirdPartyAccountRepoProc.QDO.sysTenantId.eq((Object)tenantId).and((Predicate)ThirdPartyAccountRepoProc.QDO.accountType.eq((Object)accountType.getValue())).and((Predicate)ThirdPartyAccountRepoProc.QDO.businessType.eq((Object)businessType)))).limit(1L)).fetchOne();
    }

    public Long getIdByType(@NotBlank ThirdPartAccountType accountType, @NotBlank String businessType, long tenantId) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)ThirdPartyAccountRepoProc.QDO.id).from((EntityPath)QDO)).where((Predicate)ThirdPartyAccountRepoProc.QDO.sysTenantId.eq((Object)tenantId).and((Predicate)ThirdPartyAccountRepoProc.QDO.accountType.eq((Object)accountType.getValue())).and((Predicate)ThirdPartyAccountRepoProc.QDO.businessType.eq((Object)businessType)))).limit(1L)).fetchOne();
    }

    public boolean existsAccount(String account) {
        return super.exists((Path)ThirdPartyAccountRepoProc.QDO.account, (Object)account);
    }

    public ThirdPartAccountBO getAccountConfig(@NotBlank ThirdPartAccountType accountType, @NotBlank String businessType, long tenantId) {
        Tuple result = (Tuple)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{ThirdPartyAccountRepoProc.QDO.sysTenantId, ThirdPartyAccountRepoProc.QDO.businessType, ThirdPartyAccountRepoProc.QDO.account, ThirdPartyAccountRepoProc.QDO.accountType, ThirdPartyAccountRepoProc.QDO.configJson}).from((EntityPath)QDO)).where((Predicate)ThirdPartyAccountRepoProc.QDO.accountType.eq((Object)accountType.getValue()).and((Predicate)ThirdPartyAccountRepoProc.QDO.businessType.eq((Object)businessType)).and((Predicate)ThirdPartyAccountRepoProc.QDO.sysTenantId.eq((Object)tenantId)).and((Predicate)ThirdPartyAccountRepoProc.QDO.enabled.eq(Boolean.valueOf(true))))).limit(1L)).fetchOne();
        if (result == null) {
            return null;
        }
        ThirdPartAccountBO accountBO = new ThirdPartAccountBO();
        accountBO.setSysTenantId((Long)result.get((Expression)ThirdPartyAccountRepoProc.QDO.sysTenantId));
        accountBO.setBusinessType((String)result.get((Expression)ThirdPartyAccountRepoProc.QDO.businessType));
        accountBO.setAccount((String)result.get((Expression)ThirdPartyAccountRepoProc.QDO.account));
        accountBO.setAccountType((String)result.get((Expression)ThirdPartyAccountRepoProc.QDO.accountType));
        accountBO.setConfig((Map)JSONUtil.json2Obj((String)((String)result.get((Expression)ThirdPartyAccountRepoProc.QDO.configJson)), (TypeReference)new TypeReference<Map<String, Object>>(){}));
        return accountBO;
    }
}

