/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.bo.SysUdcBO;
import com.elitescloud.cloudt.system.model.vo.query.udc.UdcPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.udc.UdcWithValuesPageRespVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformUdcDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformUdcDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class UdcRepoProc
extends BaseRepoProc<SysPlatformUdcDO> {
    private static final QSysPlatformUdcDO QDO = QSysPlatformUdcDO.sysPlatformUdcDO;

    public UdcRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void delete(@NotBlank String appCode, @NotBlank String udcCode) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{UdcRepoProc.QDO.udcCode.eq((Object)udcCode).and((Predicate)UdcRepoProc.QDO.appCode.eq((Object)appCode))}).execute();
    }

    public PagingVO<SysPlatformUdcDO> pageMng(UdcPageQueryVO queryVO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)UdcRepoProc.QDO.appCode, (Object)queryVO.getAppCode()).andEq((SimpleExpression)UdcRepoProc.QDO.udcCode, (Object)queryVO.getUdcCode()).andLike((StringExpression)UdcRepoProc.QDO.udcName, queryVO.getUdcName()).build();
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO)).where(predicate);
        return super.queryByPage(jpaQuery, queryVO.getPageRequest(), UdcRepoProc.QDO.createTime.desc());
    }

    public PagingVO<UdcWithValuesPageRespVO> pageQuery(UdcPageQueryVO queryVO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)UdcRepoProc.QDO.appCode, (Object)queryVO.getAppCode()).andEq((SimpleExpression)UdcRepoProc.QDO.udcCode, (Object)queryVO.getUdcCode()).andLike((StringExpression)UdcRepoProc.QDO.udcName, queryVO.getUdcName()).andLike(new StringExpression[]{UdcRepoProc.QDO.udcCode, UdcRepoProc.QDO.udcName}, queryVO.getKeyword()).build();
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{UdcRepoProc.QDO.appCode, UdcRepoProc.QDO.udcCode, UdcRepoProc.QDO.udcName, UdcRepoProc.QDO.udcDescribe}).from((EntityPath)QDO)).where(predicate);
        return super.queryByPage(jpaQuery, queryVO.getPageRequest(), UdcRepoProc.QDO.createTime.desc(), t -> {
            UdcWithValuesPageRespVO respVO = new UdcWithValuesPageRespVO();
            respVO.setAppCode((String)t.get((Expression)UdcRepoProc.QDO.appCode));
            respVO.setUdcCode((String)t.get((Expression)UdcRepoProc.QDO.udcCode));
            respVO.setUdcName((String)t.get((Expression)UdcRepoProc.QDO.udcName));
            respVO.setUdcDescribe((String)t.get((Expression)UdcRepoProc.QDO.udcDescribe));
            return respVO;
        });
    }

    public PagingVO<SysUdcBO> pageAll(int page, int pageSize, String appCode) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanBO()).from((EntityPath)QDO)).where((Predicate)UdcRepoProc.QDO.appCode.eq((Object)appCode));
        return super.queryByPage(jpaQuery, super.ofPage(Integer.valueOf(page), Integer.valueOf(pageSize)));
    }

    public List<SysPlatformUdcDO> queryByUdcCode(String appCode, Set<String> udcCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO)).where((Predicate)UdcRepoProc.QDO.udcCode.in(udcCodes).and((Predicate)UdcRepoProc.QDO.appCode.eq((Object)appCode)))).fetch();
    }

    public List<SysUdcBO> queryBoByUdcCode(String appCode, Set<String> udcCodes) {
        BooleanExpression predicate = UdcRepoProc.QDO.udcCode.in(udcCodes);
        if (StringUtils.hasText((String)appCode)) {
            predicate = predicate.and((Predicate)UdcRepoProc.QDO.appCode.eq((Object)appCode));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanBO()).from((EntityPath)QDO)).where((Predicate)predicate)).fetch();
    }

    public SysPlatformUdcDO getByAppCodeAndUdcCode(String appCode, String udcCode) {
        BooleanExpression predicate = UdcRepoProc.QDO.udcCode.eq((Object)udcCode).and((Predicate)UdcRepoProc.QDO.appCode.eq((Object)appCode));
        return (SysPlatformUdcDO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO)).where((Predicate)predicate)).limit(1L)).fetchOne();
    }

    public SysUdcBO getBoByAppCodeAndUdcCode(String appCode, String udcCode) {
        BooleanExpression predicate = UdcRepoProc.QDO.udcCode.eq((Object)udcCode).and((Predicate)UdcRepoProc.QDO.appCode.eq((Object)appCode));
        return (SysUdcBO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanBO()).from((EntityPath)QDO)).where((Predicate)predicate)).limit(1L)).fetchOne();
    }

    public Map<String, String> getUdcNameByUdcCode(String appCode, Collection<String> udcCodes) {
        BooleanExpression predicate = UdcRepoProc.QDO.udcCode.in(udcCodes);
        if (StringUtils.hasText((String)appCode)) {
            predicate = predicate.and((Predicate)UdcRepoProc.QDO.appCode.eq((Object)appCode));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{UdcRepoProc.QDO.udcCode, UdcRepoProc.QDO.udcName}).from((EntityPath)QDO)).where((Predicate)predicate)).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)UdcRepoProc.QDO.udcCode), t -> (String)t.get((Expression)UdcRepoProc.QDO.udcName), (t1, t2) -> t1));
    }

    private QBean<SysUdcBO> qBeanBO() {
        return Projections.bean(SysUdcBO.class, (Expression[])new Expression[]{UdcRepoProc.QDO.id, UdcRepoProc.QDO.appCode, UdcRepoProc.QDO.udcCode, UdcRepoProc.QDO.udcName, UdcRepoProc.QDO.allowUpdate, UdcRepoProc.QDO.allowAddValue, UdcRepoProc.QDO.udcDescribe, UdcRepoProc.QDO.parentUdcCode});
    }
}

