/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.bo.SysUdcValueBO;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformUdcValueDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformUdcValueDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class UdcValueRepoProc
extends BaseRepoProc<SysPlatformUdcValueDO> {
    private static final QSysPlatformUdcValueDO QDO = QSysPlatformUdcValueDO.sysPlatformUdcValueDO;

    public UdcValueRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void delete(@NotBlank String appCode, @NotBlank String udcCode) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{UdcValueRepoProc.QDO.udcCode.eq((Object)udcCode).and((Predicate)UdcValueRepoProc.QDO.appCode.eq((Object)appCode))}).execute();
    }

    public void updateEnabled(Long id, Boolean enabled) {
        super.updateValue((Path)UdcValueRepoProc.QDO.allowStart, (Object)enabled, id.longValue());
    }

    public List<SysPlatformUdcValueDO> listByUdc(String appCode, String udcCode, boolean includeDisabled) {
        BooleanExpression predicate = UdcValueRepoProc.QDO.udcCode.eq((Object)udcCode).and((Predicate)UdcValueRepoProc.QDO.appCode.eq((Object)appCode));
        if (!includeDisabled) {
            predicate = super.andPredicate((Predicate)predicate, (Predicate)UdcValueRepoProc.QDO.allowStart.eq(Boolean.valueOf(true)));
        }
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO)).where((Predicate)predicate)).orderBy(this.defaultOrder())).fetch();
    }

    public List<SysUdcValueBO> listBoByUdc(String appCode, String udcCode, boolean includeDisabled) {
        BooleanExpression predicate = UdcValueRepoProc.QDO.udcCode.eq((Object)udcCode).and((Predicate)UdcValueRepoProc.QDO.appCode.eq((Object)appCode));
        if (!includeDisabled) {
            predicate = super.andPredicate((Predicate)predicate, (Predicate)UdcValueRepoProc.QDO.allowStart.eq(Boolean.valueOf(true)));
        }
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanValueBO()).from((EntityPath)QDO)).where((Predicate)predicate)).orderBy(this.defaultOrder())).fetch();
    }

    public List<SysPlatformUdcValueDO> queryByUdc(String appCode, Set<String> udcCodes, boolean includeDisabled) {
        BooleanExpression predicate = UdcValueRepoProc.QDO.udcCode.in(udcCodes).and((Predicate)UdcValueRepoProc.QDO.appCode.eq((Object)appCode));
        if (!includeDisabled) {
            predicate = super.andPredicate((Predicate)predicate, (Predicate)UdcValueRepoProc.QDO.allowStart.eq(Boolean.valueOf(true)));
        }
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO)).where((Predicate)predicate)).orderBy(this.defaultOrder())).fetch();
    }

    public List<SysUdcValueBO> queryBoByUdc(String appCode, Collection<String> udcCodes, boolean includeDisabled) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(StringUtils.hasText((String)appCode), (SimpleExpression)UdcValueRepoProc.QDO.appCode, (Object)appCode).andIn(CollUtil.isNotEmpty(udcCodes), (SimpleExpression)UdcValueRepoProc.QDO.udcCode, udcCodes).andEq(!includeDisabled, (SimpleExpression)UdcValueRepoProc.QDO.allowStart, (Object)true).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanValueBO()).from((EntityPath)QDO)).where(predicate)).orderBy(this.defaultOrder())).fetch();
    }

    private QBean<SysUdcValueBO> qBeanValueBO() {
        return Projections.bean(SysUdcValueBO.class, (Expression[])new Expression[]{UdcValueRepoProc.QDO.id, UdcValueRepoProc.QDO.appCode, UdcValueRepoProc.QDO.udcCode, UdcValueRepoProc.QDO.udcValueCode, UdcValueRepoProc.QDO.udcValueName, UdcValueRepoProc.QDO.udcOrder, UdcValueRepoProc.QDO.allowStart, UdcValueRepoProc.QDO.udcValueDescribe, UdcValueRepoProc.QDO.allowDefault, UdcValueRepoProc.QDO.parentUdcValueCode, UdcValueRepoProc.QDO.valueAliasName});
    }

    private OrderSpecifier<Integer> defaultOrder() {
        return UdcValueRepoProc.QDO.udcOrder.asc();
    }
}

