/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.model.vo.query.user.sync.UserSyncRecordPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.sync.UserSyncRecordDetailRespVO;
import com.elitescloud.cloudt.system.provider.usersync.SyncUserResult;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantUserDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysUserDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysUserSyncDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserSyncDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class UserSyncRepoProc
extends BaseRepoProc<SysUserSyncDO> {
    private static final QSysUserSyncDO QDO = QSysUserSyncDO.sysUserSyncDO;
    private static final QSysUserDO QDO_USER = QSysUserDO.sysUserDO;
    private static final QSysTenantUserDO QDO_TENANT_USER = QSysTenantUserDO.sysTenantUserDO;
    @Autowired
    private TenantClientProvider tenantClientProvider;

    public UserSyncRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateSyncResult(long id, SyncUserResult syncResult, String failReasonDetail) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)UserSyncRepoProc.QDO.syncSuccess, (Object)syncResult.isSuccess()).set((Path)UserSyncRepoProc.QDO.syncFinishTime, (Object)LocalDateTime.now()).set((Path)UserSyncRepoProc.QDO.failReason, (Object)syncResult.getFailMsg()).set((Path)UserSyncRepoProc.QDO.failReasonDetail, (Object)failReasonDetail).set((Path)UserSyncRepoProc.QDO.receipt, (Object)syncResult.getReceipt()).set((Path)UserSyncRepoProc.QDO.outerUserId, (Object)syncResult.getOuterUserId()).set((Path)UserSyncRepoProc.QDO.outerUserCode, (Object)syncResult.getOuterUserCode()).where(new Predicate[]{UserSyncRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public SysUserSyncDO getUserSync(long userId, @NotBlank String outerSysCode) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)UserSyncRepoProc.QDO.userId, (Object)userId).andEq((SimpleExpression)UserSyncRepoProc.QDO.outerSysCode, (Object)outerSysCode).build();
        return (SysUserSyncDO)super.getOne(predicate);
    }

    public PagingVO<UserSyncRecordDetailRespVO> pageMng(@NotNull UserSyncRecordPageQueryVO queryVO, @NotBlank String outerSysCode) {
        Expression[] fields = new Expression[]{UserSyncRepoProc.QDO_USER.id, UserSyncRepoProc.QDO_USER.username, UserSyncRepoProc.QDO_USER.lastName, UserSyncRepoProc.QDO_USER.firstName, UserSyncRepoProc.QDO_USER.mobile, UserSyncRepoProc.QDO_USER.email, UserSyncRepoProc.QDO_USER.idCard, UserSyncRepoProc.QDO.outerUserCode, UserSyncRepoProc.QDO.id, UserSyncRepoProc.QDO.syncTime, UserSyncRepoProc.QDO.syncSuccess, UserSyncRepoProc.QDO.failReason, UserSyncRepoProc.QDO.syncData};
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(fields).from((EntityPath)QDO_USER)).leftJoin((EntityPath)QDO)).on((Predicate)UserSyncRepoProc.QDO.userId.eq((Expression)UserSyncRepoProc.QDO_USER.id).and((Predicate)UserSyncRepoProc.QDO.outerSysCode.eq((Object)outerSysCode)));
        SysTenantDTO tenant = this.tenantClientProvider.getCurrentTenant();
        if (tenant != null) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)QDO_TENANT_USER)).on((Predicate)UserSyncRepoProc.QDO_TENANT_USER.sysUserId.eq((Expression)UserSyncRepoProc.QDO_USER.id).and((Predicate)UserSyncRepoProc.QDO_TENANT_USER.sysTenantId.eq((Object)tenant.getId())));
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)UserSyncRepoProc.QDO.outerUserCode, (Object)queryVO.getOuterUserCode()).andEq((SimpleExpression)UserSyncRepoProc.QDO_USER.username, (Object)queryVO.getUsername()).andEq((SimpleExpression)UserSyncRepoProc.QDO_USER.mobile, (Object)queryVO.getMobile()).andEq((SimpleExpression)UserSyncRepoProc.QDO_USER.email, (Object)queryVO.getEmail()).andEq((SimpleExpression)UserSyncRepoProc.QDO_TENANT_USER.sysTenantId, (Object)(tenant == null ? null : tenant.getId())).andLike(new StringExpression[]{UserSyncRepoProc.QDO_USER.lastName, UserSyncRepoProc.QDO_USER.firstName}, queryVO.getFullName()).andLike(new StringExpression[]{UserSyncRepoProc.QDO_USER.username, UserSyncRepoProc.QDO_USER.lastName, UserSyncRepoProc.QDO_USER.firstName, UserSyncRepoProc.QDO.outerUserCode}, queryVO.getKeyword()).build();
        jpaQuery.where(predicate);
        return super.queryByPage(jpaQuery, queryVO.getPageRequest(), UserSyncRepoProc.QDO_USER.createTime.asc(), t -> {
            UserSyncRecordDetailRespVO respVO = new UserSyncRecordDetailRespVO();
            respVO.setId((Long)t.get((Expression)UserSyncRepoProc.QDO_USER.id));
            respVO.setUsername((String)t.get((Expression)UserSyncRepoProc.QDO_USER.username));
            respVO.setFullName(this.getFullName((String)t.get((Expression)UserSyncRepoProc.QDO_USER.lastName), (String)t.get((Expression)UserSyncRepoProc.QDO_USER.firstName)));
            respVO.setMobile((String)t.get((Expression)UserSyncRepoProc.QDO_USER.mobile));
            respVO.setEmail((String)t.get((Expression)UserSyncRepoProc.QDO_USER.email));
            respVO.setIdCard((String)t.get((Expression)UserSyncRepoProc.QDO_USER.idCard));
            respVO.setOuterUserCode((String)t.get((Expression)UserSyncRepoProc.QDO.outerUserCode));
            respVO.setSync(t.get((Expression)UserSyncRepoProc.QDO.id) != null && Boolean.TRUE.equals(t.get((Expression)UserSyncRepoProc.QDO.syncSuccess)));
            respVO.setSyncSuccess((Boolean)t.get((Expression)UserSyncRepoProc.QDO.syncSuccess));
            respVO.setSyncTime((LocalDateTime)t.get((Expression)UserSyncRepoProc.QDO.syncTime));
            respVO.setSyncData((Map)t.get((Expression)UserSyncRepoProc.QDO.syncData));
            respVO.setFailReason((String)t.get((Expression)UserSyncRepoProc.QDO.failReason));
            return respVO;
        });
    }

    public String getOuterUserCodeByUserId(long userId, @NotBlank String outerSysCode) {
        return (String)super.getValue((Path)UserSyncRepoProc.QDO.outerUserCode, (Predicate)UserSyncRepoProc.QDO.userId.eq((Object)userId).and((Predicate)UserSyncRepoProc.QDO.outerSysCode.eq((Object)outerSysCode)), new OrderSpecifier[0]);
    }

    private String getFullName(String lastName, String firstName) {
        if (!StringUtils.hasText((String)lastName)) {
            return firstName;
        }
        return lastName + CharSequenceUtil.blankToDefault((CharSequence)firstName, (String)"");
    }
}

