/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtils
extends BeanUtil {
    private static final Logger logger = LoggerFactory.getLogger(BeanUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.instance();

    public static <T> T toBean(String source, TypeReference<T> typeRef) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(typeRef);
        return (T)OBJECT_MAPPER.readValue(source, typeRef);
    }

    public static <T> T toBean(String source, Class<T> clazz) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(clazz);
        return (T)OBJECT_MAPPER.readValue(source, clazz);
    }

    public static <T> T toBean(Map<String, ?> source, Class<T> clazz) {
        return BeanUtils.toBean(BeanUtils.toJsonStr(source), clazz);
    }

    public static <T> T toBean(Map<String, ?> source, TypeReference<T> typeRef) {
        return BeanUtils.toBean(BeanUtils.toJsonStr(source), typeRef);
    }

    public static Object[] toObjects(String source, Type[] types) {
        Object[] objects = new Object[types.length];
        JsonNode jsonNode = OBJECT_MAPPER.readTree(source);
        for (int i = 0; i < types.length; ++i) {
            JsonNode pJsonNode = jsonNode.get(i);
            Type pType = types[i];
            String pJson = pJsonNode.toString();
            objects[i] = pType instanceof ParameterizedType ? OBJECT_MAPPER.readValue(pJson, new TypeReferenceExt(pType)) : OBJECT_MAPPER.readValue(pJson, (Class)pType);
        }
        return objects;
    }

    public static Map<String, Object> toMap(String source) {
        return BeanUtils.toMap(source, Object.class);
    }

    public static <T> Map<String, T> toMap(String source, Class<T> clazz) {
        return (Map)BeanUtils.toMap(source, new TypeReference<Map<String, T>>(){});
    }

    public static <T> T toMap(String source, TypeReference<T> typeRef) {
        Objects.requireNonNull(source);
        return (T)OBJECT_MAPPER.readValue(source, typeRef);
    }

    public static Map<String, Object> beanToMap(Object bean, String ... properties) {
        return BeanUtil.beanToMap((Object)bean, (String[])properties);
    }

    public static <T> List<T> toList(String source, Class<T> clazz) {
        return (List)OBJECT_MAPPER.readValue(source, (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(ArrayList.class, clazz));
    }

    public static <T> List<T> toList(List<Map<String, Object>> source, Class<T> clazz) {
        return source.stream().map(row -> BeanUtils.toBean(row, clazz)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> List<T> toList(Object[] source, Class<T> clazz) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(clazz);
        return (List)OBJECT_MAPPER.readValue(BeanUtils.toJsonStr(source), new TypeReference<List<T>>(){});
    }

    public static List<String> toStrList(Object[] source) {
        return BeanUtils.toList(source, String.class);
    }

    public static List<Integer> toIntegerList(Object[] source) {
        return BeanUtils.toList(source, Integer.class);
    }

    public static List<Map<String, Object>> toMapList(String source) {
        Objects.requireNonNull(source);
        return (List)OBJECT_MAPPER.readValue(source, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
    }

    public static List<Map<String, Object>> toMapList(List<?> source) {
        Objects.requireNonNull(source);
        return (List)OBJECT_MAPPER.readValue(BeanUtils.toJsonStr(source), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
    }

    public static <T> String toJsonStr(T payload) {
        return BeanUtils.toJsonOrThrow(payload);
    }

    public static Optional<String> toJsonOptional(Object obj) {
        if (obj == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(OBJECT_MAPPER.writeValueAsString(obj));
        }
        catch (InvalidDefinitionException e) {
            JSON parse = JSONUtil.parse((Object)obj);
            return Optional.of(parse.toStringPretty());
        }
        catch (JsonProcessingException e) {
            logger.warn("[PHOENIX-JSON] Convert object to json FAILED: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public static String toJsonOrEmpty(Object obj) {
        return BeanUtils.toJsonOptional(obj).orElse("");
    }

    public static String toJsonOrThrow(Object obj) {
        return BeanUtils.toJsonOptional(obj).orElseThrow(() -> new IllegalArgumentException("[PHOENIX-JSON] Convert object to json FAILED: " + String.valueOf(obj)));
    }

    static class TypeReferenceExt<T>
    extends TypeReference<T> {
        protected Type parameterized;

        public TypeReferenceExt(Type parameterized) {
            this.parameterized = parameterized;
        }

        public Type getType() {
            return this.parameterized;
        }
    }
}

