/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.util;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.cloudt.system.util.TransactionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionUtil {
    private static final Logger log = LoggerFactory.getLogger(TransactionUtil.class);
    private static TransactionService newTransactionService;

    public static void runAfterCommit(final Runnable runnable) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCompletion(int status) {
                    TransactionUtil.runNewTx(runnable);
                }
            });
        } else {
            runnable.run();
        }
    }

    public static void runNewTx(Runnable runnable) {
        if (newTransactionService == null) {
            newTransactionService = (TransactionService)SpringUtil.getBean(TransactionService.class);
        }
        newTransactionService.executeWithNew(runnable);
    }

    public static void runTx(Runnable runnable) {
        if (newTransactionService == null) {
            newTransactionService = (TransactionService)SpringUtil.getBean(TransactionService.class);
        }
        newTransactionService.execute(runnable);
    }
}

