/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.ucenter.controller;

import com.elitescloud.boot.auth.client.common.InterceptUri;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.vo.param.AdInfoPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.AdInfoQueryParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.AdInfoShowParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.AdInfoSortParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.AdSpacePagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.LinkAddressPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.AdInfoDetailRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.AdInfoRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.AdSpaceRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.AdInfoSaveVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.AdSpaceSaveVO;
import com.elitescloud.cloudt.ucenter.service.AdManageService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ad/manage"}, produces={"application/json"})
@Api(tags={"\u5e7f\u544a\u7ba1\u7406"})
public class AdManageController {
    private static final Logger log = LoggerFactory.getLogger(AdManageController.class);
    private final AdManageService adManageService;

    @PostMapping(value={"/space/search"})
    @ApiOperation(value="\u5e7f\u544a\u4f4d\u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=1)
    public ApiResult<PagingVO<AdSpaceRespVO>> searchPagingList(@RequestBody AdSpacePagingParam searchParam) {
        return ApiResult.ok(this.adManageService.adSpacePagingSearch(searchParam));
    }

    @PostMapping(value={"/space/save"})
    @ApiOperation(value="\u7f16\u8f91\u5e7f\u544a\u4f4d")
    @ApiOperationSupport(order=3)
    public ApiResult<Long> saveOrUpdateAdSpace(@RequestBody @Validated AdSpaceSaveVO saveVO) {
        return ApiResult.ok((Object)this.adManageService.saveOrUpdateAdSpace(saveVO));
    }

    @PostMapping(value={"/info/save"})
    @ApiOperation(value="\u7f16\u8f91/\u4fdd\u5b58\u5e7f\u544a")
    @ApiOperationSupport(order=3)
    public ApiResult<Long> articleSave(@RequestBody @Validated AdInfoSaveVO saveVO) {
        return ApiResult.ok((Object)this.adManageService.saveOrUpdateAdInfo(saveVO));
    }

    @PostMapping(value={"/info/search"})
    @ApiOperation(value="\u5e7f\u544a\u4fe1\u606f\u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=1)
    public ApiResult<PagingVO<AdInfoRespVO>> search(@RequestBody AdInfoPagingParam searchParam) {
        return ApiResult.ok(this.adManageService.search(searchParam));
    }

    @DeleteMapping(value={"/info/delete"})
    @ApiOperation(value="\u5220\u9664\u5e7f\u544a")
    @ApiOperationSupport(order=6)
    public ApiResult<List<Long>> deleteAdInfo(@RequestBody List<Long> ids) {
        return ApiResult.ok(this.adManageService.deleteAdInfo(ids));
    }

    @PostMapping(value={"/show/update"})
    @ApiOperation(value="\u5e7f\u544a\u663e\u793a/\u9690\u85cf\u7f16\u8f91")
    public ApiResult<?> showUpdate(@RequestBody @Validated AdInfoShowParam param) {
        return ApiResult.ok((Object)this.adManageService.showUpdate(param));
    }

    @PostMapping(value={"/sort/update"})
    @ApiOperation(value="\u5e7f\u544a\u6392\u5e8f\u7f16\u8f91")
    public ApiResult<Integer> sortUpdate(@RequestBody @Validated AdInfoSortParam param) {
        return ApiResult.ok((Object)this.adManageService.sortUpdate(param));
    }

    @GetMapping(value={"/info/query/{id}"})
    @ApiOperation(value="\u5e7f\u544a\u8be6\u60c5\u67e5\u8be2")
    @ApiOperationSupport(order=1)
    public ApiResult<AdInfoDetailRespVO> queryInfoDetail(@PathVariable Long id) {
        return ApiResult.ok((Object)this.adManageService.queryInfoDetail(id));
    }

    @PostMapping(value={"/link/address/"})
    @ApiOperation(value="\u67e5\u8be2\u76ee\u6807\u94fe\u63a5\u5730\u5740")
    @ApiOperationSupport(order=1)
    public ApiResult<?> queryLinkAddress(@RequestBody @Validated LinkAddressPagingParam param) {
        return ApiResult.ok((Object)this.adManageService.queryLinkAddress(param));
    }

    @ApiOperation(value="\u83b7\u53d6\u5e7f\u544a\u5217\u8868")
    @GetMapping(value={"/info/detailList"})
    public ApiResult<List<AdInfoDetailRespVO>> queryDetailList(AdInfoQueryParam queryParam) {
        return ApiResult.ok(this.adManageService.queryDetailList(queryParam));
    }

    public AdManageController(AdManageService adManageService) {
        this.adManageService = adManageService;
    }

    static {
        InterceptUri.addAllowUri(Set.of("/ad/manage/info/detailList"));
    }
}

