/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.ucenter.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.vo.param.ArticleCategoryPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.ArticleCategorySortParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.ArticleInfoPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.ArticleInfoShowParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.ArticleInfoSortParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.CategoryShowParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.ArticleCategoryRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.ArticleInfoCategoryRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.ArticleInfoDetailRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.ArticleInfoRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.UpCategoryRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.ArticleCategorySaveVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.ArticleInfoSaveVO;
import com.elitescloud.cloudt.ucenter.service.ArticleManageService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/article/manage"}, produces={"application/json"})
@Api(tags={"\u6587\u7ae0\u7ba1\u7406"})
public class ArticleManageController {
    private static final Logger log = LoggerFactory.getLogger(ArticleManageController.class);
    private final ArticleManageService articleManageService;

    public ArticleManageController(ArticleManageService articleManageService) {
        this.articleManageService = articleManageService;
    }

    @PostMapping(value={"category/search"})
    @ApiOperation(value="\u6587\u7ae0\u5206\u7c7b\u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=1)
    public ApiResult<PagingVO<ArticleCategoryRespVO>> search(@RequestBody ArticleCategoryPagingParam searchParam) {
        return ApiResult.ok(this.articleManageService.search(searchParam));
    }

    @PostMapping(value={"category/save"})
    @ApiOperation(value="\u7f16\u8f91\u4fdd\u5b58\u6587\u7ae0\u5206\u7c7b\u4fe1\u606f")
    @ApiOperationSupport(order=2)
    public ApiResult<Long> articleCategorySave(@RequestBody @Validated ArticleCategorySaveVO saveVO) {
        return ApiResult.ok((Object)this.articleManageService.saveOrUpdateArticleCategory(saveVO));
    }

    @DeleteMapping(value={"category/delete/{id}"})
    @ApiOperation(value="\u5220\u9664\u6587\u7ae0\u5206\u7c7b")
    @ApiOperationSupport(order=3)
    public ApiResult<Long> deleteArticleCategory(@PathVariable Long id) {
        return ApiResult.ok((Object)this.articleManageService.deleteArticleCategory(id));
    }

    @PostMapping(value={"/category/show/update"})
    @ApiOperation(value="\u6587\u7ae0\u5206\u7c7b\u663e\u793a/\u9690\u85cf\u7f16\u8f91")
    @ApiOperationSupport(order=4)
    public ApiResult<Long> categoryShowUpdate(@RequestBody @Validated CategoryShowParam param) {
        return ApiResult.ok((Object)this.articleManageService.categoryShowUpdate(param));
    }

    @PostMapping(value={"/category/sort/update"})
    @ApiOperation(value="\u6587\u7ae0\u5206\u7c7b\u6392\u5e8f\u7f16\u8f91")
    @ApiOperationSupport(order=5)
    public ApiResult<Integer> categorySortUpdate(@RequestBody @Validated ArticleCategorySortParam param) {
        return ApiResult.ok((Object)this.articleManageService.categorySortUpdate(param));
    }

    @GetMapping(value={"/up/category/{id}"})
    @ApiOperation(value="\u83b7\u53d6\u4e0a\u7ea7\u5206\u7c7b")
    @ApiOperationSupport(order=6)
    public ApiResult<List<UpCategoryRespVO>> queryUpCategory(@PathVariable Long id) {
        List<UpCategoryRespVO> voList = this.articleManageService.queryUpCategory(id);
        return ApiResult.ok(voList);
    }

    @PostMapping(value={"/info/search"})
    @ApiOperation(value="\u6587\u7ae0\u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=1)
    public ApiResult<PagingVO<ArticleInfoRespVO>> infoSearch(@RequestBody ArticleInfoPagingParam searchParam) {
        return ApiResult.ok(this.articleManageService.infoSearch(searchParam));
    }

    @PostMapping(value={"/info/save"})
    @ApiOperation(value="\u7f16\u8f91\u4fdd\u5b58\u6587\u7ae0\u4fe1\u606f")
    @ApiOperationSupport(order=7)
    public ApiResult<Long> articleSave(@RequestBody @Validated ArticleInfoSaveVO saveVO) {
        return ApiResult.ok((Object)this.articleManageService.saveOrUpdateArticleInfo(saveVO));
    }

    @DeleteMapping(value={"/info/delete/{id}"})
    @ApiOperation(value="\u5220\u9664\u6587\u7ae0\u4fe1\u606f")
    @ApiOperationSupport(order=8)
    public ApiResult<Long> deleteArticleInfo(@PathVariable Long id) {
        return ApiResult.ok((Object)this.articleManageService.deleteArticleInfo(id));
    }

    @PostMapping(value={"/info/show/update"})
    @ApiOperation(value="\u6587\u7ae0\u663e\u793a/\u9690\u85cf\u7f16\u8f91")
    @ApiOperationSupport(order=9)
    public ApiResult<Integer> infoShowUpdate(@RequestBody @Validated ArticleInfoShowParam param) {
        return ApiResult.ok((Object)this.articleManageService.infoShowUpdate(param));
    }

    @PostMapping(value={"/info/sort/update"})
    @ApiOperation(value="\u6587\u7ae0\u6392\u5e8f\u7f16\u8f91")
    @ApiOperationSupport(order=10)
    public ApiResult<Integer> infoSortUpdate(@RequestBody @Validated ArticleInfoSortParam param) {
        return ApiResult.ok((Object)this.articleManageService.infoSortUpdate(param));
    }

    @GetMapping(value={"/info/detail/{id}"})
    @ApiOperation(value="\u6587\u7ae0\u8be6\u60c5")
    @ApiOperationSupport(order=10)
    public ApiResult<ArticleInfoDetailRespVO> queryInfoDetail(@PathVariable Long id) {
        return ApiResult.ok((Object)this.articleManageService.queryInfoDetail(id));
    }

    @GetMapping(value={"/all/category"})
    @ApiOperation(value="\u6240\u6709\u6587\u7ae0\u5206\u7c7b\u6570\u636e")
    @ApiOperationSupport(order=6)
    public ApiResult<List<ArticleInfoCategoryRespVO>> queryAllCategory() {
        List<ArticleInfoCategoryRespVO> voList = this.articleManageService.queryAllCategory();
        return ApiResult.ok(voList);
    }

    @GetMapping(value={"/article/detail/{id}"})
    @ApiOperation(value="\u6587\u7ae0\u5185\u5bb9\u94fe\u63a5")
    @ApiOperationSupport(order=6)
    public ApiResult<String> queryArticleDetail(@PathVariable Long id) {
        return ApiResult.ok((Object)this.articleManageService.queryArticleDetail(id));
    }

    @GetMapping(value={"/category/article"})
    @ApiOperation(value="\u7ecf\u9500\u5546\u6587\u7ae0\u5206\u7c7b\u4fe1\u606f")
    @ApiOperationSupport(order=6)
    public ApiResult<?> queryCategoryArticle() {
        return ApiResult.ok(this.articleManageService.queryCategoryArticle());
    }
}

