/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.ucenter.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.vo.param.MessagePagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.MessageReceiverPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.PublishParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.MessageDetailRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.MessageReceiverRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.MessageRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.MessageSaveVO;
import com.elitescloud.cloudt.ucenter.service.MessageManageService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/message/manage"}, produces={"application/json"})
@Api(tags={"\u81ea\u5b9a\u4e49\u6d88\u606f\u7ba1\u7406"})
public class MessageManageController {
    private static final Logger log = LoggerFactory.getLogger(MessageManageController.class);
    private final MessageManageService messageManageService;

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u7f16\u8f91\u4fdd\u5b58\u6d88\u606f")
    @ApiOperationSupport(order=7)
    public ApiResult<Long> messageSave(@RequestBody @Validated MessageSaveVO saveVO) {
        return ApiResult.ok((Object)this.messageManageService.saveOrUpdate(saveVO));
    }

    @DeleteMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u6d88\u606f")
    @ApiOperationSupport(order=7)
    public ApiResult<?> delete(@RequestBody List<Long> ids) {
        return ApiResult.ok((Object)this.messageManageService.delete(ids));
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5217\u8868\u67e5\u8be2")
    @ApiOperationSupport(order=7)
    public ApiResult<PagingVO<MessageRespVO>> search(@RequestBody @Validated MessagePagingParam param) {
        return ApiResult.ok(this.messageManageService.search(param));
    }

    @GetMapping(value={"/detail/query/{id}"})
    @ApiOperation(value="\u8be6\u60c5\u67e5\u8be2")
    @ApiOperationSupport(order=7)
    public ApiResult<MessageDetailRespVO> queryDetail(@PathVariable Long id) {
        return ApiResult.ok((Object)this.messageManageService.queryDetail(id));
    }

    @PostMapping(value={"/receiver/search"})
    @ApiOperation(value="\u6d88\u606f\u63a5\u6536\u8005\u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=7)
    public ApiResult<PagingVO<MessageReceiverRespVO>> searchReceiver(@RequestBody MessageReceiverPagingParam param) {
        return ApiResult.ok(this.messageManageService.searchReceiver(param));
    }

    @PostMapping(value={"/publish"})
    @ApiOperation(value="\u53d1\u5e03\u6d88\u606f")
    @ApiOperationSupport(order=7)
    public ApiResult<?> publish(@RequestBody PublishParam param) {
        return ApiResult.ok((Object)this.messageManageService.publish(param));
    }

    public MessageManageController(MessageManageService messageManageService) {
        this.messageManageService = messageManageService;
    }
}

