/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.ucenter.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.vo.param.WebsiteBarPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.WebsiteBarShowParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.WebsiteBarSortParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.UpBarRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.WebsiteBarRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.WebsiteBarSaveVO;
import com.elitescloud.cloudt.ucenter.service.WebsiteBarService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/website/bar"}, produces={"application/json"})
@Api(value="\u7f51\u7ad9\u680f\u76ee\u914d\u7f6e", tags={"\u7f51\u7ad9\u680f\u76ee\u914d\u7f6e"})
@Validated
public class WebsiteBarController {
    private final WebsiteBarService websiteBarService;

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u7f51\u7ad9\u680f\u76ee\u5206\u9875\u67e5\u8be2")
    public ApiResult<PagingVO<WebsiteBarRespVO>> search(@RequestBody WebsiteBarPagingParam param) {
        return ApiResult.ok(this.websiteBarService.search(param));
    }

    @DeleteMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664")
    public ApiResult<?> batchDeleteByIds(@RequestBody List<Long> ids) {
        return ApiResult.ok((Object)this.websiteBarService.batchDeleteByIds(ids));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58\u7f16\u8f91")
    public ApiResult<Long> save(@RequestBody @Valid WebsiteBarSaveVO saveVO) {
        return ApiResult.ok((Object)this.websiteBarService.save(saveVO));
    }

    @PostMapping(value={"/show/update"})
    @ApiOperation(value="\u663e\u793a/\u9690\u85cf\u7f16\u8f91")
    public ApiResult<?> showUpdate(@RequestBody WebsiteBarShowParam param) {
        return ApiResult.ok((Object)this.websiteBarService.showUpdate(param));
    }

    @PostMapping(value={"/sort/update"})
    @ApiOperation(value="\u6392\u5e8f\u7f16\u8f91")
    public ApiResult<?> sortUpdate(@RequestBody WebsiteBarSortParam param) {
        return ApiResult.ok((Object)this.websiteBarService.sortUpdate(param));
    }

    @GetMapping(value={"/query/{id}"})
    @ApiOperation(value="\u7f51\u7ad9\u680f\u76ee\u8be6\u60c5\u67e5\u8be2")
    public ApiResult<WebsiteBarRespVO> queryDetail(@PathVariable Long id) {
        return ApiResult.ok((Object)this.websiteBarService.queryDetail(id));
    }

    @GetMapping(value={"/query/up/{barType}"})
    @ApiOperation(value="\u83b7\u53d6\u4e0a\u7ea7\u680f\u76ee")
    public ApiResult<List<UpBarRespVO>> queryUpBar(@PathVariable String barType) {
        return ApiResult.ok(this.websiteBarService.queryUpBar(barType));
    }

    public WebsiteBarController(WebsiteBarService websiteBarService) {
        this.websiteBarService = websiteBarService;
    }
}

