/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.ucenter.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.dto.req.msg.MsgRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.MsgSendEmployeeUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.custom.EmployeeSendParamDTO;
import com.elitescloud.cloudt.system.dto.req.msg.custom.EmployeeSentMsgParamDTO;
import com.elitescloud.cloudt.system.param.SysMsgViewResultDTO;
import com.elitescloud.cloudt.system.service.SysMsgCustomSendRpcService;
import com.elitescloud.cloudt.system.service.SysMsgInteriorRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.ucenter.api.vo.param.MessagePagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.MessageReceiverPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.PublishParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.AttachFileInfoVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.MessageDetailRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.MessageReceiverRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.MessageRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.FileInfoSaveVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.MessageSaveVO;
import com.elitescloud.cloudt.ucenter.common.constant.UdcEnum;
import com.elitescloud.cloudt.ucenter.convert.MessageManageConvert;
import com.elitescloud.cloudt.ucenter.entity.FileInfoDO;
import com.elitescloud.cloudt.ucenter.entity.MessageInfoDO;
import com.elitescloud.cloudt.ucenter.entity.MessageReceiverDO;
import com.elitescloud.cloudt.ucenter.repo.FileInfoRepo;
import com.elitescloud.cloudt.ucenter.repo.MessageInfoRepo;
import com.elitescloud.cloudt.ucenter.repo.MessageInfoRepoProc;
import com.elitescloud.cloudt.ucenter.repo.MessageReceiverRepo;
import com.elitescloud.cloudt.ucenter.repo.MessageReceiverRepoProc;
import com.elitescloud.cloudt.ucenter.service.MessageManageService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessageManageServiceImpl
implements MessageManageService {
    private static final Logger log = LoggerFactory.getLogger(MessageManageServiceImpl.class);
    private final MessageInfoRepo messageInfoRepo;
    private final MessageInfoRepoProc messageInfoRepoProc;
    private final MessageReceiverRepoProc messageReceiverRepoProc;
    private final MessageReceiverRepo messageReceiverRepo;
    private final SysMsgInteriorRpcService sysMsgInteriorRpcService;
    private final SysMsgCustomSendRpcService sysMsgCustomSendRpcService;
    private final FileInfoRepo fileInfoRepo;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(MessageSaveVO saveVO) {
        if (ObjectUtil.isNotNull((Object)saveVO.getId())) {
            Optional optional = this.messageInfoRepo.findById(saveVO.getId());
            if (optional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u627e\u5230\u6d88\u606f\u4fe1\u606f");
            }
            if (StrUtil.equals((CharSequence)((MessageInfoDO)optional.get()).getPublishStatus(), (CharSequence)UdcEnum.MESSAGE_CATEGORY_PUBLISH_STATUS_1.getValueCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u7f16\u8f91\u6ca1\u6709\u53d1\u5e03\u7684\u6d88\u606f");
            }
            MessageInfoDO messageInfoDO = (MessageInfoDO)optional.get();
            this.messageReceiverRepo.deleteByMessageId(messageInfoDO.getId());
            this.fileInfoRepo.deleteAllBySourceId(messageInfoDO.getId());
        }
        MessageInfoDO messageInfoDO = MessageManageConvert.INSTANCE.messageSaveVo2Do(saveVO);
        messageInfoDO.setTotalCount(saveVO.getReceiverList().size());
        MessageInfoDO saveDo = (MessageInfoDO)this.messageInfoRepo.save(messageInfoDO);
        List<FileInfoSaveVO> fileList = saveVO.getFileCodeList();
        List<FileInfoDO> fileInfoDoList = MessageManageConvert.INSTANCE.fileVos2Dos(fileList);
        fileInfoDoList.stream().forEach(item -> item.setSourceId(saveDo.getId()).setSourceType("\u81ea\u5b9a\u4e49\u6d88\u606f\u8868"));
        this.fileInfoRepo.saveAll(fileInfoDoList);
        List<MessageReceiverDO> receiverDOList = MessageManageConvert.INSTANCE.receiverVos2Dos(saveVO.getReceiverList());
        receiverDOList.stream().forEach(item -> item.setMessageId(saveDo.getId()));
        this.messageReceiverRepo.saveAll(receiverDOList);
        if (StrUtil.equals((CharSequence)saveVO.getPublishStatus(), (CharSequence)UdcEnum.MESSAGE_CATEGORY_PUBLISH_STATUS_1.getValueCode())) {
            PublishParam param = new PublishParam();
            param.setMessageId(saveDo.getId());
            param.setImmediatelyPublish(Boolean.TRUE);
            try {
                this.publish(param);
            }
            catch (Exception e) {
                log.error("saveOrUpdate \u7acb\u5373\u53d1\u5e03\u5931\u8d25\uff0c\u53c2\u6570 {} , \u5931\u8d25\u539f\u56e0\uff1a{} \t \u5931\u8d25\u4fe1\u606f\uff1a{}", new Object[]{saveVO, e.getMessage(), e});
                throw new BusinessException("\u7acb\u5373\u53d1\u5e03\u5931\u8d25\uff01\u8bf7\u7a0d\u540e\u53d1\u5e03");
            }
        }
        return saveDo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Object delete(List<Long> ids) {
        List messageInfoList = this.messageInfoRepo.findAllById(ids);
        if (CollectionUtil.isEmpty((Collection)messageInfoList)) {
            return null;
        }
        List<Long> publishIdList = messageInfoList.stream().filter(item -> ObjectUtil.equals((Object)item.getPublishStatus(), (Object)UdcEnum.MESSAGE_CATEGORY_PUBLISH_STATUS_1.getValueCode())).map(item -> item.getId()).collect(Collectors.toList());
        List unPublishIdList = messageInfoList.stream().filter(item -> ObjectUtil.equals((Object)item.getPublishStatus(), (Object)UdcEnum.MESSAGE_CATEGORY_PUBLISH_STATUS_0.getValueCode())).map(item -> item.getId()).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(publishIdList)) {
            this.messageInfoRepo.updateByIdInBatch(publishIdList);
            this.fileInfoRepo.updateByMessageIdInBatch(publishIdList);
            this.messageReceiverRepo.updateByMessageIdInBatch(publishIdList);
        }
        if (CollectionUtil.isNotEmpty(unPublishIdList)) {
            this.messageInfoRepo.deleteAllByIdInBatch(unPublishIdList);
            this.fileInfoRepo.deleteByMessageIdInBatch(publishIdList);
            this.messageReceiverRepo.deleteByMessageIdInBatch(publishIdList);
        }
        return null;
    }

    @Override
    @SysCodeProc
    @Transactional(rollbackFor={Exception.class})
    public PagingVO<MessageRespVO> search(MessagePagingParam param) {
        PagingVO<MessageRespVO> results = this.messageInfoRepoProc.search(param);
        List records = results.getRecords();
        if (CollectionUtil.isNotEmpty((Collection)records)) {
            List<MessageInfoDO> vos = MessageManageConvert.INSTANCE.messageRespVos2Dos(records);
            List publishList = vos.stream().filter(item -> StrUtil.equals((CharSequence)item.getPublishStatus(), (CharSequence)UdcEnum.MESSAGE_CATEGORY_PUBLISH_STATUS_1.getValueCode())).collect(Collectors.toList());
            try {
                publishList.stream().forEach(item -> this.updateReceiverReadStatus((MessageInfoDO)item));
                Map<Long, Integer> map = publishList.stream().collect(Collectors.toMap(BaseModel::getId, MessageInfoDO::getReadCount));
                results.getRecords().stream().forEach(item -> item.setReadCount((Integer)map.get(item.getId())));
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u9605\u8bfb\u72b6\u6001\u5931\u8d25,\u5931\u8d25\u539f\u56e0 {}\uff0c {}", (Object)e.getMessage(), (Object)e.getCause());
            }
        }
        return results;
    }

    @Override
    @SysCodeProc
    public MessageDetailRespVO queryDetail(Long id) {
        Optional byId = this.messageInfoRepo.findById(id);
        if (byId.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u6d88\u606f\u8be6\u60c5\u4fe1\u606f");
        }
        List<MessageReceiverDO> receiverDoList = this.messageReceiverRepo.findAllByMessageId(id);
        List<MessageReceiverRespVO> receiverRespVOList = MessageManageConvert.INSTANCE.receiverDos2Vos(receiverDoList);
        MessageDetailRespVO respVO = MessageManageConvert.INSTANCE.messageDo2Vo((MessageInfoDO)byId.get());
        List<FileInfoDO> doList = this.fileInfoRepo.findAllBySourceId(id);
        List<AttachFileInfoVO> attachFileInfoVOS = MessageManageConvert.INSTANCE.fileDos2Vos(doList);
        respVO.setFileInfoList(attachFileInfoVOS);
        respVO.setReceiverList(receiverRespVOList);
        return respVO;
    }

    @Override
    public PagingVO<MessageReceiverRespVO> searchReceiver(MessageReceiverPagingParam param) {
        Optional byId = this.messageInfoRepo.findById(param.getMessageId());
        if (byId.isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u81ea\u5b9a\u4e49\u6d88\u606f\u7684\u4fe1\u606f\uff01");
        }
        try {
            this.updateReceiverReadStatus((MessageInfoDO)byId.get());
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u9605\u8bfb\u72b6\u6001\u5931\u8d25,\u5931\u8d25\u539f\u56e0 {}\uff0c {}", (Object)e.getMessage(), (Object)e.getCause());
        }
        PagingVO<MessageReceiverRespVO> pagingVO = this.messageReceiverRepoProc.search(param);
        return pagingVO;
    }

    @Transactional(rollbackFor={Exception.class})
    MessageInfoDO updateReceiverReadStatus(MessageInfoDO messageInfoDO) {
        List<MessageReceiverDO> receiverDOList = this.messageReceiverRepo.findAllByMessageId(messageInfoDO.getId());
        if (CollectionUtil.isEmpty(receiverDOList)) {
            return null;
        }
        List unReadList = receiverDOList.stream().filter(item -> StrUtil.equals((CharSequence)item.getReadStatus(), (CharSequence)UdcEnum.MESSAGE_CATEGORY_READ_STATUS_0.getValueCode())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(unReadList)) {
            List data;
            ApiResult viewedResult = null;
            try {
                viewedResult = this.sysMsgInteriorRpcService.getViewedResult(messageInfoDO.getRecordId());
                if (ObjectUtil.notEqual((Object)viewedResult.getCode(), (Object)ApiCode.SUCCESS.getCode())) {
                    log.error("publish \u8c03\u7528\u7cfb\u7edf\u57df\u53d1\u9001\u81ea\u5b9a\u4e49\u6d88\u606f\u5931\u8d25 \u5931\u8d25\u539f\u56e0:{} ", (Object)viewedResult.getErrorMsg());
                    throw new BusinessException(viewedResult.getMsg());
                }
                data = (List)viewedResult.getData();
            }
            catch (Exception e) {
                log.error("\u8fdc\u7a0b\u8c03\u7528\u7cfb\u7edf\u57df\u53d1\u9001\u6d88\u606f\u76f8\u5173\u670d\u52a1\u5f02\u5e38:{} ", (Throwable)e);
                throw new BusinessException("\u8fdc\u7a0b\u8c03\u7528\u7cfb\u7edf\u57df\u53d1\u9001\u81ea\u5b9a\u4e49\u6d88\u606f\u63a5\u53e3\u5931\u8d25", (Throwable)e);
            }
            if (CollectionUtil.isNotEmpty((Collection)data)) {
                Map<Long, SysMsgViewResultDTO> map = data.stream().collect(Collectors.toMap(SysMsgViewResultDTO::getUserId, t -> t, (t1, t2) -> t1));
                unReadList.stream().forEach(item -> {
                    SysMsgViewResultDTO dto = (SysMsgViewResultDTO)map.get(item.getEmpId());
                    item.setReadStatus(dto.getViewed() != false ? UdcEnum.MESSAGE_CATEGORY_READ_STATUS_1.getValueCode() : UdcEnum.MESSAGE_CATEGORY_READ_STATUS_0.getValueCode());
                    item.setReadTime(dto.getViewTime());
                });
                List readList = unReadList.stream().filter(item -> StrUtil.equals((CharSequence)item.getReadStatus(), (CharSequence)UdcEnum.MESSAGE_CATEGORY_READ_STATUS_1.getValueCode())).collect(Collectors.toList());
                this.messageReceiverRepo.saveAll(unReadList);
                messageInfoDO.setReadCount(messageInfoDO.getReadCount() + readList.size());
                this.messageInfoRepo.updateReadCount(messageInfoDO.getReadCount(), messageInfoDO.getId());
            }
        }
        return messageInfoDO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Object publish(PublishParam param) {
        EmployeeSendParamDTO dto = this.getEmployeeSendParamDTO(param);
        String recordId = null;
        try {
            ApiResult apiResult = this.sysMsgCustomSendRpcService.msgCustomEmployeeSend(dto);
            log.info("publish\u65b9\u6cd5\u8c03\u7528\u7cfb\u7edf\u57df\u53d1\u9001\u81ea\u5b9a\u4e49\u6d88\u606f\u8fd4\u56de\u7684\u7ed3\u679c\uff1a{}", (Object)apiResult);
            if (ObjectUtil.notEqual((Object)apiResult.getCode(), (Object)ApiCode.SUCCESS.getCode())) {
                log.error("publish\u81ea\u5b9a\u4e49\u53d1\u5e03\u6d88\u606f \u8c03\u7528\u7cfb\u7edf\u57df\u53d1\u9001\u81ea\u5b9a\u4e49\u6d88\u606f\u5931\u8d25 \u5931\u8d25\u539f\u56e0:{} ", (Object)apiResult.getErrorMsg());
                throw new BusinessException(apiResult.getMsg());
            }
            recordId = (String)apiResult.getData();
        }
        catch (Exception e) {
            log.error("\u8fdc\u7a0b\u8c03\u7528\u7cfb\u7edf\u57df\u53d1\u9001\u6d88\u606f\u76f8\u5173\u670d\u52a1\u5f02\u5e38:{} ", (Throwable)e);
            throw new BusinessException("\u8fdc\u7a0b\u8c03\u7528\u7cfb\u7edf\u57df\u53d1\u9001\u81ea\u5b9a\u4e49\u6d88\u606f\u63a5\u53e3\u5931\u8d25");
        }
        this.messageInfoRepo.updateById(param.getMessageId(), recordId, UdcEnum.MESSAGE_CATEGORY_PUBLISH_STATUS_1.getValueCode());
        this.messageReceiverRepo.updateReadStatusByMessageId(param.getMessageId());
        return recordId;
    }

    @NotNull
    private EmployeeSendParamDTO getEmployeeSendParamDTO(PublishParam param) {
        EmployeeSendParamDTO dto = new EmployeeSendParamDTO();
        SysUserDTO user = new SysUserDTO();
        try {
            user = SecurityContextUtil.currentUser().getUser();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u767b\u5f55\u4eba\u4fe1\u606f\u5931\u8d25{}", (Throwable)e);
        }
        Optional byId = this.messageInfoRepo.findById(param.getMessageId());
        if (byId.isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u81ea\u5b9a\u4e49\u6d88\u606f\u4fe1\u606f\uff01");
        }
        if (ObjectUtil.equals((Object)param.getImmediatelyPublish(), (Object)Boolean.FALSE) && StrUtil.equals((CharSequence)((MessageInfoDO)byId.get()).getPublishStatus(), (CharSequence)UdcEnum.MESSAGE_CATEGORY_PUBLISH_STATUS_1.getValueCode())) {
            throw new BusinessException("\u8be5\u81ea\u5b9a\u4e49\u6d88\u606f\u5df2\u7ecf\u53d1\u5e03\uff0c\u8bf7\u52ff\u91cd\u590d\u53d1\u5e03\uff01");
        }
        MsgSendEmployeeUserDTO sendUser = new MsgSendEmployeeUserDTO();
        sendUser.setUserId(user.getId());
        sendUser.setUserName(user.getLastName());
        sendUser.setUserCode(user.getUsername());
        List<MessageReceiverDO> receiverDOList = this.messageReceiverRepo.findAllByMessageId(param.getMessageId());
        if (CollectionUtil.isEmpty(receiverDOList)) {
            throw new BusinessException("\u8be5\u81ea\u5b9a\u4e49\u6d88\u606f\u8fd8\u672a\u9009\u62e9\u63a5\u6536\u4eba\uff0c\u8bf7\u9009\u62e9\u53c2\u4e0e\u4eba\u540e\u8fdb\u884c\u53d1\u5e03");
        }
        List msgRecipientUserDTOS = receiverDOList.stream().map(item -> {
            MsgRecipientUserDTO msgRecipientUser = new MsgRecipientUserDTO();
            msgRecipientUser.setUserId(item.getEmpId());
            msgRecipientUser.setUserName(item.getEmpName());
            return msgRecipientUser;
        }).collect(Collectors.toList());
        ArrayList<EmployeeSentMsgParamDTO> sendTypeMessageMap = new ArrayList<EmployeeSentMsgParamDTO>();
        EmployeeSentMsgParamDTO sentMsgParamDTO = new EmployeeSentMsgParamDTO();
        sentMsgParamDTO.setMsgSendTypeEnum(MsgSendTypeEnum.SYS_INTERIOR);
        sentMsgParamDTO.setTitle(((MessageInfoDO)byId.get()).getMessageTitle());
        sentMsgParamDTO.setContent(((MessageInfoDO)byId.get()).getMessageDetail());
        sentMsgParamDTO.setExternalTemplateParams(new HashMap());
        sendTypeMessageMap.add(sentMsgParamDTO);
        dto.setSendUser(sendUser);
        dto.setMsgRecipientUserDTO(msgRecipientUserDTOS);
        dto.setSendTypeMessageMap(sendTypeMessageMap);
        HashMap<String, String> mesJoinParamMap = new HashMap<String, String>();
        mesJoinParamMap.put("msgType", "files");
        List<FileInfoDO> fileList = this.fileInfoRepo.findAllBySourceId(((MessageInfoDO)byId.get()).getId());
        if (CollectionUtil.isNotEmpty(fileList)) {
            fileList.stream().forEach(item -> mesJoinParamMap.put(item.getFileCode(), item.getOriginalName()));
        }
        dto.setMesJoinParamMap(mesJoinParamMap);
        return dto;
    }

    public MessageManageServiceImpl(MessageInfoRepo messageInfoRepo, MessageInfoRepoProc messageInfoRepoProc, MessageReceiverRepoProc messageReceiverRepoProc, MessageReceiverRepo messageReceiverRepo, SysMsgInteriorRpcService sysMsgInteriorRpcService, SysMsgCustomSendRpcService sysMsgCustomSendRpcService, FileInfoRepo fileInfoRepo) {
        this.messageInfoRepo = messageInfoRepo;
        this.messageInfoRepoProc = messageInfoRepoProc;
        this.messageReceiverRepoProc = messageReceiverRepoProc;
        this.messageReceiverRepo = messageReceiverRepo;
        this.sysMsgInteriorRpcService = sysMsgInteriorRpcService;
        this.sysMsgCustomSendRpcService = sysMsgCustomSendRpcService;
        this.fileInfoRepo = fileInfoRepo;
    }
}

