/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.ucenter.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.dto.ReceiptSourceConfigDTO;
import com.elitescloud.cloudt.ucenter.api.dto.ReceiptSourceConfigDetailDTO;
import com.elitescloud.cloudt.ucenter.api.vo.param.GenerateTableParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.ReceiptSourceConfigPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.ReceiptSourceConfigDetailPagingRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.ReceiptSourceConfigPagingRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.ReceiptSourceConfigSaveVO;
import com.elitescloud.cloudt.ucenter.convert.ReceiptSourceConfigConvert;
import com.elitescloud.cloudt.ucenter.convert.ReceiptSourceConfigDetailConvert;
import com.elitescloud.cloudt.ucenter.entity.ReceiptSourceConfigDO;
import com.elitescloud.cloudt.ucenter.entity.ReceiptSourceConfigDetailDO;
import com.elitescloud.cloudt.ucenter.repo.ReceiptSourceConfigDetailRepo;
import com.elitescloud.cloudt.ucenter.repo.ReceiptSourceConfigDetailRepoProc;
import com.elitescloud.cloudt.ucenter.repo.ReceiptSourceConfigRepo;
import com.elitescloud.cloudt.ucenter.repo.ReceiptSourceConfigRepoProc;
import com.elitescloud.cloudt.ucenter.service.ReceiptSourceConfigService;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class ReceiptSourceConfigServiceImpl
implements ReceiptSourceConfigService {
    private static final Logger log = LoggerFactory.getLogger(ReceiptSourceConfigServiceImpl.class);
    private final ReceiptSourceConfigRepo receiptSourceConfigRepo;
    private final ReceiptSourceConfigRepoProc configRepoProc;
    private final ReceiptSourceConfigDetailRepo configDetailRepo;
    private final ReceiptSourceConfigDetailRepoProc configDetailRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ReceiptSourceConfigPagingRespVO> searchPaging(ReceiptSourceConfigPagingParam param) {
        PagingVO<ReceiptSourceConfigDTO> pagingDto = this.configRepoProc.searchPaging(param);
        return ReceiptSourceConfigConvert.INSTANCE.dto2PagingVo(pagingDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ReceiptSourceConfigSaveVO saveVO) {
        if (ObjectUtil.isNull((Object)saveVO.getId())) {
            if (this.receiptSourceConfigRepo.existsBySourceNo(saveVO.getSourceNo())) {
                throw new BusinessException("\u6765\u6e90\u5355\u53f7\u5df2\u5b58\u5728");
            }
            if (StrUtil.isNotBlank((CharSequence)saveVO.getParamValue())) {
                throw new BusinessException("\u8bf7\u751f\u6210\u8868\u4f53\u4e4b\u540e\u518d\u4fdd\u5b58\u63a5\u53e3\u53c2\u6570\u4fe1\u606f");
            }
        } else {
            Optional byId = this.receiptSourceConfigRepo.findById(saveVO.getId());
            if (byId.isEmpty()) {
                throw new BusinessException("\u6ca1\u6709\u67e5\u8be2\u5230\u6765\u6e90\u5355\u636e\u914d\u7f6e");
            }
            this.checkParamValue(saveVO);
        }
        ReceiptSourceConfigDO receiptSourceConfigDO = ReceiptSourceConfigConvert.INSTANCE.SourceConfigSaveVo2Do(saveVO);
        ReceiptSourceConfigDO save = (ReceiptSourceConfigDO)this.receiptSourceConfigRepo.save(receiptSourceConfigDO);
        return save.getId();
    }

    private void checkParamValue(ReceiptSourceConfigSaveVO saveVO) {
        if (StrUtil.isNotBlank((CharSequence)saveVO.getParamValue())) {
            List<ReceiptSourceConfigDetailDO> detailDOS = this.configDetailRepo.findByMasId(saveVO.getId());
            if (CollectionUtil.isEmpty(detailDOS)) {
                throw new BusinessException("\u8bf7\u751f\u6210\u8868\u4f53\u4e4b\u540e\u518d\u4fdd\u5b58\u63a5\u53e3\u53c2\u6570\u4fe1\u606f");
            }
            Map map = Map.of();
            try {
                map = (Map)JSONUtil.toBean((String)saveVO.getParamValue(), Map.class);
            }
            catch (Exception e) {
                log.error("\u89e3\u6790\u63a5\u53e3\u53c2\u6570\u51fa\u9519\uff1a{}", (Object)e.getMessage());
                throw new BusinessException("\u89e3\u6790\u63a5\u53e3\u53c2\u6570\u51fa\u9519");
            }
            if (map.entrySet().size() > detailDOS.size()) {
                throw new BusinessException("\u63a5\u53e3\u53c2\u6570\u6570\u91cf\u5927\u4e8e\u914d\u7f6e\u660e\u7ec6\u6570\u91cf");
            }
            List collect = detailDOS.stream().map(detail -> detail.getFieldName()).collect(Collectors.toList());
            Iterator paramKey = map.keySet().iterator();
            ArrayList<CallSite> errorList = new ArrayList<CallSite>();
            while (paramKey.hasNext()) {
                String paramStr = (String)paramKey.next();
                if (collect.contains(paramStr)) continue;
                errorList.add((CallSite)((Object)("\u53c2\u6570{" + paramStr + "}\u6ca1\u6709\u900f\u51fa\u5b57\u6bb5\u5339\u914d")));
            }
            if (CollectionUtil.isNotEmpty(errorList)) {
                throw new BusinessException(((Object)errorList).toString());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Object delete(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return ids;
        }
        List receiptSourceConfigDOList = this.receiptSourceConfigRepo.findAllById(ids);
        if (CollectionUtil.isEmpty((Collection)receiptSourceConfigDOList)) {
            return ids;
        }
        List<String> sourceNoList = receiptSourceConfigDOList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceNo())).map(item -> item.getSourceNo()).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(sourceNoList)) {
            this.configDetailRepo.deleteAllBySourceNoIn(sourceNoList);
        }
        this.receiptSourceConfigRepo.deleteAllById(ids);
        return ids;
    }

    @Override
    @SysCodeProc
    public PagingVO<ReceiptSourceConfigDetailPagingRespVO> detailSearchPaging(ReceiptSourceConfigPagingParam param) {
        PagingVO<ReceiptSourceConfigDetailDTO> pagingDto = this.configDetailRepoProc.detailSearchPaging(param);
        return ReceiptSourceConfigDetailConvert.INSTANCE.dto2PagingVo(pagingDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Object generateTable(GenerateTableParam param) {
        if (StrUtil.isNotBlank((CharSequence)param.getTableDetail())) {
            Map map = null;
            try {
                map = (Map)JSONUtil.toBean((String)param.getTableDetail(), Map.class);
            }
            catch (Exception e) {
                log.error("\u89e3\u6790\u8868\u4f53\u5185\u5bb9\u51fa\u9519\uff1a{}", (Object)e.getMessage());
                throw new BusinessException("\u89e3\u6790\u8868\u4f53\u5185\u5bb9\u5f02\u5e38");
            }
            ArrayList detailDOS = new ArrayList();
            map.forEach((key, value) -> {
                ReceiptSourceConfigDetailDO detailDO = new ReceiptSourceConfigDetailDO();
                detailDO.setFieldName((String)key);
                detailDO.setFieldDefinition((String)value);
                detailDO.setSourceNo(param.getSourceNo());
                detailDO.setMasId(param.getMasId());
                detailDOS.add(detailDO);
            });
            this.configDetailRepo.saveAll(detailDOS);
        }
        return null;
    }

    @Override
    public Object test(String sourceNo) {
        ReceiptSourceConfigDO configDO = this.receiptSourceConfigRepo.findBySourceNo(sourceNo);
        if (ObjectUtil.isNull((Object)configDO)) {
            throw new BusinessException("\u6ca1\u67e5\u8be2\u5230\u914d\u7f6e\u4fe1\u606f");
        }
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        String token = "Bearer " + SecurityContextUtil.currentToken();
        headers.add("Authorization", token);
        headers.add("Content-Type", "application/json");
        String paramValue = configDO.getParamValue();
        JSON jsonStr = JSONUtil.parse((Object)paramValue);
        try {
            ResponseEntity responseEntity = restTemplate.postForEntity(configDO.getConnectUrl(), (Object)new HttpEntity((Object)jsonStr, (MultiValueMap)headers), Object.class, new Object[0]);
            return responseEntity.getBody();
        }
        catch (RestClientException e) {
            log.error("\u8c03\u7528\u51fa\u9519 {}", (Object)e.getMessage());
            throw new BusinessException("\u901a\u7528\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
    }

    public ReceiptSourceConfigServiceImpl(ReceiptSourceConfigRepo receiptSourceConfigRepo, ReceiptSourceConfigRepoProc configRepoProc, ReceiptSourceConfigDetailRepo configDetailRepo, ReceiptSourceConfigDetailRepoProc configDetailRepoProc) {
        this.receiptSourceConfigRepo = receiptSourceConfigRepo;
        this.configRepoProc = configRepoProc;
        this.configDetailRepo = configDetailRepo;
        this.configDetailRepoProc = configDetailRepoProc;
    }
}

