/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.ucenter.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.ucenter.api.vo.resp.WebsiteAppearanceVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.WebsiteAppearanceSaveVO;
import com.elitescloud.cloudt.ucenter.convert.WebsiteAppearanceConvert;
import com.elitescloud.cloudt.ucenter.entity.WebsiteAppearanceDO;
import com.elitescloud.cloudt.ucenter.repo.WebsiteAppearanceRepo;
import com.elitescloud.cloudt.ucenter.repo.WebsiteAppearanceRepoProc;
import com.elitescloud.cloudt.ucenter.service.WebsiteAppearanceService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WebsiteAppearanceServiceImpl
implements WebsiteAppearanceService {
    private final WebsiteAppearanceRepo appearanceRepo;
    private final WebsiteAppearanceRepoProc appearanceRepoProc;

    @Override
    @SysCodeProc
    public WebsiteAppearanceVO findByType(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            throw new BusinessException("\u7f51\u7ad9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return WebsiteAppearanceConvert.INSTANCE.do2Vo(this.appearanceRepo.findByType(type));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(WebsiteAppearanceSaveVO appearanceSaveVO) {
        if (StringUtils.isEmpty((CharSequence)appearanceSaveVO.getType())) {
            throw new BusinessException("\u7f51\u7ad9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (appearanceSaveVO.getType().endsWith("_APP")) {
            if (StringUtils.isEmpty((CharSequence)appearanceSaveVO.getBrowserLogoId())) {
                throw new BusinessException("\u767b\u9646\u9875icon\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            if (StringUtils.isEmpty((CharSequence)appearanceSaveVO.getBrowserLogoId())) {
                throw new BusinessException("\u6d4f\u89c8\u5668logo\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)appearanceSaveVO.getWebpageLogoId())) {
                throw new BusinessException("\u7f51\u9875logo\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)appearanceSaveVO.getMenuUnfoldFlag())) {
                throw new BusinessException("\u83dc\u5355\u5c55\u5f00\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)appearanceSaveVO.getMenuWidth())) {
                throw new BusinessException("\u83dc\u5355\u533a\u57df\u5bbd\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (ObjectUtils.isEmpty((Object)appearanceSaveVO.getId())) {
            if (this.appearanceRepo.existsByType(appearanceSaveVO.getType()).booleanValue()) {
                throw new BusinessException("\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u8be5\u7c7b\u578b\u7f51\u7ad9\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        } else if (!this.appearanceRepo.existsById(appearanceSaveVO.getId())) {
            throw new BusinessException("id\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        WebsiteAppearanceDO appearanceDO = (WebsiteAppearanceDO)this.appearanceRepo.save(WebsiteAppearanceConvert.INSTANCE.saveVo2Do(appearanceSaveVO));
        return appearanceDO.getId();
    }

    @Override
    @SysCodeProc
    public WebsiteAppearanceVO findById(Long id) {
        WebsiteAppearanceDO appearanceDO = (WebsiteAppearanceDO)this.appearanceRepo.findById(id).orElseThrow(new BusinessException("id\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01"));
        return WebsiteAppearanceConvert.INSTANCE.do2Vo(appearanceDO);
    }

    public WebsiteAppearanceServiceImpl(WebsiteAppearanceRepo appearanceRepo, WebsiteAppearanceRepoProc appearanceRepoProc) {
        this.appearanceRepo = appearanceRepo;
        this.appearanceRepoProc = appearanceRepoProc;
    }
}

