/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.ucenter.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.dto.WebsiteBarDTO;
import com.elitescloud.cloudt.ucenter.api.vo.param.WebsiteBarPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.WebsiteBarShowParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.WebsiteBarSortParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.UpBarRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.WebsiteBarRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.WebsiteBarSaveVO;
import com.elitescloud.cloudt.ucenter.common.constant.UdcEnum;
import com.elitescloud.cloudt.ucenter.convert.WebsiteBarConvert;
import com.elitescloud.cloudt.ucenter.entity.WebsiteBarDO;
import com.elitescloud.cloudt.ucenter.repo.WebsiteBarRepo;
import com.elitescloud.cloudt.ucenter.repo.WebsiteBarRepoProc;
import com.elitescloud.cloudt.ucenter.service.WebsiteBarService;
import com.elitescloud.cloudt.ucenter.utils.SysGenerator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WebsiteBarServiceImpl
implements WebsiteBarService {
    private static final Logger log = LoggerFactory.getLogger(WebsiteBarServiceImpl.class);
    private final WebsiteBarRepo websiteBarRepo;
    private final WebsiteBarRepoProc websiteBarRepoProc;
    private final SysGenerator sysGenerator;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(WebsiteBarSaveVO saveVO) {
        Optional parentBar;
        if (ObjectUtil.isNull((Object)saveVO.getId())) {
            if (StrUtil.equalsAny((CharSequence)saveVO.getBarType(), (CharSequence[])new CharSequence[]{UdcEnum.WS_WEBSITE_BAR_TYPE_NAV.getValueCode(), UdcEnum.WS_WEBSITE_BAR_TYPE_BOTTOM.getValueCode()})) {
                if (StrUtil.isEmpty((CharSequence)saveVO.getWindowOpenMode())) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6253\u5f00\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StrUtil.isEmpty((CharSequence)saveVO.getBarType())) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u680f\u4f4d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (!StrUtil.equals((CharSequence)saveVO.getLinkType(), (CharSequence)UdcEnum.WS_LINK_TYPE_EXTERNAL.getValueCode()) && StrUtil.isBlank((CharSequence)saveVO.getTargetType())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u76ee\u6807\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String barCode = this.sysGenerator.generateCode("BAR_NO");
            if (this.websiteBarRepo.existsByBarCode(barCode)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u751f\u6210\u7684\u680f\u76ee\u7f16\u53f7\uff1a" + barCode + " \u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53d1\u53f7\u5668\u914d\u7f6e\u662f\u5426\u6b63\u786e");
            }
            saveVO.setBarCode(barCode);
        } else {
            List<WebsiteBarDO> doList = this.websiteBarRepo.findByPid(saveVO.getId());
            Optional byId = this.websiteBarRepo.findById(saveVO.getId());
            if (byId.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6ca1\u6709\u67e5\u8be2\u5230\u680f\u76ee\u4fe1\u606f");
            }
            WebsiteBarDO websiteBarDO = (WebsiteBarDO)byId.get();
            if (ObjectUtil.equals((Object)websiteBarDO.getShowFlag(), (Object)Boolean.TRUE)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u652f\u6301\u7f16\u8f91\u663e\u793a\u72b6\u6001\u4e3a\u5426\u7684\u680f\u76ee");
            }
            if (StrUtil.equals((CharSequence)websiteBarDO.getBarType(), (CharSequence)UdcEnum.WS_WEBSITE_BAR_TYPE_NAV.getValueCode()) && CollectionUtil.isNotEmpty(doList)) {
                if (!StrUtil.equals((CharSequence)saveVO.getBarType(), (CharSequence)UdcEnum.WS_WEBSITE_BAR_TYPE_NAV.getValueCode())) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8be5\u680f\u76ee\u4e0b\u6709\u5b50\u5bfc\u822a\u680f\uff0c\u4e0d\u80fd\u4fee\u6539\u4f4d\u7f6e\u4fe1\u606f");
                }
                if (ObjectUtil.isNotNull((Object)saveVO.getPid())) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8be5\u680f\u76ee\u6709\u5b50\u5bfc\u822a\u680f\uff0c\u4e0d\u80fd\u66f4\u6539\u4e0a\u7ea7\u680f\u76ee");
                }
                this.websiteBarRepo.updatePNameByPid(websiteBarDO.getId(), saveVO.getBarName());
            }
            if (ObjectUtil.equals((Object)websiteBarDO.getHomePageFlag(), (Object)Boolean.FALSE)) {
                // empty if block
            }
            saveVO.setPid(websiteBarDO.getPid());
        }
        WebsiteBarDO websiteBarDO = WebsiteBarConvert.INSTANCE.saveVo2Do(saveVO);
        if (ObjectUtil.isNotNull((Object)saveVO.getPid()) && (parentBar = this.websiteBarRepo.findById(saveVO.getPid())).isPresent()) {
            websiteBarDO.setPName(((WebsiteBarDO)parentBar.get()).getBarName());
        }
        WebsiteBarDO save = (WebsiteBarDO)this.websiteBarRepo.save(websiteBarDO);
        return save.getId();
    }

    private void checkHomePageFlag(WebsiteBarSaveVO saveVO) {
        WebsiteBarDO websiteBarDO;
        if (ObjectUtil.equals((Object)saveVO.getHomePageFlag(), (Object)Boolean.TRUE) && StrUtil.equals((CharSequence)saveVO.getBarType(), (CharSequence)UdcEnum.WS_WEBSITE_BAR_TYPE_NAV.getValueCode()) && ObjectUtil.isNotNull((Object)(websiteBarDO = this.websiteBarRepo.findByHomePageFlag(Boolean.TRUE)))) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u822a\u680f\u53ea\u80fd\u6709\u4e00\u4e2a\u9996\u9875");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Object showUpdate(WebsiteBarShowParam param) {
        this.websiteBarRepo.updateShowFlagByPid(param.getIds(), param.getShowFlag());
        return this.websiteBarRepo.updateShowFlagByIdIn(param.getIds(), param.getShowFlag());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Object sortUpdate(WebsiteBarSortParam param) {
        return this.websiteBarRepo.updateSortNoById(param.getId(), param.getSortNo());
    }

    @Override
    @SysCodeProc
    public WebsiteBarRespVO queryDetail(Long id) {
        Optional byId = this.websiteBarRepo.findById(id);
        if (byId.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6ca1\u6709\u5bf9\u5e94\u7684\u7f51\u7ad9\u680f\u76ee\u8be6\u60c5");
        }
        return WebsiteBarConvert.INSTANCE.do2DetailRespVo((WebsiteBarDO)byId.get());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Object batchDeleteByIds(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5220\u9664\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<WebsiteBarDO> doList = this.websiteBarRepo.findByIdIn(ids);
        List homePageList = doList.stream().filter(item -> ObjectUtil.equals((Object)item.getHomePageFlag(), (Object)Boolean.TRUE)).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(homePageList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e0d\u80fd\u5220\u9664\u9996\u9875\u680f\u76ee");
        }
        List showList = doList.stream().filter(item -> ObjectUtil.equals((Object)item.getShowFlag(), (Object)Boolean.TRUE)).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(showList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u5220\u9664\u663e\u793a\u72b6\u6001\u4e3a\u5426\u7684\u680f\u76ee");
        }
        Integer count = this.websiteBarRepo.deleteByIdIn(ids);
        this.websiteBarRepo.deleteByParentIdIn(ids);
        return count;
    }

    @Override
    @SysCodeProc
    public PagingVO<WebsiteBarRespVO> search(WebsiteBarPagingParam param) {
        List<WebsiteBarDTO> dtoList = this.websiteBarRepoProc.findAll(param);
        List parentDtoList = dtoList.stream().filter(item -> ObjectUtil.isNull((Object)item.getPid())).distinct().collect(Collectors.toList());
        List<WebsiteBarDTO> childDtoList = dtoList.stream().filter(item -> ObjectUtil.isNotNull((Object)item.getPid())).distinct().collect(Collectors.toList());
        Set<Long> parentIdList1 = parentDtoList.stream().map(item -> item.getId()).collect(Collectors.toSet());
        Set parentIdList2 = childDtoList.stream().map(item -> item.getPid()).collect(Collectors.toSet());
        parentIdList1.addAll(parentIdList2);
        param.setPidSet(parentIdList1);
        PagingVO<WebsiteBarDTO> parentPage = this.websiteBarRepoProc.search(param);
        List<WebsiteBarRespVO> parentList = WebsiteBarConvert.INSTANCE.barDTOsToVos(parentPage.getRecords());
        if (CollectionUtil.isNotEmpty(childDtoList)) {
            List<WebsiteBarRespVO> childList = WebsiteBarConvert.INSTANCE.barDTOsToVos(childDtoList);
            Map<Long, List<WebsiteBarRespVO>> childMap = childList.stream().collect(Collectors.groupingBy(WebsiteBarRespVO::getPid));
            for (WebsiteBarRespVO websiteBarRespVO : childList) {
                websiteBarRespVO.setBarTypeName(this.sysGenerator.getUdcName(UdcEnum.WS_WEBSITE_BAR_TYPE_NAV.getCode(), websiteBarRespVO.getBarType()));
                websiteBarRespVO.setTargetTypeName(this.sysGenerator.getUdcName(UdcEnum.WS_TARGET_TYPE_AD.getCode(), websiteBarRespVO.getTargetType()));
                websiteBarRespVO.setLinkTypeName(this.sysGenerator.getUdcName(UdcEnum.WS_LINK_TYPE_INTERNAL.getCode(), websiteBarRespVO.getLinkType()));
                websiteBarRespVO.setWindowOpenModeName(this.sysGenerator.getUdcName(UdcEnum.WS_WINDOW_OPEN_MODE_CURRENT.getCode(), websiteBarRespVO.getWindowOpenMode()));
                websiteBarRespVO.setMallModeName(this.sysGenerator.getUdcName(UdcEnum.WS_MALL_TYPE_PC_B.getCode(), websiteBarRespVO.getMallMode()));
            }
            for (WebsiteBarRespVO item2 : parentList) {
                List<WebsiteBarRespVO> childVoList = childMap.get(item2.getId());
                if (CollectionUtil.isNotEmpty(childVoList)) {
                    childVoList.stream().forEach(child -> child.setPName(item2.getBarName()));
                }
                item2.setChild(childVoList);
            }
        }
        return PagingVO.builder().total(parentPage.getTotal()).records(parentList).build();
    }

    @Override
    @SysCodeProc
    public List<UpBarRespVO> queryUpBar(String barType) {
        if (!StrUtil.equals((CharSequence)barType, (CharSequence)UdcEnum.WS_WEBSITE_BAR_TYPE_NAV.getValueCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u6709PC\u5bfc\u822a\u680f\u53ef\u8fdb\u884c\u7ef4\u62a4");
        }
        List<WebsiteBarDO> doList = this.websiteBarRepoProc.findByBarTypeAndPidIsNull(barType);
        return WebsiteBarConvert.INSTANCE.dosUpBarVos(doList);
    }

    public WebsiteBarServiceImpl(WebsiteBarRepo websiteBarRepo, WebsiteBarRepoProc websiteBarRepoProc, SysGenerator sysGenerator) {
        this.websiteBarRepo = websiteBarRepo;
        this.websiteBarRepoProc = websiteBarRepoProc;
        this.sysGenerator = sysGenerator;
    }
}

