CREATE TABLE `sys_alert`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `business_type`      varchar(255) NOT NULL COMMENT '业务类型',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `description`        varchar(255) DEFAULT NULL COMMENT '描述',
    `tenant_id`          bigint(20)   DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uq_alert_bt` (`business_type`, `tenant_id`)
) COMMENT ='系统预警提醒';

CREATE TABLE `sys_alert_config`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `business_type`      varchar(255) NOT NULL COMMENT '业务类型',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `alert_type`         varchar(255) NOT NULL COMMENT '提醒方式',
    `cfg_json`           longtext COMMENT '配置内容',
    `description`        varchar(255) DEFAULT NULL COMMENT '说明',
    `tenant_id`          bigint(20)   DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_alert_cfg_bt` (`business_type`)
) COMMENT ='系统预警提醒配置';

alter table sys_platform_app add column std_product bit default 0 comment '是否标产内置';
alter table sys_platform_app add column std_version varchar(255) comment '标产版本';
alter table sys_currency_rate add column std_product bit default 0 comment '是否标产内置';
alter table sys_currency_rate add column std_version varchar(255) comment '标产版本';
alter table sys_msg_template add column std_product bit default 0 comment '是否标产内置';
alter table sys_msg_template add column std_version varchar(255) comment '标产版本';
alter table sys_msg_template_config add column std_product bit default 0 comment '是否标产内置';
alter table sys_msg_template_config add column std_version varchar(255) comment '标产版本';
alter table sys_platform_admin_menus add column std_product bit default 0 comment '是否标产内置';
alter table sys_platform_admin_menus add column std_version varchar(255) comment '标产版本';
alter table sys_platform_api_manage add column std_product bit default 0 comment '是否标产内置';
alter table sys_platform_api_manage add column std_version varchar(255) comment '标产版本';
alter table sys_platform_api_parameter add column std_product bit default 0 comment '是否标产内置';
alter table sys_platform_api_parameter add column std_version varchar(255) comment '标产版本';
alter table sys_platform_area add column std_product bit default 0 comment '是否标产内置';
alter table sys_platform_area add column std_version varchar(255) comment '标产版本';
alter table sys_platform_currency add column std_product bit default 0 comment '是否标产内置';
alter table sys_platform_currency add column std_version varchar(255) comment '标产版本';
alter table sys_platform_menus add column std_product bit default 0 comment '是否标产内置';
alter table sys_platform_menus add column std_version varchar(255) comment '标产版本';
alter table sys_platform_menus_api add column std_product bit default 0 comment '是否标产内置';
alter table sys_platform_menus_api add column std_version varchar(255) comment '标产版本';
alter table sys_platform_next_number add column std_product bit default 0 comment '是否标产内置';
alter table sys_platform_next_number add column std_version varchar(255) comment '标产版本';
alter table sys_platform_number_rule add column std_product bit default 0 comment '是否标产内置';
alter table sys_platform_number_rule add column std_version varchar(255) comment '标产版本';
alter table sys_platform_number_ruledtl add column std_product bit default 0 comment '是否标产内置';
alter table sys_platform_number_ruledtl add column std_version varchar(255) comment '标产版本';
alter table sys_platform_udc add column std_product bit default 0 comment '是否标产内置';
alter table sys_platform_udc add column std_version varchar(255) comment '标产版本';
alter table sys_platform_udc_value add column std_product bit default 0 comment '是否标产内置';
alter table sys_platform_udc_value add column std_version varchar(255) comment '标产版本';
alter table sys_resource_byte add column std_product bit default 0 comment '是否标产内置';
alter table sys_resource_byte add column std_version varchar(255) comment '标产版本';
alter table sys_setting add column std_product bit default 0 comment '是否标产内置';
alter table sys_setting add column std_version varchar(255) comment '标产版本';
alter table sys_tax_rate add column std_product bit default 0 comment '是否标产内置';
alter table sys_tax_rate add column std_version varchar(255) comment '标产版本';
alter table sys_tmpl add column std_product bit default 0 comment '是否标产内置';
alter table sys_tmpl add column std_version varchar(255) comment '标产版本';
