CREATE TABLE `sys_msg_template_receiver`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `template_id`        bigint(20)   DEFAULT NULL COMMENT '模板Id',
    `template_config_id` bigint(20)   DEFAULT NULL COMMENT '模板配置ID',
    `receiver_type`      varchar(255) NOT NULL COMMENT '接收人类型',
    `receiver_id`        bigint(20)   DEFAULT NULL COMMENT '接收人ID',
    `sort_no`            int(11)      DEFAULT '0' COMMENT '顺序',
    `tenant_id`          bigint(20)   DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint(20)   DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint(20)   DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_msg_tmpl_rer_tmplid` (`template_id`)
) COMMENT ='消息模板默认接收人';