CREATE TABLE `sys_custom_field_definition`
(
    `id`                                   bigint       NOT NULL COMMENT '记录唯一ID',
    `business_object_code`                 varchar(255) NOT NULL COMMENT '标识此字段所属的业务对象编码',
    `basic_module_code`                    varchar(255) NOT NULL COMMENT '标识此字段所属的模块或实体',
    `basic_name`                           varchar(255) NOT NULL COMMENT '用户界面显示的字段名',
    `basic_localized_name`                 varchar(255) NULL DEFAULT NULL COMMENT '支持多语言环境下的字段名称',
    `basic_key`                            varchar(255) NOT NULL COMMENT '数据库和API中使用的唯一键名',
    `basic_type`                           varchar(255) NOT NULL COMMENT '字段的数据类型',
    `basic_description`                    varchar(255) NULL DEFAULT NULL COMMENT '字段用途或输入要求的描述信息。',
    `basic_default_value`                  varchar(255) NULL DEFAULT NULL COMMENT '创建实体时的默认值',
    `basic_required`                       bit(1)       NULL DEFAULT NULL COMMENT '指示字段在创建或更新实体时是否必填',
    `basic_display_order`                  int          NULL DEFAULT NULL COMMENT '前端显示的排序顺序',
    `basic_status`                         varchar(255) NULL DEFAULT NULL COMMENT '字段是否启用',
    `display_type`                         varchar(255) NULL DEFAULT NULL COMMENT '展示类型指明了字段在前端UI中的展示方式',
    `display_options_json`                 json         NULL COMMENT '选项值，仅对枚举类型的字段适用，存储为JSON字符串',
    `display_multivalue`                   bit(1)       NULL DEFAULT NULL COMMENT '指示字段是否可以包含多个值',
    `display_group`                        varchar(255) NULL DEFAULT NULL COMMENT '字段分组名称，用于在UI中将相关字段组织在一起展示，以提高表单的可用性和逻辑性',
    `display_readonly`                     bit(1)       NULL DEFAULT NULL COMMENT '只读属性指示字段在UI中是否只能被显示而不能被修改',
    `display_visibility_condition_json`    json         NULL COMMENT '控制字段在UI中的可见性的条件，存储为JSON字符串',
    `display_ui_attributes_json`           json         NULL COMMENT ' UI组件属性，提供额外的配置以支持更复杂的前端UI控件，如指定日期选择器的格式，存储为JSON字符串',
    `display_linked_entity`                varchar(255) NULL DEFAULT NULL COMMENT '关联实体类型和关系。如果字段值指向另一个实体，该属性定义了所关联的实体类型。',
    `display_dynamic_attributes_json`      json         NULL COMMENT '动态属性，用于存储与字段类型相关的其他属性，如数值字段的最大值和最小值，存储为JSON字符串',
    `display_dependent_fields_json`        json         NULL COMMENT '依赖字段，存储为JSON字符串。当前字段的展示或值可能依赖于其他字段的状态或值。',
    `config_web_validation_pattern`        longtext     NULL COMMENT '前端校验模式数据存储',
    `config_web_extended_data`             longtext     NULL COMMENT '前端扩展数据存储',
    `config_web_function`                  longtext     NULL COMMENT '前端函数存储',
    `config_searchable`                    bit(1)       NULL DEFAULT NULL COMMENT '可搜索属性标记字段是否可以被用作搜索条件',
    `config_sortable`                      bit(1)       NULL DEFAULT NULL COMMENT '可排序属性指示字段是否可以用作列表排序的依据',
    `config_import_export`                 bit(1)       NULL DEFAULT NULL COMMENT '导入导出属性标记字段是否应包含在数据导入导出操作中',
    `config_access_control_json`           longtext     NULL COMMENT '权限控制，存储为JSON字符串',
    `config_track_history`                 bit(1)       NULL DEFAULT NULL COMMENT '历史记录属性指示是否追踪字段值的变更历史',
    `config_encrypted`                     bit(1)       NULL DEFAULT NULL COMMENT '数据加密属性标记',
    `config_sensitive`                     bit(1)       NULL DEFAULT NULL COMMENT '敏感数据标记',
    `config_autocomplete_suggestions_json` json         NULL COMMENT '自动填充建议属性',
    `tenant_id`                            bigint       NULL DEFAULT -1 COMMENT '所属租户ID',
    `belong_org_id`                        bigint       NULL DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`                        bigint       NULL DEFAULT NULL COMMENT '租户组织ID',
    `remark`                               varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`                       bigint       NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                              varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`                          datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`                       bigint       NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                              varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`                          datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`                          int          NULL DEFAULT 0 COMMENT '删除标记',
    `audit_data_version`                   int          NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                            bigint       NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`                          bigint       NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`                            bigint       NULL DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_custom_business_object_code` (`business_object_code` ASC) USING BTREE,
    INDEX `idx_custom_basic_module_code` (`basic_module_code` ASC) USING BTREE,
    INDEX `idx_custom_basic_key` (`basic_key` ASC) USING BTREE,
    INDEX `idx_custom_basic_type` (`basic_type` ASC) USING BTREE,
    INDEX `idx_custom_basic_status` (`basic_status` ASC) USING BTREE,
    INDEX `idx_custom_display_type` (`display_type` ASC) USING BTREE,
    INDEX `idx_custom_config_searchable` (`config_searchable` ASC) USING BTREE,
    INDEX `idx_custom_config_sortable` (`config_sortable` ASC) USING BTREE,
    INDEX `idx_custom_config_import_export` (`config_import_export` ASC) USING BTREE
) ENGINE = InnoDB COMMENT = '自定义字段定义表'
  ROW_FORMAT = Dynamic;

