package com.elitescloud.cloudt.customfield.service;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-03-18 16:33
 */
import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.customfield.entity.CustomFieldDefinitionDo;
import com.elitescloud.cloudt.customfield.entity.QCustomFieldDefinitionDo;
import com.elitescloud.cloudt.customfield.model.CustomFieldDefinitionSaveParam;
import com.elitescloud.cloudt.customfield.model.CustomFieldDefinitionUpdateParam;
import com.elitescloud.cloudt.customfield.model.CustomFieldQueryParam;
import com.querydsl.core.types.Predicate;
import org.springframework.util.StringUtils;

import java.util.List;


/**
 * 管理自定义字段的服务接口。
 */
public interface CustomFieldDefinitionService {
    static Predicate getPredicateByCustomFieldQueryParam(CustomFieldQueryParam customFieldParam){
        var QDO = QCustomFieldDefinitionDo.customFieldDefinitionDo;
        var predicate = JpaPredicateBuilder.builder()
                .and(QDO.basicName::like, StringUtils.hasText(customFieldParam.getBasicName()) ? "%" + customFieldParam.getBasicName() + "%" : null)
                .and(QDO.basicModuleCode::eq, customFieldParam.getBasicModuleCode())
                .and(QDO.basicKey::eq, customFieldParam.getBasicKey())
                .and(QDO.businessObjectCode::eq, customFieldParam.getBusinessObjectCode())
                .getPredicate();
        return predicate;
    }
    /**
     * 创建自定义字段。
     * @param customField 自定义字段定义保存参数。
     * @return 返回创建成功的自定义字段的ID。
     */
    ApiResult<Long> createCustomField(CustomFieldDefinitionSaveParam customField);

    /**
     * 更新自定义字段。
     * @param id 自定义字段的ID。
     * @param customField 自定义字段定义更新参数。
     * @return 返回更新操作的结果。
     */
    ApiResult updateCustomField(Long id, CustomFieldDefinitionUpdateParam customField);

    /**
     * 根据ID获取自定义字段定义。
     * @param id 自定义字段的ID。
     * @return 返回自定义字段的定义对象。
     */
    CustomFieldDefinitionDo getCustomFieldById(Long id);

    /**
     * 根据ID删除自定义字段。
     * @param id 自定义字段的ID。
     */
    void deleteCustomField(Long id);

    /**
     * 搜索自定义字段。
     * @param customFieldParam 自定义字段查询参数。
     * @return 返回自定义字段的分页视图对象。
     */
    PagingVO<CustomFieldDefinitionDo> searchCustomFields(CustomFieldQueryParam customFieldParam);

    /**
     * 根据代码获取自定义字段定义。
     * @param code 自定义字段的代码。
     * @return 返回匹配的自定义字段定义对象。
     */
    CustomFieldDefinitionDo getCustomFieldByCode(String code);

    /**
     * 删除旧的自定义字段并创建新的自定义字段。
     * @param businessObjectCode 业务对象代码。
     * @param param 自定义字段定义保存参数列表。
     * @return 返回创建成功的自定义字段的ID。
     */
    ApiResult<Long> deleteAndCreateCustomField(String businessObjectCode, List<CustomFieldDefinitionSaveParam> param);

}
