package com.elitescloud.cloudt.system.common;

import cn.hutool.core.util.ObjectUtil;
import lombok.Getter;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 17:19
 * @Description:
 */
@Getter
public enum MediaType {


    /**
     * 媒体类型
     */
    MIME_NONE("", "none"),
    MIME_MULTIPART_FORM_DATA("multipart/form-data", "form-data"),
    MIME_FORM_URLENCODED("application/x-www-form-urlencoded", "x-www-form-urlencoded"),
    MIME_JSON_UTF8("application/json", "json"),
    MIME_TEXT_PLAIN("text/plain", "text"),
    ;

    private final String code;
    private final String desc;

    MediaType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String fromCode(String code) {
        if (ObjectUtil.isNull(code)) return null;
        for (MediaType status : MediaType.values()) {
            if (status.getCode().equals(code)) {
                return status.getDesc();
            }
        }
        return "";
    }
}
