package com.elitescloud.cloudt.system.common;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 模板消息接收人类型.
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/20
 */
public enum MsgTemplateReceiverEnum {

    /**
     * 用户账号
     */
    USER,

    /**
     * 员工
     */
    EMPLOYEE,

    /**
     * 角色
     */
    ROLE,
    ;

    private static final Map<String, MsgTemplateReceiverEnum> ALL = Arrays.stream(MsgTemplateReceiverEnum.values())
            .collect(Collectors.toMap(MsgTemplateReceiverEnum::name, t -> t, (t1, t2) -> t1));

    /**
     * 解析
     *
     * @param value 值
     * @return 周期
     */
    public static MsgTemplateReceiverEnum parse(String value) {
        if (value == null) {
            return null;
        }
        return ALL.get(value);
    }
}
