package com.elitescloud.cloudt.system.config.support.userouterapp;

import cn.hutool.core.text.CharSequenceUtil;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.elitescloud.boot.auth.provider.common.AlipayAppProvider;
import com.elitescloud.boot.auth.provider.provider.alipay.AlipayTemplate;
import com.elitescloud.cloudt.system.service.common.service.UserOuterAppProvider;
import com.elitescloud.cloudt.system.service.dto.SysUserOuterAppDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * 支付宝的用户信息提供者.
 *
 * @author Kaiser（wang shao）
 * @date 2025/2/12
 */
@Component
@ConditionalOnMissingBean(name = "alipayUserOuterAppProvider")
public class AlipayUserOuterAppProvider implements UserOuterAppProvider {
    private static final Logger logger = LoggerFactory.getLogger(AlipayUserOuterAppProvider.class);

    @Autowired
    private AlipayAppProvider alipayAppProvider;
    @Autowired
    private AlipayTemplate alipayTemplate;

    @Override
    public SysUserOuterAppDTO get(String appId, HttpServletRequest request) {
        var app = alipayAppProvider.getApp(appId);
        if (app == null) {
            return null;
        }

        // 授权码
        String code = request.getParameter("code");
        if (CharSequenceUtil.isBlank(code)) {
            logger.info("支付宝授权码为空");
            return null;
        }

        // 根据授权码查询openId
        AlipaySystemOauthTokenResponse oauthTokenResponse = alipayTemplate.oauthToken(appId, code);

        SysUserOuterAppDTO outerAppDTO = new SysUserOuterAppDTO();
        if (app.isPreferUserId()) {
            outerAppDTO.setOpenId(CharSequenceUtil.blankToDefault(oauthTokenResponse.getUserId(), oauthTokenResponse.getOpenId()));
        } else {
            outerAppDTO.setOpenId(oauthTokenResponse.getOpenId());
        }
        outerAppDTO.setUnionId(oauthTokenResponse.getUnionId());
        return outerAppDTO;
    }
}
