package com.elitescloud.cloudt.system.controller.mng.extend;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.common.ActiveStatus;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ApiQueryParamVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ApiSaveParamVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityApiDetailVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityApiRespVO;
import com.elitescloud.cloudt.system.service.InfinityApiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 15:50
 * @Description:
 */
@Slf4j
@Api(tags = "接口定义")
@RestController
@RequestMapping("/infinity/server/api")
@AllArgsConstructor
public class InfinityApiController {


    private final InfinityApiService apiService;

    @ApiOperation(value = "不分页查询")
    @PostMapping(value = "/query")
    public ApiResult<List<InfinityApiRespVO>> query(@RequestBody @Valid ApiQueryParamVO query) {
        log.info("[InfinityApi] query list param = {}", query);
        return ApiResult.ok(apiService.infinityApiByParam(query));
    }

    @ApiOperation(value = "明细查询")
    @GetMapping(value = "/detail/{id}")
    public ApiResult<InfinityApiDetailVO> detail(@PathVariable("id") Long id) {
        log.info("[InfinityApi] query detail by id = {}", id);
        return ApiResult.ok(apiService.infinityApiById(id));
    }

    @ApiOperation(value = "新增或修改")
    @PostMapping(value = "/save")
    public ApiResult<Long> save(@RequestBody @Valid ApiSaveParamVO saveParam) {
        log.info("[InfinityApi] create/update record, saveParam = {}", saveParam);
        return ApiResult.ok(apiService.save(saveParam));
    }

    @ApiOperation(value = "启用")
    @PatchMapping(value = "/{id}/v")
    public ApiResult<Void> active(@PathVariable("id") Long id) {
        log.info("[InfinityApi] active by id = {}", id);
        apiService.updateStatus(id, ActiveStatus.ACTIVE.getCode());
        return ApiResult.ok();
    }

    @ApiOperation(value = "禁用")
    @PatchMapping(value = "/{id}/x")
    public ApiResult<Void> inactive(@PathVariable("id") Long id) {
        log.info("[InfinityApi] inactive by id = {}", id);
        apiService.updateStatus(id, ActiveStatus.INACTIVE.getCode());
        return ApiResult.ok();
    }

    @ApiOperation(value = "批量物理删除")
    @DeleteMapping(value = "/delete")
    public ApiResult<Long> delete(@RequestBody List<Long> ids) {
        log.info("[InfinityApi] batch physical delete by ids = {}", ids);
        return ApiResult.ok(apiService.delete(ids));
    }
}
