package com.elitescloud.cloudt.system.controller.mng.extend;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.common.EnumValues;
import com.elitescloud.cloudt.system.service.AuthMethodService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/12/18 13:54
 * @Description:
 */
@Slf4j
@Api(tags = "通用接口")
@RestController
@RequestMapping("/infinity/common")
@AllArgsConstructor
public class InfinityCommonApi {

    private final AuthMethodService authMethodService;

    @ApiOperation(value = "认证方式")
    @GetMapping(value = "/auth_method")
    public ApiResult<List<EnumValues>> authMethod() {
        return ApiResult.ok(authMethodService.authMethod());
    }
}
