package com.elitescloud.cloudt.system.controller.mng.extend;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.extend.FolderSaveParamVO;
import com.elitescloud.cloudt.system.service.InfinityFolderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 17:50
 * @Description:
 */
@Slf4j
@Api(tags = "接口分组")
@RestController
@RequestMapping("/infinity/server/folder")
@AllArgsConstructor
public class InfinityFolderController {
    private final InfinityFolderService folderService;

    @ApiOperation(value = "新增或修改")
    @PostMapping(value = "/save")
    public ApiResult<Long> save(@RequestBody @Valid FolderSaveParamVO saveParam) {
        log.info("[InfinityFolder] create/update record, saveParam = {}", saveParam);
        return ApiResult.ok(folderService.save(saveParam));
    }

    @ApiOperation(value = "批量物理删除")
    @DeleteMapping(value = "/delete")
    public ApiResult<Void> delete(@RequestBody List<Long> ids) {
        log.info("[InfinityFolder] batch physical delete by ids = {}", ids);
        folderService.delete(ids);
        return ApiResult.ok();
    }
}
