package com.elitescloud.cloudt.system.controller.mng.extend;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.entity.SysPageFieldConfigDO;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysPageFieldConfigDtlParam;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysPageFieldConfigDtlQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysPageFieldConfigQueryVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.SysPageFieldConfigSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.SysPageFieldConfigUpdateVO;
import com.elitescloud.cloudt.system.service.SysPageFieldConfigService;
import com.elitescloud.cloudt.system.constant.BusinessObjectConstant;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @author niuchen
 * &#064;date  2023/8/8
 */
@Api(tags = "页面字段配置")
@RestController
@RequestMapping(value = "/mng/page/field/config", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@BusinessObject(businessType = BusinessObjectConstant.SYS_PAGE_FIELD_CONFIG, businessDoClass = SysPageFieldConfigDO.class)
public class SysPageFieldConfigController {
    private final SysPageFieldConfigService service;

    public SysPageFieldConfigController(
            SysPageFieldConfigService sysPageFieldConfigService) {
        this.service = sysPageFieldConfigService;
    }

    /**
     * 保存配置
     *
     * @param saveVO 配置信息
     * @return 保存结果
     */
    @ApiOperation(value = "添加页面字段配置信息")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/save")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE, operationDescription = "保存配置信息"
            , logEnabled = true, resultJsonEnabled = true, argsJsonEnabled = true)
    public ApiResult<String> savePageFieldConfig(
            @RequestBody @Valid SysPageFieldConfigSaveVO saveVO) {
        return service.savePageFieldConfig(saveVO);
    }


    /**
     * 修改配置
     * 修改主信息，明细信息全删全插
     *
     * @param updateVO 配置信息
     * @return 保存结果
     */
    @ApiOperation(value = "更新页面字段配置信息")
    @ApiOperationSupport(order = 2)
    @PostMapping(value = "/update/{id}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.UPDATE, operationDescription = "更新配置"
            , logEnabled = true, resultJsonEnabled = true, argsJsonEnabled = true)
    public ApiResult<Boolean> updatePageFieldConfig(@PathVariable Long id,
                                                    @RequestBody @Valid SysPageFieldConfigUpdateVO updateVO) {
        return service.updatePageFieldConfig(id, updateVO);
    }


    /**
     * 分页检索，明细维度
     *
     * @param param 配置信息
     * @return 保存结果
     */
    @ApiOperation(value = "分页查询页面字段配置信息")
    @ApiOperationSupport(order = 3)
    @PostMapping(value = "/queryPageFieldConfigDtl")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "分页查询配置"
    )
    public ApiResult<PagingVO<SysPageFieldConfigDtlQueryVO>> queryPageFieldConfigDtl(
            @RequestBody @Valid SysPageFieldConfigDtlParam param) {
        return service.queryPageFieldConfigDtl(param);
    }


    /**
     * 根据配置编码查询页面字段配置信息
     *
     * @param configCode 配置编码
     * @return 保存结果
     */
    @ApiOperation(value = "根据配置编码查询页面字段配置信息")
    @ApiOperationSupport(order = 4)
    @GetMapping(value = "/select/{configCode}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT, operationDescription = "查询配置信息"
    )
    public ApiResult<SysPageFieldConfigQueryVO> getPageFieldConfig(
            @PathVariable String configCode) {
        return service.getPageFieldConfig(configCode);
    }

    /**
     * 删除页面字段配置信息包括全部字段
     *
     * @param id 编码
     * @return 保存结果
     */
    @ApiOperation(value = "删除页面字段配置信息包括全部字段")
    @ApiOperationSupport(order = 5)
    @DeleteMapping(value = "/delete/{id}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.DELETE, operationDescription = "删除页面字段配置"
            , logEnabled = true, resultJsonEnabled = true, argsJsonEnabled = true)
    public ApiResult<Boolean> deletePageFieldConfig(
            @PathVariable Long id) {
        return service.deletePageFieldConfig(id);
    }

    /**
     * 删除页面字段配置中的一个字段配置
     *
     * @param id 编码
     * @return 结果
     */
    @ApiOperation(value = "删除页面字段配置中的一个字段配置")
    @ApiOperationSupport(order = 6)
    @DeleteMapping(value = "/delete/dtl/{id}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.DELETE, operationDescription = "删除页面字段"
            , logEnabled = true, resultJsonEnabled = true, argsJsonEnabled = true)
    public ApiResult<Boolean> deletePageFieldConfigDtl(
            @PathVariable Long id) {
        return service.deletePageFieldConfigDtl(id);
    }

    /**
     * 删除页面字段配置中的一个字段配置
     *
     * @param ids 编码
     * @return 结果
     */
    @ApiOperation(value = "批量删除页面字段配置中字段配置")
    @ApiOperationSupport(order = 6)
    @DeleteMapping(value = "/dtl/batchDelete")
    @BusinessObjectOperation(operationType = OperationTypeEnum.DELETE, operationDescription = "删除页面字段"
            , logEnabled = true, resultJsonEnabled = true, argsJsonEnabled = true)
    public ApiResult<Boolean> batchDeletePageFieldConfigDtl(
            @RequestBody List<Long> ids) {
        return service.batchDeletePageFieldConfigDtl(ids);
    }
}
