package com.elitescloud.cloudt.system.controller.mng.org;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.org.OuPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OuDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OuPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.org.OuSaveVO;
import com.elitescloud.cloudt.system.service.OuMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 公司管理.
 *
 * @author Kaiser（wang shao）
 * 2023/1/13
 */
@Api(tags = "公司管理")
@RestController
@RequestMapping(value = "/mng/ou", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class OuMngController {

    private final OuMngService service;

    public OuMngController(OuMngService service) {
        this.service = service;
    }

    /**
     * 分页查询公司
     *
     * @param queryVO 查询参数
     * @return 公司列表
     */
    @PostMapping(value = "/page")
    @ApiOperation(value = "分页查询公司")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<OuPageRespVO>> page(@RequestBody OuPageQueryVO queryVO) {
        return service.page(queryVO);
    }

    /**
     * 切换启用禁用
     *
     * @param id 公司ID
     * @return 切换结果
     */
    @PatchMapping(value = "/switch/{id}/enabled")
    @ApiOperation(value = "切换启用禁用")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParam(name = "id", value = "公司ID", required = true)
    public ApiResult<Long> switchEnabled(@PathVariable("id") Long id) {
        return service.updateEnabled(id);
    }

    /**
     * 获取公司详情
     *
     * @param id 公司ID
     * @return 公司详情
     */
    @GetMapping(value = "/{id}")
    @ApiOperation(value = "获取公司详情")
    @ApiOperationSupport(order = 3)
    @ApiImplicitParam(name = "id", value = "公司ID", required = true)
    public ApiResult<OuDetailRespVO> get(@PathVariable("id") Long id) {
        return service.get(id);
    }

    /**
     * 保存公司
     *
     * @param saveVO 公司信息
     * @return 公司ID
     */
    @PostMapping(value = "/save")
    @ApiOperation(value = "保存公司")
    @ApiOperationSupport(order = 4)
    public ApiResult<Long> save(@RequestBody @Valid OuSaveVO saveVO) {
        return service.save(saveVO);
    }

    /**
     * 删除公司信息
     *
     * @param id 公司ID
     * @return 公司ID
     */
    @DeleteMapping(value = "/{id}")
    @ApiOperation(value = "删除公司信息")
    @ApiOperationSupport(order = 5)
    @ApiImplicitParam(name = "id", value = "公司ID", required = true)
    public ApiResult<Long> delete(@PathVariable("id") Long id) {
        return service.delete(id);
    }
}
